# Generated by Django 2.2.10 on 2020-03-08 20:22

from django.db import migrations

from bpp.models.autor import autor_split_string


def napraw_autorow_bez_nazwisk(apps, schema_editor):
    Autor = apps.get_model("bpp", "Autor")
    for elem in Autor.objects.filter(nazwisko=""):
        try:
            nazwisko, imiona = autor_split_string(elem.imiona)
        except ValueError:
            nazwisko, imiona = (elem.imiona, "[nie określono]")

        elem.nazwisko = nazwisko
        elem.imiona = imiona
        elem.save()


class Migration(migrations.Migration):

    dependencies = [
        ("bpp", "0201_rekord_mat_z_www"),
    ]

    operations = [migrations.RunPython(napraw_autorow_bez_nazwisk)]
