# Generated by Django 2.1.7 on 2019-08-04 18:00

from django.db import migrations, models
import django.db.models.deletion

from bpp.migration_util import load_custom_sql


class Migration(migrations.Migration):

    dependencies = [
        ('bpp', '0169_dyscyplina_change_trigger_cacher'),
    ]

    operations = [
        migrations.CreateModel(
            name='Poziom_Wydawcy',
            fields=[
                ('id', models.AutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('rok', models.IntegerField()),
                ('poziom', models.PositiveSmallIntegerField(choices=[(None, 'nieokreślono'), (1, 'poziom I'), (2, 'poziom II')])),
            ],
        ),
        migrations.CreateModel(
            name='Wydawca',
            fields=[
                ('id', models.AutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('nazwa', models.CharField(max_length=512, unique=True)),
            ],
            options={
                'ordering': ['nazwa'],
                'abstract': False,
            },
        ),
        migrations.RenameField(
            model_name='praca_doktorska',
            old_name='wydawnictwo',
            new_name='wydawca_opis',
        ),
        migrations.RenameField(
            model_name='praca_habilitacyjna',
            old_name='wydawnictwo',
            new_name='wydawca_opis',
        ),
        migrations.RenameField(
            model_name='wydawnictwo_zwarte',
            old_name='wydawnictwo',
            new_name='wydawca_opis',
        ),
        migrations.AddField(
            model_name='poziom_wydawcy',
            name='wydawca',
            field=models.ForeignKey(on_delete=django.db.models.deletion.CASCADE, to='bpp.Wydawca'),
        ),
        migrations.AddField(
            model_name='praca_doktorska',
            name='wydawca',
            field=models.ForeignKey(blank=True, null=True, on_delete=django.db.models.deletion.PROTECT, to='bpp.Wydawca'),
        ),
        migrations.AddField(
            model_name='praca_habilitacyjna',
            name='wydawca',
            field=models.ForeignKey(blank=True, null=True, on_delete=django.db.models.deletion.PROTECT, to='bpp.Wydawca'),
        ),
        migrations.AddField(
            model_name='wydawnictwo_zwarte',
            name='wydawca',
            field=models.ForeignKey(blank=True, null=True, on_delete=django.db.models.deletion.PROTECT, to='bpp.Wydawca'),
        ),
        migrations.AlterUniqueTogether(
            name='poziom_wydawcy',
            unique_together={('rok', 'wydawca')},
        ),
        migrations.RunPython(
            lambda *args, **kw: load_custom_sql("0170_wydawnictwo_wydawca")
        ),

    ]
