# -*- coding: utf-8 -*-
# Generated by Django 1.10.7 on 2017-07-19 10:20
from __future__ import unicode_literals

from django.db import migrations, models
import django.db.models.deletion

def dodaj(apps, schema_editor):
    eksport_pbn_TYP_KBN_MAP = {
        'PO': 'original-article',
        'PW': 'original-article',
        'PP': 'review-article',
        'PNP': 'popular-science-article',
        '000': 'others-citable'
    }
    Typ_KBN = apps.get_model("bpp", "Typ_KBN")
    Charakter_PBN = apps.get_model("bpp", "Charakter_PBN")
    for key, value in eksport_pbn_TYP_KBN_MAP.items():
        t = Typ_KBN.objects.get(skrot=key)
        cp = Charakter_PBN.objects.get(identyfikator=value)
        t.charakter_pbn = cp
        t.save()


class Migration(migrations.Migration):

    dependencies = [
        ('bpp', '0090_pbn_id_dla_prac'),
    ]

    operations = [
        migrations.AddField(
            model_name='typ_kbn',
            name='charakter_pbn',
            field=models.ForeignKey(blank=True, default=None, help_text='Wartość wybrana w tym polu zostanie użyta jako \n        fallback, tzn. jeżeli dla charakteru formalnego danego rekordu nie \n        określono odpowiedniego charakteru PBN, to zostanie użyta wartość \n        tego pola, o ile wybrana. ', null=True, on_delete=django.db.models.deletion.CASCADE, to='bpp.Charakter_PBN', verbose_name='Charakter PBN'),
        ),
        migrations.RunPython(
            dodaj,
            migrations.RunPython.noop
        )
    ]
