# -*- coding: utf-8 -*-


from django.db import models, migrations
import datetime
import autoslug.fields
from decimal import Decimal
from django.db.migrations.operations.special import RunPython, RunSQL
import django.utils.timezone
from django.contrib.postgres.search import SearchVectorField
from django.contrib.postgres.fields import ArrayField
import django.core.validators
from bpp.migration_util import load_custom_sql


class Migration(migrations.Migration):

    dependencies = [
        ('contenttypes', '__first__'),
        ('auth', '__first__'),
    ]

    operations = [
        RunPython(
            lambda *args, **kw: load_custom_sql("0001_collation")),

        migrations.CreateModel(
            name='BppUser',
            fields=[
                ('id', models.AutoField(verbose_name='ID', serialize=False, auto_created=True, primary_key=True)),
                ('password', models.CharField(max_length=128, verbose_name='password')),
                ('last_login', models.DateTimeField(default=django.utils.timezone.now, verbose_name='last login')),
                ('is_superuser', models.BooleanField(default=False, help_text='Designates that this user has all permissions without explicitly assigning them.', verbose_name='superuser status')),
                ('username', models.CharField(help_text='Required. 30 characters or fewer. Letters, digits and @/./+/-/_ only.', unique=True, max_length=30, verbose_name='username', validators=[django.core.validators.RegexValidator('^[\\w.@+-]+$', 'Enter a valid username.', 'invalid')])),
                ('first_name', models.CharField(max_length=30, verbose_name='first name', blank=True)),
                ('last_name', models.CharField(max_length=30, verbose_name='last name', blank=True)),
                ('email', models.EmailField(max_length=75, verbose_name='email address', blank=True)),
                ('is_staff', models.BooleanField(default=False, help_text='Designates whether the user can log into this admin site.', verbose_name='staff status')),
                ('is_active', models.BooleanField(default=True, help_text='Designates whether this user should be treated as active. Unselect this instead of deleting accounts.', verbose_name='active')),
                ('date_joined', models.DateTimeField(default=django.utils.timezone.now, verbose_name='date joined')),
                ('ostatnio_zmieniony', models.DateTimeField(auto_now=True, auto_now_add=True, null=True, db_index=True)),
                ('adnotacje', models.TextField(help_text=b'Pole do u\xc5\xbcytku wewn\xc4\x99trznego -\n    wpisane tu informacje nie s\xc4\x85 wy\xc5\x9bwietlane na stronach WWW dost\xc4\x99pnych\n    dla u\xc5\xbcytkownik\xc3\xb3w ko\xc5\x84cowych.', null=True, db_index=True, blank=True)),
                ('active_charmap_tab', models.IntegerField(default=0)),
                ('per_page', models.IntegerField(default=20, verbose_name=b'Ilo\xc5\x9b\xc4\x87 wy\xc5\x9bwietlanych rekord\xc3\xb3w na stronie')),
                ('multiseek_format', models.CharField(max_length=200, null=True, verbose_name=b'Ostatnio wybrany format wy\xc5\x9bwietlania w Multiseeku', blank=True)),
                ('multiseek_order_1', models.CharField(max_length=200, null=True, verbose_name=b'Ostatnio wybrane pole sortowania w Multiseeku', blank=True)),
                ('groups', models.ManyToManyField(to='auth.Group', verbose_name='groups', blank=True)),
                ('user_permissions', models.ManyToManyField(to='auth.Permission', verbose_name='user permissions', blank=True)),
            ],
            options={
            },
            bases=(models.Model,),
        ),
        migrations.CreateModel(
            name='Autor',
            fields=[
                ('id', models.AutoField(verbose_name='ID', serialize=False, auto_created=True, primary_key=True)),
                ('ostatnio_zmieniony', models.DateTimeField(auto_now=True, auto_now_add=True, null=True, db_index=True)),
                ('adnotacje', models.TextField(help_text=b'Pole do u\xc5\xbcytku wewn\xc4\x99trznego -\n    wpisane tu informacje nie s\xc4\x85 wy\xc5\x9bwietlane na stronach WWW dost\xc4\x99pnych\n    dla u\xc5\xbcytkownik\xc3\xb3w ko\xc5\x84cowych.', null=True, db_index=True, blank=True)),
                ('imiona', models.CharField(max_length=512, db_index=True)),
                ('nazwisko', models.CharField(max_length=256, db_index=True)),
                ('pokazuj_na_stronach_jednostek', models.BooleanField(default=True)),
                ('email', models.EmailField(max_length=128, null=True, verbose_name=b'E-mail', blank=True)),
                ('www', models.URLField(max_length=1024, null=True, verbose_name=b'WWW', blank=True)),
                ('urodzony', models.DateField(null=True, blank=True)),
                ('zmarl', models.DateField(null=True, blank=True)),
                ('poprzednie_nazwiska', models.CharField(help_text=b'Je\xc5\xbceli ten\n        autor(-ka) posiada nazwisko panie\xc5\x84skie, pod kt\xc3\xb3rym ukazywa\xc5\x82y\n        si\xc4\x99 publikacje lub zmienia\xc5\x82 nazwisko z innych powod\xc3\xb3w, wpisz tutaj\n        wszystkie poprzednie nazwiska, oddzielaj\xc4\x85c je przecinkami.', max_length=1024, null=True, db_index=True, blank=True)),
                ('search', SearchVectorField(default=b'', serialize=False, null=True, editable=False, db_index=True)),
                ('slug', autoslug.fields.AutoSlugField(unique=True, max_length=1024, editable=False)),
                ('sort', models.TextField()),
            ],
            options={
                'ordering': [b'sort'],
                'verbose_name': b'autor',
                'verbose_name_plural': b'autorzy',
            },
            bases=(models.Model,),
        ),
        migrations.CreateModel(
            name='Autor_Jednostka',
            fields=[
                ('id', models.AutoField(verbose_name='ID', serialize=False, auto_created=True, primary_key=True)),
                ('rozpoczal_prace', models.DateField(db_index=True, null=True, verbose_name=b'Rozpocz\xc4\x85\xc5\x82 prac\xc4\x99', blank=True)),
                ('zakonczyl_prace', models.DateField(db_index=True, null=True, verbose_name=b'Zako\xc5\x84czy\xc5\x82 prac\xc4\x99', blank=True)),
                ('autor', models.ForeignKey(to='bpp.Autor', on_delete=models.CASCADE)),
            ],
            options={
                'ordering': [b'autor__nazwisko', b'jednostka__nazwa', b'rozpoczal_prace'],
                'verbose_name': b'powi\xc4\x85zanie autor-jednostka',
                'verbose_name_plural': b'powi\xc4\x85zania autor-jednostka',
            },
            bases=(models.Model,),
        ),
        migrations.CreateModel(
            name='Charakter_Formalny',
            fields=[
                ('id', models.AutoField(verbose_name='ID', serialize=False, auto_created=True, primary_key=True)),
                ('nazwa', models.CharField(unique=True, max_length=512)),
                ('skrot', models.CharField(unique=True, max_length=128)),
                ('publikacja', models.BooleanField(default=False, help_text=b'Jest charakterem dla publikacji')),
                ('streszczenie', models.BooleanField(default=False, help_text=b'Jest charakterem dla streszcze\xc5\x84')),
            ],
            options={
                'ordering': [b'nazwa'],
                'verbose_name': b'charakter formalny',
                'verbose_name_plural': b'charaktery formalne',
            },
            bases=(models.Model,),
        ),
        migrations.CreateModel(
            name='Funkcja_Autora',
            fields=[
                ('id', models.AutoField(verbose_name='ID', serialize=False, auto_created=True, primary_key=True)),
                ('nazwa', models.CharField(unique=True, max_length=512)),
                ('skrot', models.CharField(unique=True, max_length=128)),
            ],
            options={
                'ordering': [b'nazwa'],
                'verbose_name': b'funkcja w jednostce',
                'verbose_name_plural': b'funkcje w jednostkach',
            },
            bases=(models.Model,),
        ),
        migrations.AddField(
            model_name='autor_jednostka',
            name='funkcja',
            field=models.ForeignKey(blank=True, to='bpp.Funkcja_Autora', null=True, on_delete=models.CASCADE),
            preserve_default=True,
        ),
        migrations.CreateModel(
            name='Jednostka',
            fields=[
                ('id', models.AutoField(verbose_name='ID', serialize=False, auto_created=True, primary_key=True)),
                ('ostatnio_zmieniony', models.DateTimeField(auto_now=True, auto_now_add=True, null=True, db_index=True)),
                ('adnotacje', models.TextField(help_text=b'Pole do u\xc5\xbcytku wewn\xc4\x99trznego -\n    wpisane tu informacje nie s\xc4\x85 wy\xc5\x9bwietlane na stronach WWW dost\xc4\x99pnych\n    dla u\xc5\xbcytkownik\xc3\xb3w ko\xc5\x84cowych.', null=True, db_index=True, blank=True)),
                ('rozpoczecie_funkcjonowania', models.DateField(null=True, verbose_name=b'Rozpocz\xc4\x99cie funkcjonowania', blank=True)),
                ('zakonczenie_funkcjonowania', models.DateField(null=True, verbose_name=b'Zako\xc5\x84czenie funkcjonowania', blank=True)),
                ('nazwa', models.CharField(unique=True, max_length=512)),
                ('skrot', models.CharField(unique=True, max_length=128, verbose_name=b'Skr\xc3\xb3t')),
                ('opis', models.TextField(null=True, blank=True)),
                ('slug', autoslug.fields.AutoSlugField(unique=True, editable=False)),
                ('widoczna', models.BooleanField(default=True, db_index=True)),
                ('wchodzi_do_raportow', models.BooleanField(default=True, db_index=True, verbose_name=b'Wchodzi do raport\xc3\xb3w')),
                ('email', models.EmailField(max_length=128, null=True, verbose_name=b'E-mail', blank=True)),
                ('www', models.URLField(max_length=1024, null=True, verbose_name=b'WWW', blank=True)),
                ('search', SearchVectorField(default=b'', serialize=False, null=True, editable=False, db_index=True)),
            ],
            options={
                'ordering': ['nazwa'],
                'verbose_name': b'jednostka',
                'verbose_name_plural': b'jednostki',
            },
            bases=(models.Model,),
        ),
        migrations.AddField(
            model_name='autor_jednostka',
            name='jednostka',
            field=models.ForeignKey(to='bpp.Jednostka', on_delete=models.CASCADE),
            preserve_default=True,
        ),
        migrations.AlterUniqueTogether(
            name='autor_jednostka',
            unique_together=set([('autor', 'jednostka', 'rozpoczal_prace')]),
        ),
        migrations.AddField(
            model_name='autor',
            name='jednostki',
            field=models.ManyToManyField(to='bpp.Jednostka', through='bpp.Autor_Jednostka'),
            preserve_default=True,
        ),
        migrations.AddField(
            model_name='autor',
            name='aktualna_jednostka',
            field=models.ForeignKey(blank=True, to='bpp.Jednostka', null=True, on_delete=models.CASCADE),
            preserve_default=True,
        ),
        migrations.CreateModel(
            name='Jezyk',
            fields=[
                ('id', models.AutoField(verbose_name='ID', serialize=False, auto_created=True, primary_key=True)),
                ('nazwa', models.CharField(unique=True, max_length=512)),
                ('skrot', models.CharField(unique=True, max_length=128)),
            ],
            options={
                'ordering': ['nazwa'],
                'verbose_name': b'j\xc4\x99zyk',
                'verbose_name_plural': b'j\xc4\x99zyki',
            },
            bases=(models.Model,),
        ),
        migrations.CreateModel(
            name='Opi_2012_Afiliacja_Do_Wydzialu',
            fields=[
                ('id', models.AutoField(verbose_name='ID', serialize=False, auto_created=True, primary_key=True)),
                ('rok', models.IntegerField(db_index=True)),
                ('autor', models.ForeignKey(to='bpp.Autor', on_delete=models.CASCADE)),
            ],
            options={
            },
            bases=(models.Model,),
        ),
        migrations.CreateModel(
            name='Opi_2012_Tytul_Cache',
            fields=[
                ('id', models.AutoField(verbose_name='ID', serialize=False, auto_created=True, primary_key=True)),
                ('tytul_oryginalny_cache', models.TextField(db_index=True)),
            ],
            options={
            },
            bases=(models.Model,),
        ),
        migrations.CreateModel(
            name='Patent',
            fields=[
                ('id', models.AutoField(verbose_name='ID', serialize=False, auto_created=True, primary_key=True)),
                ('opis_bibliograficzny_cache', models.TextField(default=b'')),
                ('opis_bibliograficzny_autorzy_cache', ArrayField(models.TextField())),
                ('opis_bibliograficzny_zapisani_autorzy_cache', models.TextField(default=b'')),
                ('ostatnio_zmieniony', models.DateTimeField(auto_now=True, auto_now_add=True, null=True, db_index=True)),
                ('adnotacje', models.TextField(help_text=b'Pole do u\xc5\xbcytku wewn\xc4\x99trznego -\n    wpisane tu informacje nie s\xc4\x85 wy\xc5\x9bwietlane na stronach WWW dost\xc4\x99pnych\n    dla u\xc5\xbcytkownik\xc3\xb3w ko\xc5\x84cowych.', null=True, db_index=True, blank=True)),
                ('rok', models.IntegerField(help_text=b'Rok uwzgl\xc4\x99dniany przy wyszukiwaniu i raportach\n        KBN/MNiSW)', db_index=True)),
                ('www', models.URLField(max_length=1024, null=True, verbose_name=b'Adres WWW', blank=True)),
                ('afiliowana', models.BooleanField(default=False)),
                ('recenzowana', models.BooleanField(default=False)),
                ('impact_factor', models.DecimalField(default=Decimal('0.000'), max_digits=6, decimal_places=3, db_index=True)),
                ('punkty_kbn', models.DecimalField(default=Decimal('0.00'), verbose_name=b'Punkty KBN', max_digits=6, decimal_places=2, db_index=True)),
                ('index_copernicus', models.DecimalField(default=Decimal('0.00'), verbose_name=b'Index Copernicus', max_digits=6, decimal_places=2, db_index=True)),
                ('punktacja_wewnetrzna', models.DecimalField(default=Decimal('0.00'), verbose_name=b'Punktacja wewn\xc4\x99trzna', max_digits=6, decimal_places=2, db_index=True)),
                ('kc_impact_factor', models.DecimalField(decimal_places=2, default=None, max_digits=6, blank=True, help_text=b'Je\xc5\xbceli wpiszesz\n        warto\xc5\x9b\xc4\x87 w to pole, to zostanie ona u\xc5\xbcyta w raporcie dla Komisji\n        Centralnej w punkcie IXa tego raportu.', null=True, verbose_name=b'KC: Impact factor', db_index=True)),
                ('kc_punkty_kbn', models.DecimalField(decimal_places=2, default=None, max_digits=6, blank=True, help_text=b'Je\xc5\xbceli wpiszesz\n        warto\xc5\x9b\xc4\x87 w to pole, to zostanie ona u\xc5\xbcyta w raporcie dla Komisji\n        Centralnej w punkcie IXa i IXb tego raportu.', null=True, verbose_name=b'KC: Punkty KBN', db_index=True)),
                ('kc_index_copernicus', models.DecimalField(decimal_places=2, default=None, max_digits=6, blank=True, help_text=b'Je\xc5\xbceli wpiszesz\n        warto\xc5\x9b\xc4\x87 w to pole, to zostanie ona u\xc5\xbcyta w raporcie dla Komisji\n        Centralnej w punkcie IXa i IXb tego raportu.', null=True, verbose_name=b'KC: Index Copernicus')),
                ('weryfikacja_punktacji', models.BooleanField(default=False)),
                ('informacje', models.TextField(null=True, verbose_name=b'Informacje', blank=True)),
                ('szczegoly', models.CharField(help_text=b'Np. str. 23-45', max_length=512, null=True, verbose_name=b'Szczeg\xc3\xb3\xc5\x82y', blank=True)),
                ('uwagi', models.TextField(db_index=True, null=True, blank=True)),
                ('slowa_kluczowe', models.TextField(null=True, verbose_name=b'S\xc5\x82owa kluczowe', blank=True)),
                ('utworzono', models.DateTimeField(default=datetime.datetime(1970, 1, 1, 0, 0), verbose_name=b'Utworzono', auto_now_add=True)),
                ('search_index', SearchVectorField(default=b'', serialize=False, null=True, editable=False, db_index=True)),
                ('tytul_oryginalny_sort', models.TextField(default=b'', db_index=True)),
                ('tytul_oryginalny', models.TextField(verbose_name=b'Tytu\xc5\x82 oryginalny', db_index=True)),
                ('numer', models.CharField(max_length=255, null=True, blank=True)),
                ('z_dnia', models.DateField(null=True, blank=True)),
            ],
            options={
                'verbose_name': b'patent',
                'verbose_name_plural': b'patenty',
            },
            bases=(models.Model,),
        ),
        migrations.CreateModel(
            name='Patent_Autor',
            fields=[
                ('id', models.AutoField(verbose_name='ID', serialize=False, auto_created=True, primary_key=True)),
                ('kolejnosc', models.IntegerField(default=0, verbose_name=b'Kolejno\xc5\x9b\xc4\x87')),
                ('zapisany_jako', models.CharField(max_length=512)),
                ('autor', models.ForeignKey(on_delete=models.CASCADE, to='bpp.Autor')),
                ('jednostka', models.ForeignKey(on_delete=models.CASCADE, to='bpp.Jednostka')),
            ],
            options={
                'ordering': ('kolejnosc',),
                'verbose_name': b'powi\xc4\x85zanie autora z patentem',
                'verbose_name_plural': b'powi\xc4\x85zania autor\xc3\xb3w z patentami',
            },
            bases=(models.Model,),
        ),
        migrations.AddField(
            model_name='patent',
            name='autorzy',
            field=models.ManyToManyField(to='bpp.Autor', through='bpp.Patent_Autor'),
            preserve_default=True,
        ),
        migrations.AddField(
            model_name='patent_autor',
            name='rekord',
            field=models.ForeignKey(on_delete=models.CASCADE, to='bpp.Patent'),
            preserve_default=True,
        ),
        migrations.CreateModel(
            name='Plec',
            fields=[
                ('id', models.AutoField(verbose_name='ID', serialize=False, auto_created=True, primary_key=True)),
                ('nazwa', models.CharField(unique=True, max_length=512)),
                ('skrot', models.CharField(unique=True, max_length=128)),
            ],
            options={
                'verbose_name': b'p\xc5\x82e\xc4\x87',
                'verbose_name_plural': b'p\xc5\x82cie',
            },
            bases=(models.Model,),
        ),
        migrations.AddField(
            model_name='autor',
            name='plec',
            field=models.ForeignKey(on_delete=models.CASCADE, blank=True, to='bpp.Plec', null=True),
            preserve_default=True,
        ),
        migrations.CreateModel(
            name='Praca_Doktorska',
            fields=[
                ('id', models.AutoField(verbose_name='ID', serialize=False, auto_created=True, primary_key=True)),
                ('opis_bibliograficzny_cache', models.TextField(default=b'')),
                ('opis_bibliograficzny_autorzy_cache', ArrayField(models.TextField())),
                ('opis_bibliograficzny_zapisani_autorzy_cache', models.TextField(default=b'')),
                ('ostatnio_zmieniony', models.DateTimeField(auto_now=True, auto_now_add=True, null=True, db_index=True)),
                ('adnotacje', models.TextField(help_text=b'Pole do u\xc5\xbcytku wewn\xc4\x99trznego -\n    wpisane tu informacje nie s\xc4\x85 wy\xc5\x9bwietlane na stronach WWW dost\xc4\x99pnych\n    dla u\xc5\xbcytkownik\xc3\xb3w ko\xc5\x84cowych.', null=True, db_index=True, blank=True)),
                ('isbn', models.CharField(max_length=64, null=True, verbose_name=b'ISBN', blank=True)),
                ('e_isbn', models.CharField(max_length=64, null=True, verbose_name=b'E-ISBN', blank=True)),
                ('tytul_oryginalny', models.TextField(verbose_name=b'Tytu\xc5\x82 oryginalny', db_index=True)),
                ('tytul', models.TextField(db_index=True, null=True, verbose_name=b'Tytu\xc5\x82', blank=True)),
                ('rok', models.IntegerField(help_text=b'Rok uwzgl\xc4\x99dniany przy wyszukiwaniu i raportach\n        KBN/MNiSW)', db_index=True)),
                ('www', models.URLField(max_length=1024, null=True, verbose_name=b'Adres WWW', blank=True)),
                ('afiliowana', models.BooleanField(default=False)),
                ('recenzowana', models.BooleanField(default=False)),
                ('impact_factor', models.DecimalField(default=Decimal('0.000'), max_digits=6, decimal_places=3, db_index=True)),
                ('punkty_kbn', models.DecimalField(default=Decimal('0.00'), verbose_name=b'Punkty KBN', max_digits=6, decimal_places=2, db_index=True)),
                ('index_copernicus', models.DecimalField(default=Decimal('0.00'), verbose_name=b'Index Copernicus', max_digits=6, decimal_places=2, db_index=True)),
                ('punktacja_wewnetrzna', models.DecimalField(default=Decimal('0.00'), verbose_name=b'Punktacja wewn\xc4\x99trzna', max_digits=6, decimal_places=2, db_index=True)),
                ('kc_impact_factor', models.DecimalField(decimal_places=2, default=None, max_digits=6, blank=True, help_text=b'Je\xc5\xbceli wpiszesz\n        warto\xc5\x9b\xc4\x87 w to pole, to zostanie ona u\xc5\xbcyta w raporcie dla Komisji\n        Centralnej w punkcie IXa tego raportu.', null=True, verbose_name=b'KC: Impact factor', db_index=True)),
                ('kc_punkty_kbn', models.DecimalField(decimal_places=2, default=None, max_digits=6, blank=True, help_text=b'Je\xc5\xbceli wpiszesz\n        warto\xc5\x9b\xc4\x87 w to pole, to zostanie ona u\xc5\xbcyta w raporcie dla Komisji\n        Centralnej w punkcie IXa i IXb tego raportu.', null=True, verbose_name=b'KC: Punkty KBN', db_index=True)),
                ('kc_index_copernicus', models.DecimalField(decimal_places=2, default=None, max_digits=6, blank=True, help_text=b'Je\xc5\xbceli wpiszesz\n        warto\xc5\x9b\xc4\x87 w to pole, to zostanie ona u\xc5\xbcyta w raporcie dla Komisji\n        Centralnej w punkcie IXa i IXb tego raportu.', null=True, verbose_name=b'KC: Index Copernicus')),
                ('weryfikacja_punktacji', models.BooleanField(default=False)),
                ('informacje', models.TextField(null=True, verbose_name=b'Informacje', blank=True)),
                ('szczegoly', models.CharField(help_text=b'Np. str. 23-45', max_length=512, null=True, verbose_name=b'Szczeg\xc3\xb3\xc5\x82y', blank=True)),
                ('uwagi', models.TextField(db_index=True, null=True, blank=True)),
                ('slowa_kluczowe', models.TextField(null=True, verbose_name=b'S\xc5\x82owa kluczowe', blank=True)),
                ('utworzono', models.DateTimeField(default=datetime.datetime(1970, 1, 1, 0, 0), verbose_name=b'Utworzono', auto_now_add=True)),
                ('search_index', SearchVectorField(default=b'', serialize=False, null=True, editable=False, db_index=True)),
                ('tytul_oryginalny_sort', models.TextField(default=b'', db_index=True)),
                ('miejsce_i_rok', models.CharField(help_text=b'Przyk\xc5\x82adowo:\n        Warszawa 2012. Wpisz prosz\xc4\x99 najpierw miejsce potem rok; oddziel\n        spacj\xc4\x85.', max_length=256, null=True, blank=True)),
                ('wydawnictwo', models.CharField(max_length=256, null=True, blank=True)),
                ('redakcja', models.TextField(null=True, blank=True)),
                ('autor', models.ForeignKey(on_delete=models.CASCADE, to='bpp.Autor')),
                ('jednostka', models.ForeignKey(on_delete=models.CASCADE, to='bpp.Jednostka')),
                ('jezyk', models.ForeignKey(on_delete=models.CASCADE, verbose_name=b'J\xc4\x99zyk', to='bpp.Jezyk')),
            ],
            options={
                'verbose_name': b'praca doktorska',
                'verbose_name_plural': b'prace doktorskie',
            },
            bases=(models.Model,),
        ),
        migrations.CreateModel(
            name='Praca_Habilitacyjna',
            fields=[
                ('id', models.AutoField(verbose_name='ID', serialize=False, auto_created=True, primary_key=True)),
                ('opis_bibliograficzny_cache', models.TextField(default=b'')),
                ('opis_bibliograficzny_autorzy_cache', ArrayField(models.TextField())),
                ('opis_bibliograficzny_zapisani_autorzy_cache', models.TextField(default=b'')),
                ('ostatnio_zmieniony', models.DateTimeField(auto_now=True, auto_now_add=True, null=True, db_index=True)),
                ('adnotacje', models.TextField(help_text=b'Pole do u\xc5\xbcytku wewn\xc4\x99trznego -\n    wpisane tu informacje nie s\xc4\x85 wy\xc5\x9bwietlane na stronach WWW dost\xc4\x99pnych\n    dla u\xc5\xbcytkownik\xc3\xb3w ko\xc5\x84cowych.', null=True, db_index=True, blank=True)),
                ('isbn', models.CharField(max_length=64, null=True, verbose_name=b'ISBN', blank=True)),
                ('e_isbn', models.CharField(max_length=64, null=True, verbose_name=b'E-ISBN', blank=True)),
                ('tytul_oryginalny', models.TextField(verbose_name=b'Tytu\xc5\x82 oryginalny', db_index=True)),
                ('tytul', models.TextField(db_index=True, null=True, verbose_name=b'Tytu\xc5\x82', blank=True)),
                ('rok', models.IntegerField(help_text=b'Rok uwzgl\xc4\x99dniany przy wyszukiwaniu i raportach\n        KBN/MNiSW)', db_index=True)),
                ('www', models.URLField(max_length=1024, null=True, verbose_name=b'Adres WWW', blank=True)),
                ('afiliowana', models.BooleanField(default=False)),
                ('recenzowana', models.BooleanField(default=False)),
                ('impact_factor', models.DecimalField(default=Decimal('0.000'), max_digits=6, decimal_places=3, db_index=True)),
                ('punkty_kbn', models.DecimalField(default=Decimal('0.00'), verbose_name=b'Punkty KBN', max_digits=6, decimal_places=2, db_index=True)),
                ('index_copernicus', models.DecimalField(default=Decimal('0.00'), verbose_name=b'Index Copernicus', max_digits=6, decimal_places=2, db_index=True)),
                ('punktacja_wewnetrzna', models.DecimalField(default=Decimal('0.00'), verbose_name=b'Punktacja wewn\xc4\x99trzna', max_digits=6, decimal_places=2, db_index=True)),
                ('kc_impact_factor', models.DecimalField(decimal_places=2, default=None, max_digits=6, blank=True, help_text=b'Je\xc5\xbceli wpiszesz\n        warto\xc5\x9b\xc4\x87 w to pole, to zostanie ona u\xc5\xbcyta w raporcie dla Komisji\n        Centralnej w punkcie IXa tego raportu.', null=True, verbose_name=b'KC: Impact factor', db_index=True)),
                ('kc_punkty_kbn', models.DecimalField(decimal_places=2, default=None, max_digits=6, blank=True, help_text=b'Je\xc5\xbceli wpiszesz\n        warto\xc5\x9b\xc4\x87 w to pole, to zostanie ona u\xc5\xbcyta w raporcie dla Komisji\n        Centralnej w punkcie IXa i IXb tego raportu.', null=True, verbose_name=b'KC: Punkty KBN', db_index=True)),
                ('kc_index_copernicus', models.DecimalField(decimal_places=2, default=None, max_digits=6, blank=True, help_text=b'Je\xc5\xbceli wpiszesz\n        warto\xc5\x9b\xc4\x87 w to pole, to zostanie ona u\xc5\xbcyta w raporcie dla Komisji\n        Centralnej w punkcie IXa i IXb tego raportu.', null=True, verbose_name=b'KC: Index Copernicus')),
                ('weryfikacja_punktacji', models.BooleanField(default=False)),
                ('informacje', models.TextField(null=True, verbose_name=b'Informacje', blank=True)),
                ('szczegoly', models.CharField(help_text=b'Np. str. 23-45', max_length=512, null=True, verbose_name=b'Szczeg\xc3\xb3\xc5\x82y', blank=True)),
                ('uwagi', models.TextField(db_index=True, null=True, blank=True)),
                ('slowa_kluczowe', models.TextField(null=True, verbose_name=b'S\xc5\x82owa kluczowe', blank=True)),
                ('utworzono', models.DateTimeField(default=datetime.datetime(1970, 1, 1, 0, 0), verbose_name=b'Utworzono', auto_now_add=True)),
                ('search_index', SearchVectorField(default=b'', serialize=False, null=True, editable=False, db_index=True)),
                ('tytul_oryginalny_sort', models.TextField(default=b'', db_index=True)),
                ('miejsce_i_rok', models.CharField(help_text=b'Przyk\xc5\x82adowo:\n        Warszawa 2012. Wpisz prosz\xc4\x99 najpierw miejsce potem rok; oddziel\n        spacj\xc4\x85.', max_length=256, null=True, blank=True)),
                ('wydawnictwo', models.CharField(max_length=256, null=True, blank=True)),
                ('redakcja', models.TextField(null=True, blank=True)),
                ('autor', models.ForeignKey(on_delete=models.CASCADE, to='bpp.Autor')),
                ('jednostka', models.ForeignKey(on_delete=models.CASCADE, to='bpp.Jednostka')),
                ('jezyk', models.ForeignKey(on_delete=models.CASCADE, verbose_name=b'J\xc4\x99zyk', to='bpp.Jezyk')),
            ],
            options={
                'verbose_name': b'praca habilitacyjna',
                'verbose_name_plural': b'prace habilitacyjne',
            },
            bases=(models.Model,),
        ),
        migrations.CreateModel(
            name='Publikacja_Habilitacyjna',
            fields=[
                ('id', models.AutoField(verbose_name='ID', serialize=False, auto_created=True, primary_key=True)),
                ('kolejnosc', models.IntegerField(default=0, verbose_name=b'Kolejno\xc5\x9b\xc4\x87')),
                ('object_id', models.PositiveIntegerField()),
                ('content_type', models.ForeignKey(on_delete=models.CASCADE, to='contenttypes.ContentType')),
                ('praca_habilitacyjna', models.ForeignKey(on_delete=models.CASCADE, to='bpp.Praca_Habilitacyjna')),
            ],
            options={
                'ordering': ('kolejnosc',),
                'verbose_name': b'powi\xc4\x85zanie publikacji z habilitacj\xc4\x85',
                'verbose_name_plural': b'powi\xc4\x85zania publikacji z habilitacj\xc4\x85',
            },
            bases=(models.Model,),
        ),
        migrations.CreateModel(
            name='Punktacja_Zrodla',
            fields=[
                ('id', models.AutoField(verbose_name='ID', serialize=False, auto_created=True, primary_key=True)),
                ('impact_factor', models.DecimalField(default=Decimal('0.000'), max_digits=6, decimal_places=3, db_index=True)),
                ('punkty_kbn', models.DecimalField(default=Decimal('0.00'), verbose_name=b'Punkty KBN', max_digits=6, decimal_places=2, db_index=True)),
                ('index_copernicus', models.DecimalField(default=Decimal('0.00'), verbose_name=b'Index Copernicus', max_digits=6, decimal_places=2, db_index=True)),
                ('punktacja_wewnetrzna', models.DecimalField(default=Decimal('0.00'), verbose_name=b'Punktacja wewn\xc4\x99trzna', max_digits=6, decimal_places=2, db_index=True)),
                ('kc_impact_factor', models.DecimalField(decimal_places=2, default=None, max_digits=6, blank=True, help_text=b'Je\xc5\xbceli wpiszesz\n        warto\xc5\x9b\xc4\x87 w to pole, to zostanie ona u\xc5\xbcyta w raporcie dla Komisji\n        Centralnej w punkcie IXa tego raportu.', null=True, verbose_name=b'KC: Impact factor', db_index=True)),
                ('kc_punkty_kbn', models.DecimalField(decimal_places=2, default=None, max_digits=6, blank=True, help_text=b'Je\xc5\xbceli wpiszesz\n        warto\xc5\x9b\xc4\x87 w to pole, to zostanie ona u\xc5\xbcyta w raporcie dla Komisji\n        Centralnej w punkcie IXa i IXb tego raportu.', null=True, verbose_name=b'KC: Punkty KBN', db_index=True)),
                ('kc_index_copernicus', models.DecimalField(decimal_places=2, default=None, max_digits=6, blank=True, help_text=b'Je\xc5\xbceli wpiszesz\n        warto\xc5\x9b\xc4\x87 w to pole, to zostanie ona u\xc5\xbcyta w raporcie dla Komisji\n        Centralnej w punkcie IXa i IXb tego raportu.', null=True, verbose_name=b'KC: Index Copernicus')),
                ('rok', models.IntegerField()),
            ],
            options={
                'ordering': ['zrodlo__nazwa', 'rok'],
                'verbose_name': b'punktacja \xc5\xbar\xc3\xb3d\xc5\x82a',
                'verbose_name_plural': b'punktacja \xc5\xbar\xc3\xb3d\xc5\x82a',
            },
            bases=(models.Model,),
        ),
        migrations.CreateModel(
            name='Redakcja_Zrodla',
            fields=[
                ('id', models.AutoField(verbose_name='ID', serialize=False, auto_created=True, primary_key=True)),
                ('od_roku', models.IntegerField()),
                ('do_roku', models.IntegerField(null=True, blank=True)),
                ('redaktor', models.ForeignKey(on_delete=models.CASCADE, to='bpp.Autor')),
            ],
            options={
                'verbose_name': b'redaktor \xc5\xbar\xc3\xb3d\xc5\x82a',
                'verbose_name_plural': b'redaktorzy \xc5\xbar\xc3\xb3d\xc5\x82a',
            },
            bases=(models.Model,),
        ),
        migrations.CreateModel(
            name='Rodzaj_Zrodla',
            fields=[
                ('id', models.AutoField(verbose_name='ID', serialize=False, auto_created=True, primary_key=True)),
                ('nazwa', models.CharField(unique=True, max_length=512)),
            ],
            options={
                'verbose_name': b'rodzaj \xc5\xbar\xc3\xb3d\xc5\x82a',
                'verbose_name_plural': b'rodzaje \xc5\xbar\xc3\xb3de\xc5\x82',
            },
            bases=(models.Model,),
        ),
        migrations.CreateModel(
            name='Status_Korekty',
            fields=[
                ('id', models.AutoField(verbose_name='ID', serialize=False, auto_created=True, primary_key=True)),
                ('nazwa', models.CharField(unique=True, max_length=512)),
            ],
            options={
                'verbose_name': b'status korekty',
                'verbose_name_plural': b'statusy korekty',
            },
            bases=(models.Model,),
        ),
        migrations.AddField(
            model_name='praca_habilitacyjna',
            name='status_korekty',
            field=models.ForeignKey(on_delete=models.CASCADE, default=1, to='bpp.Status_Korekty'),
            preserve_default=True,
        ),
        migrations.AddField(
            model_name='praca_doktorska',
            name='status_korekty',
            field=models.ForeignKey(on_delete=models.CASCADE, default=1, to='bpp.Status_Korekty'),
            preserve_default=True,
        ),
        migrations.AddField(
            model_name='patent',
            name='status_korekty',
            field=models.ForeignKey(on_delete=models.CASCADE, default=1, to='bpp.Status_Korekty'),
            preserve_default=True,
        ),
        migrations.CreateModel(
            name='Typ_KBN',
            fields=[
                ('id', models.AutoField(verbose_name='ID', serialize=False, auto_created=True, primary_key=True)),
                ('nazwa', models.CharField(unique=True, max_length=512)),
                ('skrot', models.CharField(unique=True, max_length=128)),
            ],
            options={
                'ordering': ['nazwa'],
                'verbose_name': b'typ KBN',
                'verbose_name_plural': b'typy KBN',
            },
            bases=(models.Model,),
        ),
        migrations.AddField(
            model_name='praca_habilitacyjna',
            name='typ_kbn',
            field=models.ForeignKey(on_delete=models.CASCADE, verbose_name=b'Typ KBN', to='bpp.Typ_KBN'),
            preserve_default=True,
        ),
        migrations.AddField(
            model_name='praca_doktorska',
            name='typ_kbn',
            field=models.ForeignKey(on_delete=models.CASCADE, verbose_name=b'Typ KBN', to='bpp.Typ_KBN'),
            preserve_default=True,
        ),
        migrations.CreateModel(
            name='Typ_Odpowiedzialnosci',
            fields=[
                ('id', models.AutoField(verbose_name='ID', serialize=False, auto_created=True, primary_key=True)),
                ('nazwa', models.CharField(unique=True, max_length=512)),
                ('skrot', models.CharField(unique=True, max_length=128)),
            ],
            options={
                'ordering': [b'nazwa'],
                'verbose_name': b'typ odpowiedzialno\xc5\x9bci autora',
                'verbose_name_plural': b'typy odpowiedzialno\xc5\x9bci autor\xc3\xb3w',
            },
            bases=(models.Model,),
        ),
        migrations.AddField(
            model_name='patent_autor',
            name='typ_odpowiedzialnosci',
            field=models.ForeignKey(on_delete=models.CASCADE, verbose_name=b'Typ odpowiedzialno\xc5\x9bci', to='bpp.Typ_Odpowiedzialnosci'),
            preserve_default=True,
        ),
        migrations.AlterUniqueTogether(
            name='patent_autor',
            unique_together=set([('rekord', 'autor', 'typ_odpowiedzialnosci', 'kolejnosc')]),
        ),
        migrations.CreateModel(
            name='Tytul',
            fields=[
                ('id', models.AutoField(verbose_name='ID', serialize=False, auto_created=True, primary_key=True)),
                ('nazwa', models.CharField(unique=True, max_length=512)),
                ('skrot', models.CharField(unique=True, max_length=128)),
            ],
            options={
                'verbose_name': b'tytu\xc5\x82',
                'verbose_name_plural': b'tytu\xc5\x82y',
            },
            bases=(models.Model,),
        ),
        migrations.AddField(
            model_name='autor',
            name='tytul',
            field=models.ForeignKey(on_delete=models.CASCADE, blank=True, to='bpp.Tytul', null=True),
            preserve_default=True,
        ),
        migrations.CreateModel(
            name='Uczelnia',
            fields=[
                ('id', models.AutoField(verbose_name='ID', serialize=False, auto_created=True, primary_key=True)),
                ('ostatnio_zmieniony', models.DateTimeField(auto_now=True, auto_now_add=True, null=True, db_index=True)),
                ('adnotacje', models.TextField(help_text=b'Pole do u\xc5\xbcytku wewn\xc4\x99trznego -\n    wpisane tu informacje nie s\xc4\x85 wy\xc5\x9bwietlane na stronach WWW dost\xc4\x99pnych\n    dla u\xc5\xbcytkownik\xc3\xb3w ko\xc5\x84cowych.', null=True, db_index=True, blank=True)),
                ('nazwa', models.CharField(unique=True, max_length=512)),
                ('skrot', models.CharField(unique=True, max_length=128)),
                ('nazwa_dopelniacz_field', models.CharField(max_length=512, null=True, verbose_name='Nazwa w dope\u0142niaczu', blank=True)),
                ('slug', autoslug.fields.AutoSlugField(unique=True, editable=False)),
                ('logo_www', models.ImageField(help_text=b'Plik w formacie bitmapowym, np. JPEG lub PNG,\n        w rozdzielczo\xc5\x9bci maks. 100x100', upload_to=b'logo', null=True, verbose_name=b'Logo na stron\xc4\x99 WWW', blank=True)),
                ('logo_svg', models.FileField(upload_to=b'logo_svg', null=True, verbose_name=b'Logo wektorowe (SVG)', blank=True)),
                ('favicon_ico', models.FileField(upload_to=b'favicon', null=True, verbose_name=b'Ikona ulubionych (favicon)', blank=True)),
            ],
            options={
                'verbose_name': b'uczelnia',
                'verbose_name_plural': b'uczelnie',
            },
            bases=(models.Model,),
        ),
        migrations.CreateModel(
            name='Wydawnictwo_Ciagle',
            fields=[
                ('id', models.AutoField(verbose_name='ID', serialize=False, auto_created=True, primary_key=True)),
                ('opis_bibliograficzny_cache', models.TextField(default=b'')),
                ('opis_bibliograficzny_autorzy_cache', ArrayField(models.TextField())),
                ('opis_bibliograficzny_zapisani_autorzy_cache', models.TextField(default=b'')),
                ('ostatnio_zmieniony', models.DateTimeField(auto_now=True, auto_now_add=True, null=True, db_index=True)),
                ('adnotacje', models.TextField(help_text=b'Pole do u\xc5\xbcytku wewn\xc4\x99trznego -\n    wpisane tu informacje nie s\xc4\x85 wy\xc5\x9bwietlane na stronach WWW dost\xc4\x99pnych\n    dla u\xc5\xbcytkownik\xc3\xb3w ko\xc5\x84cowych.', null=True, db_index=True, blank=True)),
                ('issn', models.CharField(max_length=32, null=True, verbose_name=b'ISSN', blank=True)),
                ('e_issn', models.CharField(max_length=32, null=True, verbose_name=b'e-ISSN', blank=True)),
                ('tytul_oryginalny', models.TextField(verbose_name=b'Tytu\xc5\x82 oryginalny', db_index=True)),
                ('tytul', models.TextField(db_index=True, null=True, verbose_name=b'Tytu\xc5\x82', blank=True)),
                ('rok', models.IntegerField(help_text=b'Rok uwzgl\xc4\x99dniany przy wyszukiwaniu i raportach\n        KBN/MNiSW)', db_index=True)),
                ('www', models.URLField(max_length=1024, null=True, verbose_name=b'Adres WWW', blank=True)),
                ('afiliowana', models.BooleanField(default=False)),
                ('recenzowana', models.BooleanField(default=False)),
                ('impact_factor', models.DecimalField(default=Decimal('0.000'), max_digits=6, decimal_places=3, db_index=True)),
                ('punkty_kbn', models.DecimalField(default=Decimal('0.00'), verbose_name=b'Punkty KBN', max_digits=6, decimal_places=2, db_index=True)),
                ('index_copernicus', models.DecimalField(default=Decimal('0.00'), verbose_name=b'Index Copernicus', max_digits=6, decimal_places=2, db_index=True)),
                ('punktacja_wewnetrzna', models.DecimalField(default=Decimal('0.00'), verbose_name=b'Punktacja wewn\xc4\x99trzna', max_digits=6, decimal_places=2, db_index=True)),
                ('kc_impact_factor', models.DecimalField(decimal_places=2, default=None, max_digits=6, blank=True, help_text=b'Je\xc5\xbceli wpiszesz\n        warto\xc5\x9b\xc4\x87 w to pole, to zostanie ona u\xc5\xbcyta w raporcie dla Komisji\n        Centralnej w punkcie IXa tego raportu.', null=True, verbose_name=b'KC: Impact factor', db_index=True)),
                ('kc_punkty_kbn', models.DecimalField(decimal_places=2, default=None, max_digits=6, blank=True, help_text=b'Je\xc5\xbceli wpiszesz\n        warto\xc5\x9b\xc4\x87 w to pole, to zostanie ona u\xc5\xbcyta w raporcie dla Komisji\n        Centralnej w punkcie IXa i IXb tego raportu.', null=True, verbose_name=b'KC: Punkty KBN', db_index=True)),
                ('kc_index_copernicus', models.DecimalField(decimal_places=2, default=None, max_digits=6, blank=True, help_text=b'Je\xc5\xbceli wpiszesz\n        warto\xc5\x9b\xc4\x87 w to pole, to zostanie ona u\xc5\xbcyta w raporcie dla Komisji\n        Centralnej w punkcie IXa i IXb tego raportu.', null=True, verbose_name=b'KC: Index Copernicus')),
                ('weryfikacja_punktacji', models.BooleanField(default=False)),
                ('informacje', models.TextField(null=True, verbose_name=b'Informacje', blank=True)),
                ('szczegoly', models.CharField(help_text=b'Np. str. 23-45', max_length=512, null=True, verbose_name=b'Szczeg\xc3\xb3\xc5\x82y', blank=True)),
                ('uwagi', models.TextField(db_index=True, null=True, blank=True)),
                ('slowa_kluczowe', models.TextField(null=True, verbose_name=b'S\xc5\x82owa kluczowe', blank=True)),
                ('utworzono', models.DateTimeField(default=datetime.datetime(1970, 1, 1, 0, 0), verbose_name=b'Utworzono', auto_now_add=True)),
                ('search_index', SearchVectorField(default=b'', serialize=False, null=True, editable=False, db_index=True)),
                ('tytul_oryginalny_sort', models.TextField(default=b'', db_index=True)),
                ('uzupelnij_punktacje', models.BooleanField(default=False)),
                ('charakter_formalny', models.ForeignKey(on_delete=models.CASCADE, verbose_name=b'Charakter formalny', to='bpp.Charakter_Formalny')),
                ('jezyk', models.ForeignKey(on_delete=models.CASCADE, verbose_name=b'J\xc4\x99zyk', to='bpp.Jezyk')),
                ('status_korekty', models.ForeignKey(on_delete=models.CASCADE, default=1, to='bpp.Status_Korekty')),
                ('typ_kbn', models.ForeignKey(on_delete=models.CASCADE, verbose_name=b'Typ KBN', to='bpp.Typ_KBN')),
            ],
            options={
                'verbose_name': b'wydawnictwo ci\xc4\x85g\xc5\x82e',
                'verbose_name_plural': b'wydawnictwa ci\xc4\x85g\xc5\x82e',
            },
            bases=(models.Model,),
        ),
        migrations.CreateModel(
            name='Wydawnictwo_Ciagle_Autor',
            fields=[
                ('id', models.AutoField(verbose_name='ID', serialize=False, auto_created=True, primary_key=True)),
                ('kolejnosc', models.IntegerField(default=0, verbose_name=b'Kolejno\xc5\x9b\xc4\x87')),
                ('zapisany_jako', models.CharField(max_length=512)),
                ('autor', models.ForeignKey(on_delete=models.CASCADE, to='bpp.Autor')),
                ('jednostka', models.ForeignKey(on_delete=models.CASCADE, to='bpp.Jednostka')),
            ],
            options={
                'ordering': (b'kolejnosc',),
                'verbose_name': b'powi\xc4\x85zanie autora z wyd. ci\xc4\x85g\xc5\x82ym',
                'verbose_name_plural': b'powi\xc4\x85zania autor\xc3\xb3w z wyd. ci\xc4\x85g\xc5\x82ymi',
            },
            bases=(models.Model,),
        ),
        migrations.AddField(
            model_name='wydawnictwo_ciagle',
            name='autorzy',
            field=models.ManyToManyField(to='bpp.Autor', through='bpp.Wydawnictwo_Ciagle_Autor'),
            preserve_default=True,
        ),
        migrations.AddField(
            model_name='wydawnictwo_ciagle_autor',
            name='rekord',
            field=models.ForeignKey(on_delete=models.CASCADE, to='bpp.Wydawnictwo_Ciagle'),
            preserve_default=True,
        ),
        migrations.AddField(
            model_name='wydawnictwo_ciagle_autor',
            name='typ_odpowiedzialnosci',
            field=models.ForeignKey(on_delete=models.CASCADE, verbose_name=b'Typ odpowiedzialno\xc5\x9bci', to='bpp.Typ_Odpowiedzialnosci'),
            preserve_default=True,
        ),
        migrations.AlterUniqueTogether(
            name='wydawnictwo_ciagle_autor',
            unique_together=set([('rekord', 'autor', 'typ_odpowiedzialnosci', 'kolejnosc')]),
        ),
        migrations.CreateModel(
            name='Wydawnictwo_Zwarte',
            fields=[
                ('id', models.AutoField(verbose_name='ID', serialize=False, auto_created=True, primary_key=True)),
                ('opis_bibliograficzny_cache', models.TextField(default=b'')),
                ('opis_bibliograficzny_autorzy_cache', ArrayField(models.TextField())),
                ('opis_bibliograficzny_zapisani_autorzy_cache', models.TextField(default=b'')),
                ('ostatnio_zmieniony', models.DateTimeField(auto_now=True, auto_now_add=True, null=True, db_index=True)),
                ('adnotacje', models.TextField(help_text=b'Pole do u\xc5\xbcytku wewn\xc4\x99trznego -\n    wpisane tu informacje nie s\xc4\x85 wy\xc5\x9bwietlane na stronach WWW dost\xc4\x99pnych\n    dla u\xc5\xbcytkownik\xc3\xb3w ko\xc5\x84cowych.', null=True, db_index=True, blank=True)),
                ('isbn', models.CharField(max_length=64, null=True, verbose_name=b'ISBN', blank=True)),
                ('e_isbn', models.CharField(max_length=64, null=True, verbose_name=b'E-ISBN', blank=True)),
                ('tytul_oryginalny', models.TextField(verbose_name=b'Tytu\xc5\x82 oryginalny', db_index=True)),
                ('tytul', models.TextField(db_index=True, null=True, verbose_name=b'Tytu\xc5\x82', blank=True)),
                ('rok', models.IntegerField(help_text=b'Rok uwzgl\xc4\x99dniany przy wyszukiwaniu i raportach\n        KBN/MNiSW)', db_index=True)),
                ('www', models.URLField(max_length=1024, null=True, verbose_name=b'Adres WWW', blank=True)),
                ('afiliowana', models.BooleanField(default=False)),
                ('recenzowana', models.BooleanField(default=False)),
                ('impact_factor', models.DecimalField(default=Decimal('0.000'), max_digits=6, decimal_places=3, db_index=True)),
                ('punkty_kbn', models.DecimalField(default=Decimal('0.00'), verbose_name=b'Punkty KBN', max_digits=6, decimal_places=2, db_index=True)),
                ('index_copernicus', models.DecimalField(default=Decimal('0.00'), verbose_name=b'Index Copernicus', max_digits=6, decimal_places=2, db_index=True)),
                ('punktacja_wewnetrzna', models.DecimalField(default=Decimal('0.00'), verbose_name=b'Punktacja wewn\xc4\x99trzna', max_digits=6, decimal_places=2, db_index=True)),
                ('kc_impact_factor', models.DecimalField(decimal_places=2, default=None, max_digits=6, blank=True, help_text=b'Je\xc5\xbceli wpiszesz\n        warto\xc5\x9b\xc4\x87 w to pole, to zostanie ona u\xc5\xbcyta w raporcie dla Komisji\n        Centralnej w punkcie IXa tego raportu.', null=True, verbose_name=b'KC: Impact factor', db_index=True)),
                ('kc_punkty_kbn', models.DecimalField(decimal_places=2, default=None, max_digits=6, blank=True, help_text=b'Je\xc5\xbceli wpiszesz\n        warto\xc5\x9b\xc4\x87 w to pole, to zostanie ona u\xc5\xbcyta w raporcie dla Komisji\n        Centralnej w punkcie IXa i IXb tego raportu.', null=True, verbose_name=b'KC: Punkty KBN', db_index=True)),
                ('kc_index_copernicus', models.DecimalField(decimal_places=2, default=None, max_digits=6, blank=True, help_text=b'Je\xc5\xbceli wpiszesz\n        warto\xc5\x9b\xc4\x87 w to pole, to zostanie ona u\xc5\xbcyta w raporcie dla Komisji\n        Centralnej w punkcie IXa i IXb tego raportu.', null=True, verbose_name=b'KC: Index Copernicus')),
                ('weryfikacja_punktacji', models.BooleanField(default=False)),
                ('informacje', models.TextField(null=True, verbose_name=b'Informacje', blank=True)),
                ('szczegoly', models.CharField(help_text=b'Np. str. 23-45', max_length=512, null=True, verbose_name=b'Szczeg\xc3\xb3\xc5\x82y', blank=True)),
                ('uwagi', models.TextField(db_index=True, null=True, blank=True)),
                ('slowa_kluczowe', models.TextField(null=True, verbose_name=b'S\xc5\x82owa kluczowe', blank=True)),
                ('utworzono', models.DateTimeField(default=datetime.datetime(1970, 1, 1, 0, 0), verbose_name=b'Utworzono', auto_now_add=True)),
                ('search_index', SearchVectorField(default=b'', serialize=False, null=True, editable=False, db_index=True)),
                ('tytul_oryginalny_sort', models.TextField(default=b'', db_index=True)),
                ('miejsce_i_rok', models.CharField(help_text=b'Przyk\xc5\x82adowo:\n        Warszawa 2012. Wpisz prosz\xc4\x99 najpierw miejsce potem rok; oddziel\n        spacj\xc4\x85.', max_length=256, null=True, blank=True)),
                ('wydawnictwo', models.CharField(max_length=256, null=True, blank=True)),
                ('redakcja', models.TextField(null=True, blank=True)),
                ('liczba_znakow_wydawniczych', models.IntegerField(null=True, verbose_name=b'Liczba znak\xc3\xb3w wydawniczych', blank=True)),
                ('charakter_formalny', models.ForeignKey(on_delete=models.CASCADE, verbose_name=b'Charakter formalny', to='bpp.Charakter_Formalny')),
                ('jezyk', models.ForeignKey(on_delete=models.CASCADE, verbose_name=b'J\xc4\x99zyk', to='bpp.Jezyk')),
                ('status_korekty', models.ForeignKey(on_delete=models.CASCADE, default=1, to='bpp.Status_Korekty')),
                ('typ_kbn', models.ForeignKey(on_delete=models.CASCADE, verbose_name=b'Typ KBN', to='bpp.Typ_KBN')),
                ('wydawnictwo_nadrzedne', models.ForeignKey(on_delete=models.CASCADE, blank=True, to='bpp.Wydawnictwo_Zwarte', help_text=b'Je\xc5\xbceli dodajesz rozdzia\xc5\x82,\n        tu wybierz prac\xc4\x99, w ramach kt\xc3\xb3rej dany rozdzia\xc5\x82 wyst\xc4\x99puje.', null=True)),
            ],
            options={
                'verbose_name': b'wydawnictwo zwarte',
                'verbose_name_plural': b'wydawnictwa zwarte',
            },
            bases=(models.Model,),
        ),
        migrations.AddField(
            model_name='opi_2012_tytul_cache',
            name='wydawnictwo_zwarte',
            field=models.ForeignKey(on_delete=models.CASCADE, to='bpp.Wydawnictwo_Zwarte'),
            preserve_default=True,
        ),
        migrations.CreateModel(
            name='Wydawnictwo_Zwarte_Autor',
            fields=[
                ('id', models.AutoField(verbose_name='ID', serialize=False, auto_created=True, primary_key=True)),
                ('kolejnosc', models.IntegerField(default=0, verbose_name=b'Kolejno\xc5\x9b\xc4\x87')),
                ('zapisany_jako', models.CharField(max_length=512)),
                ('autor', models.ForeignKey(on_delete=models.CASCADE, to='bpp.Autor')),
                ('jednostka', models.ForeignKey(on_delete=models.CASCADE, to='bpp.Jednostka')),
            ],
            options={
                'ordering': (b'kolejnosc',),
                'verbose_name': b'powi\xc4\x85zanie autora z wyd. zwartym',
                'verbose_name_plural': b'powi\xc4\x85zania autor\xc3\xb3w z wyd. zwartymi',
            },
            bases=(models.Model,),
        ),
        migrations.AddField(
            model_name='wydawnictwo_zwarte',
            name='autorzy',
            field=models.ManyToManyField(to='bpp.Autor', through='bpp.Wydawnictwo_Zwarte_Autor'),
            preserve_default=True,
        ),
        migrations.AddField(
            model_name='wydawnictwo_zwarte_autor',
            name='rekord',
            field=models.ForeignKey(on_delete=models.CASCADE, to='bpp.Wydawnictwo_Zwarte'),
            preserve_default=True,
        ),
        migrations.AddField(
            model_name='wydawnictwo_zwarte_autor',
            name='typ_odpowiedzialnosci',
            field=models.ForeignKey(on_delete=models.CASCADE, verbose_name=b'Typ odpowiedzialno\xc5\x9bci', to='bpp.Typ_Odpowiedzialnosci'),
            preserve_default=True,
        ),
        migrations.AlterUniqueTogether(
            name='wydawnictwo_zwarte_autor',
            unique_together=set([('rekord', 'autor', 'typ_odpowiedzialnosci', 'kolejnosc')]),
        ),
        migrations.CreateModel(
            name='Wydzial',
            fields=[
                ('id', models.AutoField(verbose_name='ID', serialize=False, auto_created=True, primary_key=True)),
                ('ostatnio_zmieniony', models.DateTimeField(auto_now=True, auto_now_add=True, null=True, db_index=True)),
                ('adnotacje', models.TextField(help_text=b'Pole do u\xc5\xbcytku wewn\xc4\x99trznego -\n    wpisane tu informacje nie s\xc4\x85 wy\xc5\x9bwietlane na stronach WWW dost\xc4\x99pnych\n    dla u\xc5\xbcytkownik\xc3\xb3w ko\xc5\x84cowych.', null=True, db_index=True, blank=True)),
                ('rozpoczecie_funkcjonowania', models.DateField(null=True, verbose_name=b'Rozpocz\xc4\x99cie funkcjonowania', blank=True)),
                ('zakonczenie_funkcjonowania', models.DateField(null=True, verbose_name=b'Zako\xc5\x84czenie funkcjonowania', blank=True)),
                ('nazwa', models.CharField(unique=True, max_length=512)),
                ('skrot', models.CharField(unique=True, max_length=4, verbose_name=b'Skr\xc3\xb3t')),
                ('opis', models.TextField(null=True, blank=True)),
                ('slug', autoslug.fields.AutoSlugField(unique=True, max_length=512, editable=False)),
                ('kolejnosc', models.IntegerField(default=0, verbose_name=b'Kolejno\xc5\x9b\xc4\x87')),
                ('widoczny', models.BooleanField(default=True)),
                ('uczelnia', models.ForeignKey(on_delete=models.CASCADE, to='bpp.Uczelnia')),
            ],
            options={
                'ordering': [b'kolejnosc', b'skrot'],
                'verbose_name': b'wydzia\xc5\x82',
                'verbose_name_plural': b'wydzia\xc5\x82y',
            },
            bases=(models.Model,),
        ),
        migrations.AddField(
            model_name='opi_2012_afiliacja_do_wydzialu',
            name='wydzial',
            field=models.ForeignKey(on_delete=models.CASCADE, to='bpp.Wydzial'),
            preserve_default=True,
        ),
        migrations.AlterUniqueTogether(
            name='opi_2012_afiliacja_do_wydzialu',
            unique_together=set([('autor', 'wydzial', 'rok')]),
        ),
        migrations.AddField(
            model_name='jednostka',
            name='wydzial',
            field=models.ForeignKey(on_delete=models.CASCADE, verbose_name=b'Wydzia\xc5\x82', to='bpp.Wydzial'),
            preserve_default=True,
        ),
        migrations.CreateModel(
            name='Zasieg_Zrodla',
            fields=[
                ('id', models.AutoField(verbose_name='ID', serialize=False, auto_created=True, primary_key=True)),
                ('nazwa', models.CharField(unique=True, max_length=512)),
            ],
            options={
                'verbose_name': b'zasi\xc4\x99g \xc5\xbar\xc3\xb3d\xc5\x82a',
                'verbose_name_plural': b'zasi\xc4\x99g \xc5\xbar\xc3\xb3de\xc5\x82',
            },
            bases=(models.Model,),
        ),
        migrations.CreateModel(
            name='Zrodlo',
            fields=[
                ('id', models.AutoField(verbose_name='ID', serialize=False, auto_created=True, primary_key=True)),
                ('ostatnio_zmieniony', models.DateTimeField(auto_now=True, auto_now_add=True, null=True, db_index=True)),
                ('adnotacje', models.TextField(help_text=b'Pole do u\xc5\xbcytku wewn\xc4\x99trznego -\n    wpisane tu informacje nie s\xc4\x85 wy\xc5\x9bwietlane na stronach WWW dost\xc4\x99pnych\n    dla u\xc5\xbcytkownik\xc3\xb3w ko\xc5\x84cowych.', null=True, db_index=True, blank=True)),
                ('issn', models.CharField(max_length=32, null=True, verbose_name=b'ISSN', blank=True)),
                ('e_issn', models.CharField(max_length=32, null=True, verbose_name=b'e-ISSN', blank=True)),
                ('nazwa', models.CharField(max_length=1024, db_index=True)),
                ('skrot', models.CharField(max_length=512, verbose_name=b'Skr\xc3\xb3t')),
                ('www', models.URLField(max_length=1024, null=True, verbose_name=b'WWW', blank=True)),
                ('poprzednia_nazwa', models.CharField(db_index=True, max_length=1024, null=True, verbose_name=b'Poprzedni tytu\xc5\x82', blank=True)),
                ('search', SearchVectorField(default=b'', serialize=False, null=True, editable=False, db_index=True)),
                ('slug', autoslug.fields.AutoSlugField(unique=True, editable=False)),
                ('rodzaj', models.ForeignKey(on_delete=models.CASCADE, to='bpp.Rodzaj_Zrodla')),
                ('zasieg', models.ForeignKey(on_delete=models.CASCADE, default=None, blank=True, to='bpp.Zasieg_Zrodla', null=True)),
            ],
            options={
                'ordering': [b'nazwa'],
                'verbose_name': b'\xc5\xbar\xc3\xb3d\xc5\x82o',
                'verbose_name_plural': b'\xc5\xbar\xc3\xb3d\xc5\x82a',
            },
            bases=(models.Model,),
        ),
        migrations.AddField(
            model_name='wydawnictwo_ciagle',
            name='zrodlo',
            field=models.ForeignKey(on_delete=models.CASCADE, verbose_name=b'\xc5\xb9r\xc3\xb3d\xc5\x82o', to='bpp.Zrodlo', null=True),
            preserve_default=True,
        ),
        migrations.AddField(
            model_name='redakcja_zrodla',
            name='zrodlo',
            field=models.ForeignKey(on_delete=models.CASCADE, to='bpp.Zrodlo'),
            preserve_default=True,
        ),
        migrations.AddField(
            model_name='punktacja_zrodla',
            name='zrodlo',
            field=models.ForeignKey(on_delete=models.CASCADE, to='bpp.Zrodlo'),
            preserve_default=True,
        ),
        migrations.AlterUniqueTogether(
            name='punktacja_zrodla',
            unique_together=set([('zrodlo', 'rok')]),
        ),
        migrations.CreateModel(
            name='Zrodlo_Informacji',
            fields=[
                ('id', models.AutoField(verbose_name='ID', serialize=False, auto_created=True, primary_key=True)),
                ('nazwa', models.CharField(unique=True, max_length=512)),
            ],
            options={
                'verbose_name': b'\xc5\xbar\xc3\xb3d\xc5\x82o informacji o bibliografii',
                'verbose_name_plural': b'\xc5\xbar\xc3\xb3d\xc5\x82a informacji o bibliografii',
            },
            bases=(models.Model,),
        ),
        migrations.AddField(
            model_name='wydawnictwo_zwarte',
            name='informacja_z',
            field=models.ForeignKey(on_delete=models.CASCADE, blank=True, to='bpp.Zrodlo_Informacji', null=True),
            preserve_default=True,
        ),
        migrations.AddField(
            model_name='wydawnictwo_ciagle',
            name='informacja_z',
            field=models.ForeignKey(on_delete=models.CASCADE, blank=True, to='bpp.Zrodlo_Informacji', null=True),
            preserve_default=True,
        ),
        migrations.AddField(
            model_name='praca_habilitacyjna',
            name='informacja_z',
            field=models.ForeignKey(on_delete=models.CASCADE, blank=True, to='bpp.Zrodlo_Informacji', null=True),
            preserve_default=True,
        ),
        migrations.AddField(
            model_name='praca_doktorska',
            name='informacja_z',
            field=models.ForeignKey(on_delete=models.CASCADE, blank=True, to='bpp.Zrodlo_Informacji', null=True),
            preserve_default=True,
        ),
        migrations.AddField(
            model_name='patent',
            name='informacja_z',
            field=models.ForeignKey(on_delete=models.CASCADE, blank=True, to='bpp.Zrodlo_Informacji', null=True),
            preserve_default=True,
        ),

        RunSQL("CREATE OR REPLACE LANGUAGE plpython3u"),
        RunPython(lambda *args, **kw: load_custom_sql("0001_indeksy")),
        RunPython(lambda *args, **kw: load_custom_sql("0001_tytul_oryginalny_sort_triggers")),
        RunPython(lambda *args, **kw: load_custom_sql("0001_widoki_kronika")),
        RunPython(lambda *args, **kw: load_custom_sql("0001_widoki_sumy")),
        RunPython(lambda *args, **kw: load_custom_sql("0001_widoki_rekord")),
        RunPython(lambda *args, **kw: load_custom_sql("0001_widoki_autorzy")),
        RunPython(lambda *args, **kw: load_custom_sql("0001_fulltext")),

        RunPython(lambda *args, **kw: load_custom_sql("0001_cache_init")),
        RunPython(lambda *args, **kw: load_custom_sql("0001_cache_functions"))
    ]
