<p align="center">
<img alt="Logo" src="static/header_git.png"/ width="1000">
</p>

<h2 align="center">
 Data observability for analytics & data engineers
</h2>
<h4 align="center">
Monitor your data quality, operation and performance directly from your dbt project.
</h4>

<p align="center">
<a href="https://join.slack.com/t/elementary-community/shared_invite/zt-uehfrq2f-zXeVTtXrjYRbdE_V6xq4Rg"><img src="https://img.shields.io/badge/join-Slack-ff69b4"/></a>
<a href="https://docs.elementary-data.com/quickstart"><img src="https://img.shields.io/badge/docs-quickstart-orange"/></a>
<img alt="License" src="https://img.shields.io/badge/license-Apache--2.0-ff69b4"/>
<img alt="Downloads" src="https://static.pepy.tech/personalized-badge/elementary-lineage?period=total&units=international_system&left_color=grey&right_color=orange"&left_text=Downloads"/>

<div align="center">

⭐️ If you like it, star the repo <a href="https://github.com/elementary-data/elementary/stargazers"><img src="static/star_github.png" width="30"/></a> ⭐

[Demo »](https://bit.ly/3IAp9wf) | [Docs »](https://docs.elementary-data.com/) | [Slack »](https://join.slack.com/t/elementary-community/shared_invite/zt-uehfrq2f-zXeVTtXrjYRbdE_V6xq4Rg)

</div>

## What is Elementary?

Elementary is an open-source data observability solution, built for dbt users. Setup in minutes, gain immediate visibility, detect data issues, send actionable alerts, and understand impact and root cause.


<kbd align="center">
        <a href="https://storage.googleapis.com/elementary_static/elementary_demo.html"><img align="center" style="max-width:300px;" src="static/report_ui.gif"> </a>
</kbd>

<br>

## Quick start

Step 1 - [Install Elementary dbt package](https://docs.elementary-data.com/quickstart) 

Step 2 - [Install Elementary CLI](https://docs.elementary-data.com/quickstart-cli)

   
## Features


 <img src="static/elementary_icon.ico" width="16"/> **Data observability report** - Generate a data observability report, host it or share with your team.

 <img src="static/elementary_icon.ico" width="16"/> **Anomaly detection dbt tests** - Collect data quality metrics and detect anomalies, as native dbt tests.

 <img src="static/elementary_icon.ico" width="16"/> **Test results** - Enriched with details for fast triage of issues.

 <img src="static/elementary_icon.ico" width="16"/> **Models performance** - Visibility of execution times, easy detection of degradation and bottlenecks.

 <img src="static/elementary_icon.ico" width="16"/> **Data lineage** - Enriched with test results, easy to navigate and filter.

 <img src="static/elementary_icon.ico" width="16"/> **dbt artifacts uploader** - Save metadata and run results as part of your dbt runs. 

 <img src="static/elementary_icon.ico" width="16"/> **Slack alerts** - Actionable alerts, including custom channels and tagging of owners and subscribers.


##
 
Join [Slack](https://join.slack.com/t/elementary-community/shared_invite/zt-uehfrq2f-zXeVTtXrjYRbdE_V6xq4Rg) to learn more on Elementary.

Our full documentation is [available here](https://docs.elementary-data.com/).


## How it works?

Elementary [dbt package](https://github.com/elementary-data/dbt-data-reliability) creates tables of metadata and test results in your data warehouse, as part of your dbt runs. The CLI tool reads the data from these tables, and is used to generate the UI and alerts. 

<img align="center" style="max-width:300px;" src="static/how_elementary_works.png">

## Community & Support

For additional information and help, you can use one of these channels:

* [Slack](https://join.slack.com/t/elementary-community/shared_invite/zt-uehfrq2f-zXeVTtXrjYRbdE_V6xq4Rg) \(Live chat with the team, support, discussions, etc.\)
* [GitHub issues](https://github.com/elementary-data/elementary/issues) \(Bug reports, feature requests)
* [Twitter](https://twitter.com/ElementaryData) \(Updates on new releases and stuff)


## **Integrations**

* [x] **dbt core (>=1.0.0)** ![](static/dbt-16.png)
* [x] **dbt cloud**  ![](static/dbt-16.png)

**Data warehouses:**
* [x] **Snowflake** ![](static/snowflake-16.png) 
* [x] **BigQuery**  ![](static/bigquery-16.svg) 
* [x] **Redshift**  ![](static/redshift-16.png)
* [x] **Databricks SQL**  ![](static/databricks-16.png)
* [x] **Postgres**  ![](static/postgres-16.png)

**Operations:**

* [x] **Slack** ![](static/slack-16.png)
* [x] **GitHub Actions**  ![](static/github-actions-16.png)
* [x] **Amazon S3**  ![](static/s3-16.svg)
* [x] **Google Cloud Storage**  ![](static/gcs-16.png)



Ask us for integrations on [Slack](https://join.slack.com/t/elementary-community/shared_invite/zt-uehfrq2f-zXeVTtXrjYRbdE_V6xq4Rg) or as a [GitHub issue](https://github.com/elementary-data/elementary-lineage/issues/new).


## **Contributions**

Thank you :orange_heart: Whether it’s a bug fix, new feature, or additional documentation - we greatly appreciate contributions!

Check out the [contributions guide](https://docs.elementary-data.com/general/contributions) and [open issues](https://github.com/elementary-data/elementary/issues). 


**Elementary contributors: ✨**

[//]: contributor-faces

<!-- ALL-CONTRIBUTORS-LIST:START - Do not remove or modify this section -->
<!-- prettier-ignore-start -->
<!-- markdownlint-disable -->
<a href="https://github.com/oravi"><img src="https://avatars.githubusercontent.com/u/4517234?v=4" width="50" height="50" alt=""/></a> 
<a href="https://github.com/elongl"><img src="https://avatars.githubusercontent.com/u/30181361?v=4" width="50" height="50" alt=""/></a>
<a href="https://github.com/Maayan-s"><img src="https://avatars.githubusercontent.com/u/22072028?v=4" width="50" height="50" alt=""/></a>
<a href="https://github.com/IDoneShaveIt"><img src="https://avatars.githubusercontent.com/u/48473443?v=4" width="50" height="50" alt=""/></a>
<a href="https://github.com/haritamar"><img src="https://avatars.githubusercontent.com/u/11314965?v=4" width="50" height="50" alt=""/></a>
<a href="https://github.com/Hadarsagiv"><img src="https://avatars.githubusercontent.com/u/119170841?v=4" width="50" height="50" alt=""/></a>
<a href="https://github.com/RoiTabach"><img src="https://avatars.githubusercontent.com/u/25003091?v=4" width="50" height="50" alt=""/></a>
<a href="https://github.com/hahnbeelee"><img src="https://avatars.githubusercontent.com/u/55263191?v=4" width="50" height="50" alt=""/></a>
<a href="https://github.com/seanglynn-thrive"><img src="https://avatars.githubusercontent.com/u/93200565?v=4" width="50" height="50" alt=""/></a>
<a href="https://github.com/hanywang2"><img src="https://avatars.githubusercontent.com/u/44352119?v=4" width="50" height="50" alt=""/></a>
<a href="https://github.com/Nic3Guy"><img src="https://avatars.githubusercontent.com/u/17640648?v=4" width="50" height="50" alt=""/></a>
<a href="https://github.com/yu-iskw"><img src="https://avatars.githubusercontent.com/u/1523515?v=4" width="50" height="50" alt=""/></a>
<a href="https://github.com/nimrodne"><img src="https://avatars.githubusercontent.com/u/12689357?v=4" width="50" height="50" alt=""/></a>
<a href="https://github.com/hanrok"><img src="https://avatars.githubusercontent.com/u/24649215?v=4" width="50" height="50" alt=""/></a>
<a href="https://github.com/shahafa"><img src="https://avatars.githubusercontent.com/u/904848?v=4" width="50" height="50" alt=""/></a>
<a href="https://github.com/aaron-westlake"><img src="https://avatars.githubusercontent.com/u/99689538?v=4" width="50" height="50" alt=""/></a>
<a href="https://github.com/YashPimple"><img src="https://avatars.githubusercontent.com/u/97302447?v=4" width="50" height="50" alt=""/></a>
<a href="https://github.com/Aylr"><img src="https://avatars.githubusercontent.com/u/928247?v=4" width="50" height="50" alt=""/></a>
<a href="https://github.com/dorazouri"><img src="https://avatars.githubusercontent.com/u/17954776?v=4" width="50" height="50" alt=""/></a>
<a href="https://github.com/ronmorgen1"><img src="https://avatars.githubusercontent.com/u/86912787?v=4" width="50" height="50" alt=""/></a>
<a href="https://github.com/Ecalzo"><img src="https://avatars.githubusercontent.com/u/44735669?v=4" width="50" height="50" alt=""/></a>
<a href="https://github.com/civitaspo"><img src="https://avatars.githubusercontent.com/u/4525500?v=4" width="50" height="50" alt=""/></a>
<a href="https://github.com/fredmny"><img src="https://avatars.githubusercontent.com/u/27257093?v=4" width="50" height="50" alt=""/></a>
<a href="https://github.com/GtheSheep"><img src="https://avatars.githubusercontent.com/u/13685708?v=4" width="50" height="50" alt=""/></a>
<a href="https://github.com/IrinaSel"><img src="https://avatars.githubusercontent.com/u/9607710?v=4" width="50" height="50" alt=""/></a>
<a href="https://github.com/jtalmi"><img src="https://avatars.githubusercontent.com/u/7266609?v=4" width="50" height="50" alt=""/></a>
<a href="https://github.com/tobias-mintlify"><img src="https://avatars.githubusercontent.com/u/110702161?v=4" width="50" height="50" alt=""/></a>
<a href="https://github.com/ValdarT"><img src="https://avatars.githubusercontent.com/u/7242935?v=4" width="50" height="50" alt=""/></a>
<a href="https://github.com/rloredo"><img src="https://avatars.githubusercontent.com/u/21148554?v=4" width="50" height="50" alt=""/></a>
<a href="https://github.com/a13xa1v35"><img src="https://avatars.githubusercontent.com/u/25589304?v=4" width="50" height="50" alt=""/></a>
<a href="https://github.com/kopackiw"><img src="https://avatars.githubusercontent.com/u/26244440?v=4" width="50" height="50" alt=""/></a>
<a href="https://github.com/eKatia"><img src="https://avatars.githubusercontent.com/u/79864170?v=4" width="50" height="50" alt=""/></a>
<a href="https://github.com/nzewail"><img src="https://avatars.githubusercontent.com/u/29211170?v=4" width="50" height="50" alt=""/></a>
<a href="https://github.com/hengpor"><img src="https://avatars.githubusercontent.com/u/4929007?v=4" width="50" height="50" alt=""/></a>
<a href="https://github.com/smitsrr"><img src="https://avatars.githubusercontent.com/u/8473398?v=4" width="50" height="50" alt=""/></a>
<a href="https://github.com/SBurwash"><img src="https://avatars.githubusercontent.com/u/35510512?v=4" width="50" height="50" alt=""/></a>
<a href="https://github.com/kkprab"><img src="https://avatars.githubusercontent.com/u/97446187?v=4" width="50" height="50" alt=""/></a>
<a href="https://github.com/ivan-toriya"><img src="https://avatars.githubusercontent.com/u/43750521?v=4" width="50" height="50" alt=""/></a>
<a href="https://github.com/jelstongreen"><img src="https://avatars.githubusercontent.com/u/17743866?v=4" width="50" height="50" alt=""/></a>
<a href="https://github.com/pei0804"><img src="https://avatars.githubusercontent.com/u/9821370?v=4" width="50" height="50" alt=""/></a>
<a href="https://github.com/esenilsson"><img src="https://avatars.githubusercontent.com/u/2824187?v=4" width="50" height="50" alt=""/></a>
<a href="https://github.com/pratik60"><img src="https://avatars.githubusercontent.com/u/2249430?v=4" width="50" height="50" alt=""/></a>
<a href="https://github.com/benoit-tropos-io"><img src="https://avatars.githubusercontent.com/u/79080900?v=4" width="50" height="50" alt=""/></a>
<a href="https://github.com/kouridis"><img src="https://avatars.githubusercontent.com/u/11500822?v=4" width="50" height="50" alt=""/></a>
<a href="https://github.com/clad"><img src="https://avatars.githubusercontent.com/u/41725?v=4" width="50" height="50" alt=""/></a>
<a href="https://github.com/Deathfireofdoom"><img src="https://avatars.githubusercontent.com/u/53213782?v=4" width="50" height="50" alt=""/></a>
<a href="https://github.com/frannydelaney"><img src="https://avatars.githubusercontent.com/u/77760780?v=4" width="50" height="50" alt=""/></a>
<a href="https://github.com/edbizarro"><img src="https://avatars.githubusercontent.com/u/84926?v=4" width="50" height="50" alt=""/></a>
<a href="https://github.com/Chintanvpatel"><img src="https://avatars.githubusercontent.com/u/1384301?v=4" width="50" height="50" alt=""/></a>
<a href="https://github.com/andreqaugusto"><img src="https://avatars.githubusercontent.com/u/68784205?v=4" width="50" height="50" alt=""/></a>
<a href="https://github.com/tc-chrisbui"><img src="https://avatars.githubusercontent.com/u/115048867?v=4" width="50" height="50" alt=""/></a>

<!-- markdownlint-restore -->
<!-- prettier-ignore-end -->

<!-- ALL-CONTRIBUTORS-LIST:END -->
