/// Files: arch/x86/xen/p2m.c drivers/xen/unpopulated-alloc.c
/// Fix: 882213990d32fd224340a4533f6318dd152be4b2
/// Fixes: 9e2369c06c8a181478039258a4598c1ddd2cadfa

virtual detect

@unpopulated_alloc exists@
@@

xen_alloc_unpopulated_pages(...)
{
	...
}

@err_xen_vmalloc depends on unpopulated_alloc exists@
position p;
@@

xen_vmalloc_p2m_tree(void)
{
	...
	p2m_limit = ... / PAGE_SIZE;
	... when != if (!p2m_limit && IS_ENABLED(CONFIG_XEN_UNPOPULATED_ALLOC)) p2m_limit = xen_start_info->nr_pages * XEN_EXTRA_MEM_RATIO;
*	vm.flags =@p VM_ALLOC;
	...
}

@err_set_phys_to_machine depends on unpopulated_alloc exists@
identifier pfn, mfn, xen_p2m_size;
position p;
@@

__set_phys_to_machine(unsigned long pfn, unsigned long mfn)
{
	...
*	if (unlikely(pfn >= xen_p2m_size)) {
*		BUG_ON(mfn != INVALID_P2M_ENTRY);
*		return true;@p
*	}
	...
}

@script:python depends on detect@
p << err_xen_vmalloc.p;
@@

coccilib.report.print_report(p[0], 'ERROR: CVE-2021-28039')

@script:python depends on detect@
p << err_set_phys_to_machine.p;
@@

coccilib.report.print_report(p[0], 'ERROR: CVE-2021-28039')
