/// Files: kernel/trace/ring_buffer.c
/// Fix: bbeb97464eefc65f506084fd9f18f21653e01137
/// Detect-To: 83f40318dab00e3298a1f6d0b12ac025e84e478d

virtual detect

@resize exists@
identifier buffer, cpu_buffer;
@@

ring_buffer_resize(...)
{
	... when any
	buffer->resize_disabled
	... when any
	rb_update_pages(cpu_buffer);
	... when any
}

@err_ring_buffer_reset_cpu depends on resize exists@
identifier buffer1, buffer2;
position p;
@@

ring_buffer_reset_cpu(...)
{
	... when != mutex_lock(&buffer1->mutex);
*	atomic_inc(&buffer2->resize_disabled);@p
	...
	atomic_dec(&buffer2->resize_disabled);
	... when != mutex_unlock(&buffer1->mutex);
}

@err_ring_buffer_reset_online_cpus depends on resize exists@
identifier buffer, cpu, cpu_buffer;
iterator name for_each_online_buffer_cpu;
position p;
@@

ring_buffer_reset_online_cpus(struct trace_buffer *buffer)
{
	... when != mutex_lock(&buffer->mutex);
*	for_each_online_buffer_cpu(buffer, cpu)@p {
		...
		atomic_inc(&cpu_buffer->resize_disabled);
		...
	}
	...
	for_each_online_buffer_cpu(buffer, cpu) {
		...
		atomic_dec(&cpu_buffer->resize_disabled)
		...
	}
	... when != mutex_unlock(&buffer->mutex);
}

@script:python depends on detect@
p << err_ring_buffer_reset_cpu.p;
@@

coccilib.report.print_report(p[0], 'ERROR: CVE-2020-27825')

@script:python depends on detect@
p << err_ring_buffer_reset_online_cpus.p;
@@

coccilib.report.print_report(p[0], 'ERROR: CVE-2020-27825')
