from setuptools import setup

name = "types-influxdb-client"
description = "Typing stubs for influxdb-client"
long_description = '''
## Typing stubs for influxdb-client

This is a PEP 561 type stub package for the `influxdb-client` package. It
can be used by type-checking tools like
[mypy](https://github.com/python/mypy/),
[pyright](https://github.com/microsoft/pyright),
[pytype](https://github.com/google/pytype/),
PyCharm, etc. to check code that uses
`influxdb-client`. The source for this package can be found at
https://github.com/python/typeshed/tree/main/stubs/influxdb-client. All fixes for
types and metadata should be contributed there.

See https://github.com/python/typeshed/blob/main/README.md for more details.
This package was generated from typeshed commit `7180d0223b3cfb0275bdc4dff902439536dd4e3d`.
'''.lstrip()

setup(name=name,
      version="1.36.0.2",
      description=description,
      long_description=long_description,
      long_description_content_type="text/markdown",
      url="https://github.com/python/typeshed",
      project_urls={
          "GitHub": "https://github.com/python/typeshed",
          "Changes": "https://github.com/typeshed-internal/stub_uploader/blob/main/data/changelogs/influxdb-client.md",
          "Issue tracker": "https://github.com/python/typeshed/issues",
          "Chat": "https://gitter.im/python/typing",
      },
      install_requires=['types-urllib3'],
      packages=['influxdb_client-stubs'],
      package_data={'influxdb_client-stubs': ['__init__.pyi', '_async/__init__.pyi', '_async/api_client.pyi', '_async/rest.pyi', '_sync/__init__.pyi', '_sync/api_client.pyi', '_sync/rest.pyi', 'client/__init__.pyi', 'client/_base.pyi', 'client/authorizations_api.pyi', 'client/bucket_api.pyi', 'client/delete_api.pyi', 'client/delete_api_async.pyi', 'client/exceptions.pyi', 'client/flux_csv_parser.pyi', 'client/flux_table.pyi', 'client/influxdb_client.pyi', 'client/influxdb_client_async.pyi', 'client/invokable_scripts_api.pyi', 'client/labels_api.pyi', 'client/logging_handler.pyi', 'client/organizations_api.pyi', 'client/query_api.pyi', 'client/query_api_async.pyi', 'client/tasks_api.pyi', 'client/users_api.pyi', 'client/util/__init__.pyi', 'client/util/date_utils.pyi', 'client/util/date_utils_pandas.pyi', 'client/util/helpers.pyi', 'client/util/multiprocessing_helper.pyi', 'client/warnings.pyi', 'client/write/__init__.pyi', 'client/write/dataframe_serializer.pyi', 'client/write/point.pyi', 'client/write/retry.pyi', 'client/write_api.pyi', 'client/write_api_async.pyi', 'configuration.pyi', 'domain/__init__.pyi', 'domain/add_resource_member_request_body.pyi', 'domain/analyze_query_response.pyi', 'domain/analyze_query_response_errors.pyi', 'domain/array_expression.pyi', 'domain/ast_response.pyi', 'domain/authorization.pyi', 'domain/authorization_post_request.pyi', 'domain/authorization_update_request.pyi', 'domain/authorizations.pyi', 'domain/axes.pyi', 'domain/axis.pyi', 'domain/axis_scale.pyi', 'domain/bad_statement.pyi', 'domain/band_view_properties.pyi', 'domain/binary_expression.pyi', 'domain/block.pyi', 'domain/boolean_literal.pyi', 'domain/bucket.pyi', 'domain/bucket_links.pyi', 'domain/bucket_metadata_manifest.pyi', 'domain/bucket_retention_rules.pyi', 'domain/bucket_shard_mapping.pyi', 'domain/buckets.pyi', 'domain/builder_aggregate_function_type.pyi', 'domain/builder_config.pyi', 'domain/builder_config_aggregate_window.pyi', 'domain/builder_functions_type.pyi', 'domain/builder_tags_type.pyi', 'domain/builtin_statement.pyi', 'domain/call_expression.pyi', 'domain/cell.pyi', 'domain/cell_links.pyi', 'domain/cell_update.pyi', 'domain/cell_with_view_properties.pyi', 'domain/check.pyi', 'domain/check_base.pyi', 'domain/check_base_links.pyi', 'domain/check_discriminator.pyi', 'domain/check_patch.pyi', 'domain/check_status_level.pyi', 'domain/check_view_properties.pyi', 'domain/checks.pyi', 'domain/column_data_type.pyi', 'domain/column_semantic_type.pyi', 'domain/conditional_expression.pyi', 'domain/config.pyi', 'domain/constant_variable_properties.pyi', 'domain/create_cell.pyi', 'domain/create_dashboard_request.pyi', 'domain/custom_check.pyi', 'domain/dashboard.pyi', 'domain/dashboard_color.pyi', 'domain/dashboard_query.pyi', 'domain/dashboard_with_view_properties.pyi', 'domain/dashboards.pyi', 'domain/date_time_literal.pyi', 'domain/dbr_ps.pyi', 'domain/dbrp.pyi', 'domain/dbrp_create.pyi', 'domain/dbrp_get.pyi', 'domain/dbrp_update.pyi', 'domain/deadman_check.pyi', 'domain/decimal_places.pyi', 'domain/delete_predicate_request.pyi', 'domain/dialect.pyi', 'domain/dict_expression.pyi', 'domain/dict_item.pyi', 'domain/duration.pyi', 'domain/duration_literal.pyi', 'domain/error.pyi', 'domain/expression.pyi', 'domain/expression_statement.pyi', 'domain/field.pyi', 'domain/file.pyi', 'domain/float_literal.pyi', 'domain/flux_response.pyi', 'domain/flux_suggestion.pyi', 'domain/flux_suggestions.pyi', 'domain/function_expression.pyi', 'domain/gauge_view_properties.pyi', 'domain/greater_threshold.pyi', 'domain/health_check.pyi', 'domain/heatmap_view_properties.pyi', 'domain/histogram_view_properties.pyi', 'domain/http_notification_endpoint.pyi', 'domain/http_notification_rule.pyi', 'domain/http_notification_rule_base.pyi', 'domain/identifier.pyi', 'domain/import_declaration.pyi', 'domain/index_expression.pyi', 'domain/integer_literal.pyi', 'domain/is_onboarding.pyi', 'domain/label.pyi', 'domain/label_create_request.pyi', 'domain/label_mapping.pyi', 'domain/label_response.pyi', 'domain/label_update.pyi', 'domain/labels_response.pyi', 'domain/language_request.pyi', 'domain/legacy_authorization_post_request.pyi', 'domain/lesser_threshold.pyi', 'domain/line_plus_single_stat_properties.pyi', 'domain/line_protocol_error.pyi', 'domain/line_protocol_length_error.pyi', 'domain/links.pyi', 'domain/list_stacks_response.pyi', 'domain/log_event.pyi', 'domain/logical_expression.pyi', 'domain/logs.pyi', 'domain/map_variable_properties.pyi', 'domain/markdown_view_properties.pyi', 'domain/measurement_schema.pyi', 'domain/measurement_schema_column.pyi', 'domain/measurement_schema_create_request.pyi', 'domain/measurement_schema_list.pyi', 'domain/measurement_schema_update_request.pyi', 'domain/member_assignment.pyi', 'domain/member_expression.pyi', 'domain/metadata_backup.pyi', 'domain/model_property.pyi', 'domain/mosaic_view_properties.pyi', 'domain/node.pyi', 'domain/notification_endpoint.pyi', 'domain/notification_endpoint_base.pyi', 'domain/notification_endpoint_base_links.pyi', 'domain/notification_endpoint_discriminator.pyi', 'domain/notification_endpoint_type.pyi', 'domain/notification_endpoint_update.pyi', 'domain/notification_endpoints.pyi', 'domain/notification_rule.pyi', 'domain/notification_rule_base.pyi', 'domain/notification_rule_base_links.pyi', 'domain/notification_rule_discriminator.pyi', 'domain/notification_rule_update.pyi', 'domain/notification_rules.pyi', 'domain/object_expression.pyi', 'domain/onboarding_request.pyi', 'domain/onboarding_response.pyi', 'domain/option_statement.pyi', 'domain/organization.pyi', 'domain/organization_links.pyi', 'domain/organizations.pyi', 'domain/package.pyi', 'domain/package_clause.pyi', 'domain/pager_duty_notification_endpoint.pyi', 'domain/pager_duty_notification_rule.pyi', 'domain/pager_duty_notification_rule_base.pyi', 'domain/paren_expression.pyi', 'domain/password_reset_body.pyi', 'domain/patch_bucket_request.pyi', 'domain/patch_dashboard_request.pyi', 'domain/patch_organization_request.pyi', 'domain/patch_retention_rule.pyi', 'domain/patch_stack_request.pyi', 'domain/patch_stack_request_additional_resources.pyi', 'domain/permission.pyi', 'domain/permission_resource.pyi', 'domain/pipe_expression.pyi', 'domain/pipe_literal.pyi', 'domain/post_bucket_request.pyi', 'domain/post_check.pyi', 'domain/post_notification_endpoint.pyi', 'domain/post_notification_rule.pyi', 'domain/post_organization_request.pyi', 'domain/post_restore_kv_response.pyi', 'domain/post_stack_request.pyi', 'domain/property_key.pyi', 'domain/query.pyi', 'domain/query_edit_mode.pyi', 'domain/query_variable_properties.pyi', 'domain/query_variable_properties_values.pyi', 'domain/range_threshold.pyi', 'domain/ready.pyi', 'domain/regexp_literal.pyi', 'domain/remote_connection.pyi', 'domain/remote_connection_creation_request.pyi', 'domain/remote_connection_update_request.pyi', 'domain/remote_connections.pyi', 'domain/renamable_field.pyi', 'domain/replication.pyi', 'domain/replication_creation_request.pyi', 'domain/replication_update_request.pyi', 'domain/replications.pyi', 'domain/resource_member.pyi', 'domain/resource_members.pyi', 'domain/resource_members_links.pyi', 'domain/resource_owner.pyi', 'domain/resource_owners.pyi', 'domain/restored_bucket_mappings.pyi', 'domain/retention_policy_manifest.pyi', 'domain/return_statement.pyi', 'domain/routes.pyi', 'domain/routes_external.pyi', 'domain/routes_query.pyi', 'domain/routes_system.pyi', 'domain/rule_status_level.pyi', 'domain/run.pyi', 'domain/run_links.pyi', 'domain/run_manually.pyi', 'domain/runs.pyi', 'domain/scatter_view_properties.pyi', 'domain/schema_type.pyi', 'domain/scraper_target_request.pyi', 'domain/scraper_target_response.pyi', 'domain/scraper_target_responses.pyi', 'domain/script.pyi', 'domain/script_create_request.pyi', 'domain/script_invocation_params.pyi', 'domain/script_language.pyi', 'domain/script_update_request.pyi', 'domain/scripts.pyi', 'domain/secret_keys.pyi', 'domain/secret_keys_response.pyi', 'domain/shard_group_manifest.pyi', 'domain/shard_manifest.pyi', 'domain/shard_owner.pyi', 'domain/simple_table_view_properties.pyi', 'domain/single_stat_view_properties.pyi', 'domain/slack_notification_endpoint.pyi', 'domain/slack_notification_rule.pyi', 'domain/slack_notification_rule_base.pyi', 'domain/smtp_notification_rule.pyi', 'domain/smtp_notification_rule_base.pyi', 'domain/source.pyi', 'domain/source_links.pyi', 'domain/sources.pyi', 'domain/stack.pyi', 'domain/stack_associations.pyi', 'domain/stack_events.pyi', 'domain/stack_links.pyi', 'domain/stack_resources.pyi', 'domain/statement.pyi', 'domain/static_legend.pyi', 'domain/status_rule.pyi', 'domain/string_literal.pyi', 'domain/subscription_manifest.pyi', 'domain/table_view_properties.pyi', 'domain/table_view_properties_table_options.pyi', 'domain/tag_rule.pyi', 'domain/task.pyi', 'domain/task_create_request.pyi', 'domain/task_links.pyi', 'domain/task_status_type.pyi', 'domain/task_update_request.pyi', 'domain/tasks.pyi', 'domain/telegraf.pyi', 'domain/telegraf_plugin.pyi', 'domain/telegraf_plugin_request.pyi', 'domain/telegraf_plugin_request_plugins.pyi', 'domain/telegraf_plugins.pyi', 'domain/telegraf_request.pyi', 'domain/telegraf_request_metadata.pyi', 'domain/telegrafs.pyi', 'domain/telegram_notification_endpoint.pyi', 'domain/telegram_notification_rule.pyi', 'domain/telegram_notification_rule_base.pyi', 'domain/template_apply.pyi', 'domain/template_apply_remotes.pyi', 'domain/template_apply_template.pyi', 'domain/template_chart.pyi', 'domain/template_export_by_id.pyi', 'domain/template_export_by_id_org_ids.pyi', 'domain/template_export_by_id_resource_filters.pyi', 'domain/template_export_by_id_resources.pyi', 'domain/template_export_by_name.pyi', 'domain/template_export_by_name_resources.pyi', 'domain/template_kind.pyi', 'domain/template_summary.pyi', 'domain/template_summary_diff.pyi', 'domain/template_summary_diff_buckets.pyi', 'domain/template_summary_diff_buckets_new_old.pyi', 'domain/template_summary_diff_checks.pyi', 'domain/template_summary_diff_dashboards.pyi', 'domain/template_summary_diff_dashboards_new_old.pyi', 'domain/template_summary_diff_label_mappings.pyi', 'domain/template_summary_diff_labels.pyi', 'domain/template_summary_diff_labels_new_old.pyi', 'domain/template_summary_diff_notification_endpoints.pyi', 'domain/template_summary_diff_notification_rules.pyi', 'domain/template_summary_diff_notification_rules_new_old.pyi', 'domain/template_summary_diff_tasks.pyi', 'domain/template_summary_diff_tasks_new_old.pyi', 'domain/template_summary_diff_telegraf_configs.pyi', 'domain/template_summary_diff_variables.pyi', 'domain/template_summary_diff_variables_new_old.pyi', 'domain/template_summary_errors.pyi', 'domain/template_summary_label.pyi', 'domain/template_summary_label_properties.pyi', 'domain/template_summary_summary.pyi', 'domain/template_summary_summary_buckets.pyi', 'domain/template_summary_summary_dashboards.pyi', 'domain/template_summary_summary_label_mappings.pyi', 'domain/template_summary_summary_notification_rules.pyi', 'domain/template_summary_summary_status_rules.pyi', 'domain/template_summary_summary_tag_rules.pyi', 'domain/template_summary_summary_tasks.pyi', 'domain/template_summary_summary_variables.pyi', 'domain/test_statement.pyi', 'domain/threshold.pyi', 'domain/threshold_base.pyi', 'domain/threshold_check.pyi', 'domain/unary_expression.pyi', 'domain/unsigned_integer_literal.pyi', 'domain/user.pyi', 'domain/user_response.pyi', 'domain/user_response_links.pyi', 'domain/users.pyi', 'domain/variable.pyi', 'domain/variable_assignment.pyi', 'domain/variable_links.pyi', 'domain/variable_properties.pyi', 'domain/variables.pyi', 'domain/view.pyi', 'domain/view_links.pyi', 'domain/view_properties.pyi', 'domain/views.pyi', 'domain/write_precision.pyi', 'domain/xy_geom.pyi', 'domain/xy_view_properties.pyi', 'extras.pyi', 'rest.pyi', 'service/__init__.pyi', 'service/_base_service.pyi', 'service/authorizations_service.pyi', 'service/backup_service.pyi', 'service/bucket_schemas_service.pyi', 'service/buckets_service.pyi', 'service/cells_service.pyi', 'service/checks_service.pyi', 'service/config_service.pyi', 'service/dashboards_service.pyi', 'service/dbr_ps_service.pyi', 'service/delete_service.pyi', 'service/health_service.pyi', 'service/invokable_scripts_service.pyi', 'service/labels_service.pyi', 'service/legacy_authorizations_service.pyi', 'service/metrics_service.pyi', 'service/notification_endpoints_service.pyi', 'service/notification_rules_service.pyi', 'service/organizations_service.pyi', 'service/ping_service.pyi', 'service/query_service.pyi', 'service/ready_service.pyi', 'service/remote_connections_service.pyi', 'service/replications_service.pyi', 'service/resources_service.pyi', 'service/restore_service.pyi', 'service/routes_service.pyi', 'service/rules_service.pyi', 'service/scraper_targets_service.pyi', 'service/secrets_service.pyi', 'service/setup_service.pyi', 'service/signin_service.pyi', 'service/signout_service.pyi', 'service/sources_service.pyi', 'service/tasks_service.pyi', 'service/telegraf_plugins_service.pyi', 'service/telegrafs_service.pyi', 'service/templates_service.pyi', 'service/users_service.pyi', 'service/variables_service.pyi', 'service/views_service.pyi', 'service/write_service.pyi', 'version.pyi', 'METADATA.toml']},
      license="Apache-2.0 license",
      classifiers=[
          "License :: OSI Approved :: Apache Software License",
          "Programming Language :: Python :: 3",
          "Typing :: Stubs Only",
      ]
)
