def 붓꽃데이터부르기():
    from sklearn.datasets import load_iris
    import pandas as pd
    iris_db = load_iris()
    f_names = ['sepal_length', 'sepal_width', 'petal_length', 'petal_width']
    iris_df1 = pd.DataFrame(iris_db.data, columns=f_names)
    iris_df2 = pd.DataFrame(iris_db.target)
    iris_df2.columns = ['sp']
    iris_df2.sp = iris_df2.sp.map({0:'setosa', 1:'versicolor', 2:'virginica'})
    iris_df = pd.concat([iris_df1, iris_df2], axis=1)
    iris_df.head()
    return iris_df

def 산점도(x, y, user_color, save_parity):
    import matplotlib.pyplot as plt
    df = 붓꽃데이터부르기()
    user_color = user_color
    x_str = x
    y_str = y
    plt.scatter(df[x_str], df[y_str], color=user_color)
    if save_parity == 1:
        plt.savefig('./graph1.png')
    plt.show()
    

def 상관관계도(user_color, save_parity):
    import seaborn as sns
    import matplotlib.pyplot as plt
    df = 붓꽃데이터부르기()
    user_color = user_color
    corr_df = df.iloc[:,:4].corr()
    fig = plt.figure(figsize=(10,6))
    sns.heatmap(data=corr_df, annot=True, fmt='.2f', cmap=user_color)
    plt.xticks(rotation=60)
    plt.show()
    if save_parity == 1:
        fig.savefig('./graph2.png')

def 교차도(save_parity):
    import seaborn as sns
    import matplotlib.pyplot as plt
    df = 붓꽃데이터부르기()
    plt.figure(figsize=(10,6))
    sns.pairplot(data=df.iloc[:,:4])
    if save_parity == 1:
        plt.savefig('./graph3.png')
    plt.show()