"use strict";
var _a;
Object.defineProperty(exports, "__esModule", { value: true });
exports.S3ToSqs = void 0;
const JSII_RTTI_SYMBOL_1 = Symbol.for("jsii.rtti");
const defaults = require("@aws-solutions-constructs/core");
const s3n = require("@aws-cdk/aws-s3-notifications");
const core_1 = require("@aws-cdk/core");
const core_2 = require("@aws-solutions-constructs/core");
/**
 * @summary The S3ToSqs class.
 */
class S3ToSqs extends core_1.Construct {
    /**
     * @param scope - represents the scope for all the resources.
     * @param id - this is a a scope-unique id.
     * @param props - user provided props for the construct.
     * @summary Constructs a new instance of the S3ToSqs class.
     * @since 0.8.0
     * @access public
     */
    constructor(scope, id, props) {
        super(scope, id);
        defaults.CheckProps(props);
        let bucket;
        let enableEncryptionParam = props.enableEncryptionWithCustomerManagedKey;
        if (props.enableEncryptionWithCustomerManagedKey === undefined ||
            props.enableEncryptionWithCustomerManagedKey === true) {
            enableEncryptionParam = true;
        }
        // Setup the S3 bucket
        if (!props.existingBucketObj) {
            [this.s3Bucket, this.s3LoggingBucket] = defaults.buildS3Bucket(this, {
                bucketProps: props.bucketProps,
                loggingBucketProps: props.loggingBucketProps,
                logS3AccessLogs: props.logS3AccessLogs
            });
            bucket = this.s3Bucket;
        }
        else {
            bucket = props.existingBucketObj;
        }
        this.s3BucketInterface = bucket;
        // Setup the dead letter queue, if applicable
        this.deadLetterQueue = defaults.buildDeadLetterQueue(this, {
            existingQueueObj: props.existingQueueObj,
            deployDeadLetterQueue: props.deployDeadLetterQueue,
            deadLetterQueueProps: props.deadLetterQueueProps,
            maxReceiveCount: props.maxReceiveCount
        });
        // Setup the queue
        [this.sqsQueue, this.encryptionKey] = defaults.buildQueue(this, 'queue', {
            existingQueueObj: props.existingQueueObj,
            queueProps: props.queueProps,
            deadLetterQueue: this.deadLetterQueue,
            enableEncryptionWithCustomerManagedKey: enableEncryptionParam,
            encryptionKey: props.encryptionKey
        });
        // Setup the S3 bucket event types
        let s3EventTypes;
        if (!props.s3EventTypes) {
            s3EventTypes = defaults.defaultS3NotificationEventTypes;
        }
        else {
            s3EventTypes = props.s3EventTypes;
        }
        // Setup the S3 bucket event filters
        let s3Eventfilters = [];
        if (props.s3EventFilters) {
            s3Eventfilters = props.s3EventFilters;
        }
        // Setup the S3 bucket event notifications
        s3EventTypes.forEach(type => bucket.addEventNotification(type, new s3n.SqsDestination(this.sqsQueue), ...s3Eventfilters));
        core_2.addCfnNagS3BucketNotificationRulesToSuppress(core_1.Stack.of(this), 'BucketNotificationsHandler050a0587b7544547bf325f094a3db834');
    }
}
exports.S3ToSqs = S3ToSqs;
_a = JSII_RTTI_SYMBOL_1;
S3ToSqs[_a] = { fqn: "@aws-solutions-constructs/aws-s3-sqs.S3ToSqs", version: "1.134.0" };
//# sourceMappingURL=data:application/json;base64,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