"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.getCalendarState = void 0;
const aws_sdk_1 = require("aws-sdk");
/**
 * Gets the state of the calendar at the current time.
 * @param calendarName The name of the calendar
 * @returns A CalendarState object.
 */
exports.getCalendarState = async (calendarName) => {
    const fallbackNextTransitionTime = '2999-01-01T00:00:00Z';
    const ssm = new aws_sdk_1.SSM();
    try {
        const result = await ssm
            .getCalendarState({ CalendarNames: [calendarName] })
            .promise();
        if (!result.State)
            throw new Error('getCalendarState returned an undefined state.');
        return {
            state: result.State,
            nextTransitionTime: result.NextTransitionTime ?? fallbackNextTransitionTime,
            summary: `Calendar is ${result.State} until ${result.NextTransitionTime ?? fallbackNextTransitionTime}.`,
        };
    }
    catch (error) {
        const summary = `Unable to retrieve calendar state for ${calendarName}.`;
        console.error(summary, error);
        return {
            state: 'CLOSED',
            nextTransitionTime: fallbackNextTransitionTime,
            summary,
        };
    }
};
//# sourceMappingURL=data:application/json;base64,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