import numpy as np
from PyMPDATA import ScalarField, VectorField, Solver, Stepper
from PyMPDATA.boundary_conditions import Constant


class Simulation:
    def __init__(self, settings, options, static=True):
        bcs = tuple([Constant(0) for _ in settings.grid])

        advector = VectorField(
            data=[comp.astype(options.dtype) for comp in settings.advector],
            halo=options.n_halo,
            boundary_conditions=bcs
        )

        advectee = ScalarField(
            data=np.asarray(settings.advectee, dtype=options.dtype),
            halo=options.n_halo,
            boundary_conditions=bcs
        )

        args = {'grid': settings.grid} if static else {'n_dims': len(settings.grid)}
        stepper = Stepper(options=options, **args)
        self.solver = Solver(stepper=stepper, advectee=advectee, advector=advector)

    def run(self, nt):
        _ = self.solver.advance(nt)
