# Generated by Django 3.2 on 2021-11-30 16:04

from django.db import migrations, models
import django.db.models.deletion


class Migration(migrations.Migration):

    dependencies = [
        ('django_easy_report', '0001_initial'),
    ]

    operations = [
        migrations.CreateModel(
            name='SecretKey',
            fields=[
                ('id', models.BigAutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('mode', models.PositiveSmallIntegerField(choices=[(1, 'Environment'), (2, 'Django Settings'), (8, 'Cryptography'), (9, 'Cryptography from Environment key'), (10, 'Cryptography from Django secret')])),
                ('name', models.CharField(max_length=64, unique=True)),
                ('value', models.CharField(help_text='Environment key, Django setting name or with Cryptography mode encrypted value', max_length=512)),
                ('key', models.CharField(blank=True, help_text='With Cryptography: Environment key, Django setting name or Secret key', max_length=32, null=True)),
            ],
        ),
        migrations.CreateModel(
            name='SecretReplace',
            fields=[
                ('id', models.BigAutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('replace_word', models.SlugField(help_text='Word that will be replaced on "storage init params" field if is market as "${WORD}"', max_length=16)),
                ('secret', models.ForeignKey(on_delete=django.db.models.deletion.PROTECT, to='django_easy_report.secretkey')),
                ('sender', models.ForeignKey(on_delete=django.db.models.deletion.CASCADE, to='django_easy_report.reportsender')),
            ],
            options={
                'unique_together': {('secret', 'sender'), ('sender', 'replace_word')},
            },
        ),
    ]
