/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.wala.util.intset;

import com.ibm.wala.util.intset.IntSet;
import com.ibm.wala.util.intset.MutableIntSetFactory;
import com.ibm.wala.util.intset.MutableSparseIntSet;
import com.ibm.wala.util.intset.SparseIntSet;
import java.util.TreeSet;

public class MutableSparseIntSetFactory
implements MutableIntSetFactory<MutableSparseIntSet> {
    @Override
    public MutableSparseIntSet make(int[] set) {
        if (set == null) {
            throw new IllegalArgumentException("set is null");
        }
        if (set.length == 0) {
            return MutableSparseIntSet.makeEmpty();
        }
        TreeSet<Integer> T = new TreeSet<Integer>();
        for (int element : set) {
            T.add(element);
        }
        int[] copy = new int[T.size()];
        int i = 0;
        for (Integer I : T) {
            copy[i++] = I;
        }
        MutableSparseIntSet result = new MutableSparseIntSet(copy);
        return result;
    }

    @Override
    public MutableSparseIntSet parse(String string) throws NumberFormatException {
        int[] backingStore = SparseIntSet.parseIntArray(string);
        return new MutableSparseIntSet(backingStore);
    }

    @Override
    public MutableSparseIntSet makeCopy(IntSet x) throws IllegalArgumentException {
        if (x == null) {
            throw new IllegalArgumentException("x == null");
        }
        return MutableSparseIntSet.make(x);
    }

    @Override
    public MutableSparseIntSet make() {
        return MutableSparseIntSet.makeEmpty();
    }
}

