/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.wala.util.collections;

import java.util.AbstractMap;
import java.util.AbstractSet;
import java.util.Arrays;
import java.util.Collection;
import java.util.Iterator;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.Set;

public class SmallMap<K, V>
implements Map<K, V> {
    private static final boolean DEBUG_USAGE = false;
    private static final int DEBUG_MAX_SIZE = 20;
    private Object[] keysAndValues;

    @Override
    public int size() {
        if (this.keysAndValues == null) {
            return 0;
        }
        return this.keysAndValues.length / 2;
    }

    public K getKey(int i) throws IllegalStateException {
        if (this.keysAndValues == null) {
            throw new IllegalStateException("getKey on empty map");
        }
        try {
            return (K)this.keysAndValues[i];
        }
        catch (ArrayIndexOutOfBoundsException e) {
            throw new IllegalArgumentException("invalid i: " + i, e);
        }
    }

    public V getValue(int i) throws IllegalStateException {
        if (this.keysAndValues == null) {
            throw new IllegalStateException("getValue on empty map");
        }
        try {
            return (V)this.keysAndValues[this.size() + i];
        }
        catch (ArrayIndexOutOfBoundsException e) {
            throw new IllegalArgumentException("illegal i: " + i, e);
        }
    }

    @Override
    public boolean isEmpty() {
        return this.keysAndValues == null;
    }

    @Override
    public boolean containsKey(Object key) {
        for (int i = 0; i < this.size(); ++i) {
            if (!this.keysAndValues[i].equals(key)) continue;
            return true;
        }
        return false;
    }

    @Override
    public boolean containsValue(Object value) {
        if (this.keysAndValues == null) {
            return false;
        }
        for (int i = this.size(); i < this.keysAndValues.length; ++i) {
            Object v = this.keysAndValues[i];
            if (!(v == null ? value == null : v.equals(value))) continue;
            return true;
        }
        return false;
    }

    @Override
    public V get(Object key) {
        if (key != null) {
            for (int i = 0; i < this.size(); ++i) {
                if (this.keysAndValues[i] == null || !this.keysAndValues[i].equals(key)) continue;
                return (V)this.keysAndValues[this.size() + i];
            }
        }
        return null;
    }

    private void growByOne() {
        if (this.keysAndValues == null) {
            this.keysAndValues = new Object[2];
        } else {
            int oldLength = this.keysAndValues.length;
            int oldEntryCount = oldLength / 2;
            int oldLastKeySlot = oldEntryCount - 1;
            int oldFirstValueSlot = oldLastKeySlot + 1;
            int newLength = oldLength + 2;
            int newEntryCount = newLength / 2;
            int newLastKeySlot = newEntryCount - 1;
            int newFirstValueSlot = newLastKeySlot + 1;
            this.keysAndValues = Arrays.copyOf(this.keysAndValues, newLength);
            System.arraycopy(this.keysAndValues, oldFirstValueSlot, this.keysAndValues, newFirstValueSlot, oldEntryCount);
            this.keysAndValues[newLastKeySlot] = null;
        }
    }

    @Override
    public V put(Object key, Object value) {
        if (key == null) {
            throw new IllegalArgumentException("null key");
        }
        for (int i = 0; i < this.size(); ++i) {
            if (this.keysAndValues[i] == null || !this.keysAndValues[i].equals(key)) continue;
            Object result = this.keysAndValues[this.size() + i];
            this.keysAndValues[this.size() + i] = value;
            return (V)result;
        }
        this.growByOne();
        this.keysAndValues[this.size() - 1] = key;
        this.keysAndValues[this.keysAndValues.length - 1] = value;
        return null;
    }

    @Override
    public V remove(Object key) throws UnsupportedOperationException {
        throw new UnsupportedOperationException();
    }

    @Override
    public void putAll(Map<? extends K, ? extends V> t) throws UnsupportedOperationException {
        throw new UnsupportedOperationException();
    }

    @Override
    public void clear() {
        this.keysAndValues = null;
    }

    @Override
    public Set<K> keySet() {
        return new SlotIteratingSet<K>(){

            @Override
            protected K getItemInSlot(int slot) {
                return SmallMap.this.getKey(slot);
            }
        };
    }

    @Override
    public Collection<V> values() {
        return new SlotIteratingSet<V>(){

            @Override
            protected V getItemInSlot(int slot) {
                return SmallMap.this.getValue(slot);
            }
        };
    }

    @Override
    public Set<Map.Entry<K, V>> entrySet() {
        return new SlotIteratingSet<Map.Entry<K, V>>(){

            @Override
            protected Map.Entry<K, V> getItemInSlot(int slot) {
                return new AbstractMap.SimpleEntry(SmallMap.this.getKey(slot), SmallMap.this.getValue(slot));
            }
        };
    }

    private abstract class SlotIteratingSet<E>
    extends AbstractSet<E> {
        private SlotIteratingSet() {
        }

        @Override
        public Iterator<E> iterator() {
            return new SlotIterator();
        }

        @Override
        public int size() {
            return SmallMap.this.size();
        }

        protected abstract E getItemInSlot(int var1);

        private class SlotIterator
        implements Iterator<E> {
            private int nextSlot = 0;

            private SlotIterator() {
            }

            @Override
            public boolean hasNext() {
                return this.nextSlot < SmallMap.this.size();
            }

            @Override
            public E next() {
                Object result;
                try {
                    result = SlotIteratingSet.this.getItemInSlot(this.nextSlot);
                }
                catch (IllegalArgumentException | IllegalStateException problem) {
                    throw new NoSuchElementException(problem.getMessage());
                }
                ++this.nextSlot;
                return result;
            }
        }
    }
}

