/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.wala.ssa;

import com.ibm.wala.ssa.SSAFieldAccessInstruction;
import com.ibm.wala.ssa.SSAInstruction;
import com.ibm.wala.ssa.SSAInstructionFactory;
import com.ibm.wala.ssa.SymbolTable;
import com.ibm.wala.types.FieldReference;

public abstract class SSAPutInstruction
extends SSAFieldAccessInstruction {
    private final int val;

    protected SSAPutInstruction(int iindex, int ref, int val, FieldReference field) {
        super(iindex, field, ref);
        this.val = val;
    }

    protected SSAPutInstruction(int iindex, int val, FieldReference field) {
        super(iindex, field, -1);
        this.val = val;
    }

    @Override
    public SSAInstruction copyForSSA(SSAInstructionFactory insts, int[] defs, int[] uses) {
        if (this.isStatic()) {
            return insts.PutInstruction(this.iIndex(), uses == null ? this.val : uses[0], this.getDeclaredField());
        }
        return insts.PutInstruction(this.iIndex(), uses == null ? this.getRef() : uses[0], uses == null ? this.val : uses[1], this.getDeclaredField());
    }

    @Override
    public String toString(SymbolTable symbolTable) {
        if (this.isStatic()) {
            return "putstatic " + this.getDeclaredField() + " = " + this.getValueString(symbolTable, this.val);
        }
        return "putfield " + this.getValueString(symbolTable, this.getRef()) + '.' + this.getDeclaredField() + " = " + this.getValueString(symbolTable, this.val);
    }

    @Override
    public void visit(SSAInstruction.IVisitor v) {
        if (v == null) {
            throw new IllegalArgumentException("v is null");
        }
        v.visitPut(this);
    }

    @Override
    public int getNumberOfUses() {
        return this.isStatic() ? 1 : 2;
    }

    @Override
    public int getUse(int j) {
        assert (j == 0 || !this.isStatic() && j == 1);
        return j == 0 && !this.isStatic() ? this.getRef() : this.val;
    }

    public int getVal() {
        return this.val;
    }

    @Override
    public int hashCode() {
        return this.val * 9929 ^ 0x80F;
    }

    @Override
    public boolean isFallThrough() {
        return true;
    }
}

