/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.wala.ssa;

import com.ibm.wala.ssa.SSAInstruction;
import com.ibm.wala.ssa.SSAInstructionFactory;
import com.ibm.wala.ssa.SymbolTable;

public abstract class SSAMonitorInstruction
extends SSAInstruction {
    private final int ref;
    private final boolean isEnter;

    protected SSAMonitorInstruction(int iindex, int ref, boolean isEnter) {
        super(iindex);
        this.ref = ref;
        this.isEnter = isEnter;
    }

    @Override
    public SSAInstruction copyForSSA(SSAInstructionFactory insts, int[] defs, int[] uses) {
        assert (uses == null || uses.length == 1);
        return insts.MonitorInstruction(this.iIndex(), uses == null ? this.ref : uses[0], this.isEnter);
    }

    @Override
    public String toString(SymbolTable symbolTable) {
        return "monitor" + (this.isEnter ? "enter " : "exit ") + this.getValueString(symbolTable, this.ref);
    }

    @Override
    public void visit(SSAInstruction.IVisitor v) {
        if (v == null) {
            throw new IllegalArgumentException("v is null");
        }
        v.visitMonitor(this);
    }

    @Override
    public int getNumberOfUses() {
        return 1;
    }

    @Override
    public int getUse(int j) {
        assert (j == 0);
        return this.ref;
    }

    @Override
    public int hashCode() {
        return this.ref * 6173 + 4423;
    }

    @Override
    public boolean isPEI() {
        return true;
    }

    @Override
    public boolean isFallThrough() {
        return true;
    }

    public int getRef() {
        return this.ref;
    }

    public boolean isMonitorEnter() {
        return this.isEnter;
    }
}

