/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.wala.ssa;

import com.ibm.wala.classLoader.CallSiteReference;
import com.ibm.wala.shrike.shrikeBT.IInvokeInstruction;
import com.ibm.wala.ssa.SSAAbstractInvokeInstruction;
import com.ibm.wala.ssa.SSAInstruction;
import com.ibm.wala.ssa.SSAInstructionFactory;
import com.ibm.wala.types.TypeReference;

public abstract class SSAInvokeInstruction
extends SSAAbstractInvokeInstruction {
    protected final int result;
    protected final int[] params;

    protected SSAInvokeInstruction(int iindex, int result, int[] params, int exception, CallSiteReference site) {
        super(iindex, exception, site);
        this.result = result;
        this.params = params;
        SSAInvokeInstruction.assertParamsKosher(result, params, site);
    }

    protected SSAInvokeInstruction(int iindex, int[] params, int exception, CallSiteReference site) {
        this(iindex, -1, params, exception, site);
    }

    @Override
    public SSAInstruction copyForSSA(SSAInstructionFactory insts, int[] defs, int[] uses) {
        return insts.InvokeInstruction(this.iIndex(), defs == null || this.result == -1 ? this.result : defs[0], uses == null ? this.params : uses, defs == null ? this.exception : defs[this.result == -1 ? 0 : 1], this.site, null);
    }

    public static void assertParamsKosher(int result, int[] params, CallSiteReference site) throws IllegalArgumentException {
        if (site == null) {
            throw new IllegalArgumentException("site cannot be null");
        }
        if (site.getDeclaredTarget().getReturnType().equals(TypeReference.Void) && result != -1) assert (result == -1) : "bogus call to " + site;
        int nExpected = 0;
        if (!site.isStatic()) {
            ++nExpected;
        }
        if ((nExpected += site.getDeclaredTarget().getNumberOfParameters()) > 0) {
            assert (params != null) : "null params for " + site;
            if (params.length != nExpected) assert (params.length == nExpected) : "wrong number of params for " + site + " Expected " + nExpected + " got " + params.length;
        }
    }

    @Override
    public void visit(SSAInstruction.IVisitor v) {
        if (v == null) {
            throw new IllegalArgumentException("v is null");
        }
        v.visitInvoke(this);
    }

    @Override
    public int getNumberOfUses() {
        if (this.params == null) {
            assert (this.site.getInvocationCode() == IInvokeInstruction.Dispatch.STATIC || this.site.getInvocationCode() == IInvokeInstruction.Dispatch.SPECIAL);
            assert (this.site.getDeclaredTarget().getNumberOfParameters() == 0);
            return 0;
        }
        return this.params.length;
    }

    @Override
    public int getNumberOfPositionalParameters() {
        return this.getNumberOfUses();
    }

    @Override
    public int getNumberOfReturnValues() {
        return this.result == -1 ? 0 : 1;
    }

    @Override
    public int getReturnValue(int i) {
        assert (i == 0) : "i != 0";
        assert (this.result != -1) : "SSA-Result is -1";
        return this.result;
    }

    @Override
    public int getUse(int j) {
        if (this.params == null) assert (false) : "Invalid getUse: " + j + " , null params " + this;
        if (j >= this.params.length) {
            throw new ArrayIndexOutOfBoundsException("Invalid getUse: " + this + ", index " + j + ", params.length " + this.params.length);
        }
        if (j < 0) {
            throw new ArrayIndexOutOfBoundsException("j may not be negative! In getUse " + this + ", index " + j + ", params.length " + this.params.length);
        }
        return this.params[j];
    }

    @Override
    public int hashCode() {
        return this.site.hashCode() * 7529 + this.exception * 9823;
    }
}

