/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.wala.shrike.shrikeCT;

import com.ibm.wala.shrike.shrikeBT.analysis.Analyzer;
import com.ibm.wala.shrike.shrikeCT.ClassReader;
import com.ibm.wala.shrike.shrikeCT.ClassWriter;
import com.ibm.wala.shrike.shrikeCT.InvalidClassFileException;
import com.ibm.wala.shrike.shrikeCT.StackMapTableWriter;
import java.io.IOException;
import java.io.OutputStream;

public class StackMapConstants {
    public static Item[] items = new Item[]{Item.ITEM_Top, Item.ITEM_Integer, Item.ITEM_Float, Item.ITEM_Double, Item.ITEM_Long, Item.ITEM_Null, Item.ITEM_UninitializedThis, Item.ITEM_Object, Item.ITEM_Uninitalized};

    public static class StackMapFrame {
        private final int frameType;
        private final int offset;
        private final StackMapType[] localTypes;
        private final StackMapType[] stackTypes;

        public StackMapFrame(StackMapFrame frame, int newOffset) {
            this(frame.frameType, newOffset, frame.localTypes, frame.stackTypes);
        }

        public StackMapFrame(int frameType, int offset, StackMapType[] localTypes, StackMapType[] stackTypes) {
            this.frameType = frameType;
            this.offset = offset;
            this.localTypes = localTypes;
            this.stackTypes = stackTypes;
        }

        public int getFrameType() {
            return this.frameType;
        }

        public int getOffset() {
            return this.offset;
        }

        public StackMapType[] getLocalTypes() {
            return this.localTypes;
        }

        public StackMapType[] getStackTypes() {
            return this.stackTypes;
        }

        public String toString() {
            StringBuilder sb = new StringBuilder();
            sb.append("frame type: ").append(this.frameType).append('\n');
            sb.append("  offset: ").append(this.offset).append('\n');
            sb.append("  locals\n");
            for (StackMapType localType : this.localTypes) {
                sb.append("  ").append(localType).append('\n');
            }
            sb.append("  stack\n");
            for (StackMapType stackType : this.stackTypes) {
                sb.append("  ").append(stackType).append('\n');
            }
            return sb.toString();
        }

        public void write(OutputStream out, ClassWriter writer) throws IOException {
            StackMapTableWriter.writeUByte(out, this.frameType);
            StackMapTableWriter.writeUShort(out, this.offset);
            if (this.localTypes != null) {
                StackMapTableWriter.writeUShort(out, this.localTypes.length);
                for (StackMapType type : this.localTypes) {
                    type.write(out, writer);
                }
            } else {
                StackMapTableWriter.writeUShort(out, 0);
            }
            if (this.stackTypes != null) {
                StackMapTableWriter.writeUShort(out, this.stackTypes.length);
                int j = this.stackTypes.length;
                while (j > 0) {
                    this.stackTypes[--j].write(out, writer);
                }
            } else {
                StackMapTableWriter.writeUShort(out, 0);
            }
        }
    }

    public static class ObjectType
    implements StackMapType {
        private final String type;

        ObjectType(ClassReader cr, int typeIndex) throws IllegalArgumentException, InvalidClassFileException {
            this(cr.getCP().getCPString(typeIndex));
        }

        ObjectType(String type) {
            this.type = type;
        }

        @Override
        public int size() {
            return Item.ITEM_Object.size();
        }

        @Override
        public boolean isObject() {
            return true;
        }

        public String toString() {
            return "obj:" + this.type;
        }

        @Override
        public void write(OutputStream s, ClassWriter writer) throws IOException {
            Item.ITEM_Object.write(s, writer);
            if ("L;".equals(this.type)) {
                StackMapTableWriter.writeUShort(s, writer.addCPClass("java/lang/Object"));
            } else if (this.type.startsWith("L")) {
                StackMapTableWriter.writeUShort(s, writer.addCPClass(this.type.substring(1, this.type.length() - 1)));
            } else {
                StackMapTableWriter.writeUShort(s, writer.addCPClass(this.type));
            }
        }
    }

    public static class UninitializedType
    implements StackMapType {
        private final String type;
        private final int offset;

        public UninitializedType(String type) {
            assert (type.startsWith("#"));
            this.type = Analyzer.stripSharp(type);
            this.offset = Integer.parseInt(type.substring(1, type.lastIndexOf(35)));
        }

        @Override
        public void write(OutputStream s, ClassWriter writer) throws IOException {
            Item.ITEM_Uninitalized.write(s, writer);
            StackMapTableWriter.writeUShort(s, this.offset);
        }

        @Override
        public int size() {
            return Item.ITEM_Uninitalized.size();
        }

        @Override
        public boolean isObject() {
            return true;
        }

        public String toString() {
            return "uninit:" + this.type;
        }
    }

    public static enum Item implements StackMapType
    {
        ITEM_Top(0),
        ITEM_Integer(1),
        ITEM_Float(2),
        ITEM_Double(3){

            @Override
            public int size() {
                return 2;
            }
        }
        ,
        ITEM_Long(4){

            @Override
            public int size() {
                return 2;
            }
        }
        ,
        ITEM_Null(5),
        ITEM_UninitializedThis(6),
        ITEM_Object(7){

            @Override
            public boolean isObject() {
                return true;
            }
        }
        ,
        ITEM_Uninitalized(8){

            @Override
            public boolean isObject() {
                return true;
            }
        };

        private final byte code;

        private Item(int code) {
            this.code = (byte)code;
        }

        @Override
        public boolean isObject() {
            return false;
        }

        @Override
        public int size() {
            return 1;
        }

        @Override
        public void write(OutputStream s, ClassWriter writer) throws IOException {
            StackMapTableWriter.writeUByte(s, this.code);
        }
    }

    static interface StackMapType {
        public void write(OutputStream var1, ClassWriter var2) throws IOException;

        public int size();

        public boolean isObject();
    }
}

