/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.wala.shrike.shrikeCT;

import com.ibm.wala.shrike.shrikeCT.AttributeReader;
import com.ibm.wala.shrike.shrikeCT.ClassReader;
import com.ibm.wala.shrike.shrikeCT.CodeReader;
import com.ibm.wala.shrike.shrikeCT.InvalidClassFileException;
import java.util.Arrays;

public final class LocalVariableTableReader
extends AttributeReader {
    public LocalVariableTableReader(ClassReader.AttrIterator iter) throws InvalidClassFileException {
        super(iter, "LocalVariableTable");
        int offset = this.attr + 6;
        this.checkSize(offset, 2);
        int count = this.cr.getUShort(offset);
        this.checkSize(offset += 2, count * 10);
    }

    public int[] getRawTable() {
        int count = this.cr.getUShort(this.attr + 6);
        int[] r = new int[count * 5];
        int offset = this.attr + 8;
        for (int i = 0; i < r.length; ++i) {
            r[i] = this.cr.getUShort(offset);
            offset += 2;
        }
        return r;
    }

    private static int[] makeVarVector(int[] curVector, int varIndex, int nameIndex, int typeIndex) {
        int[] newVector = curVector == null ? new int[(varIndex + 1) * 2] : Arrays.copyOf(curVector, Math.max(curVector.length, (varIndex + 1) * 2));
        newVector[varIndex * 2] = nameIndex;
        newVector[varIndex * 2 + 1] = typeIndex;
        return newVector;
    }

    public static int[][] makeVarMap(CodeReader code) throws InvalidClassFileException, IllegalArgumentException {
        if (code == null) {
            throw new IllegalArgumentException();
        }
        Object r = null;
        ClassReader cr = code.getClassReader();
        ClassReader.AttrIterator iter = new ClassReader.AttrIterator();
        code.initAttributeIterator(iter);
        while (iter.isValid()) {
            if (iter.getName().equals("LocalVariableTable")) {
                if (r == null) {
                    r = new int[code.getBytecodeLength()][];
                }
                LocalVariableTableReader localVariableTableReader = new LocalVariableTableReader(iter);
                int attr = iter.getRawOffset();
                int count = cr.getUShort(attr + 6);
                int offset = attr + 8;
                for (int j = 0; j < count; ++j) {
                    int startPC = cr.getUShort(offset);
                    int length = cr.getUShort(offset + 2);
                    int nameIndex = cr.getUShort(offset + 4);
                    int typeIndex = cr.getUShort(offset + 6);
                    int varIndex = cr.getUShort(offset + 8);
                    offset += 10;
                    if (varIndex < 0) {
                        throw new InvalidClassFileException(offset, "Invalid variable index " + varIndex + " in LocalVariableTable");
                    }
                    if (startPC < 0) {
                        throw new InvalidClassFileException(offset, "Invalid startPC " + startPC + " in LocalVariableTable");
                    }
                    if (startPC + length > ((int[][])r).length) {
                        throw new InvalidClassFileException(offset, "Invalid startPC+length " + (startPC + length) + " > " + ((int[][])r).length + " in LocalVariableTable");
                    }
                    for (int k = startPC; k < startPC + length; ++k) {
                        int[] newVector = LocalVariableTableReader.makeVarVector(r[k], varIndex, nameIndex, typeIndex);
                        r[k] = newVector;
                    }
                }
            }
            iter.advance();
        }
        return r;
    }
}

