/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.wala.shrike.shrikeCT;

import com.ibm.wala.shrike.shrikeCT.AttributeReader;
import com.ibm.wala.shrike.shrikeCT.ClassReader;
import com.ibm.wala.shrike.shrikeCT.ConstantPoolParser;
import com.ibm.wala.shrike.shrikeCT.InvalidClassFileException;
import java.lang.invoke.MethodHandles;
import java.lang.invoke.MethodType;
import java.lang.reflect.Method;

public class BootstrapMethodsReader
extends AttributeReader {
    private BootstrapMethod[] entries;

    protected BootstrapMethodsReader(ClassReader.AttrIterator attr) throws InvalidClassFileException {
        super(attr, "BootstrapMethods");
        this.readBootstrapEntries();
    }

    private void readBootstrapEntries() throws InvalidClassFileException {
        final ConstantPoolParser cp = this.cr.getCP();
        this.entries = new BootstrapMethod[this.cr.getUShort(this.attr + 6)];
        int base = 8;
        for (int i = 0; i < this.entries.length; ++i) {
            final int methodHandleOffset = this.cr.getUShort(this.attr + base);
            final int argsBase = this.attr + base + 4;
            final int index = i;
            final int argumentCount = this.cr.getUShort(this.attr + base + 2);
            this.entries[i] = new BootstrapMethod(){
                private final byte invokeType;
                private final String methodClass;
                private final String methodName;
                private final String methodType;
                {
                    this.invokeType = cp.getCPHandleKind(methodHandleOffset);
                    this.methodClass = cp.getCPHandleClass(methodHandleOffset);
                    this.methodName = cp.getCPHandleName(methodHandleOffset);
                    this.methodType = cp.getCPHandleType(methodHandleOffset);
                }

                public String toString() {
                    return this.methodClass + ':' + this.methodName + this.methodType;
                }

                @Override
                public byte invokeType() {
                    return this.invokeType;
                }

                @Override
                public String methodClass() {
                    return this.methodClass;
                }

                @Override
                public String methodName() {
                    return this.methodName;
                }

                @Override
                public String methodType() {
                    return this.methodType;
                }

                @Override
                public int callArgumentCount() {
                    return argumentCount;
                }

                @Override
                public int callArgumentKind(int i) {
                    return cp.getItemType(this.callArgumentIndex(i));
                }

                @Override
                public int callArgumentIndex(int i) {
                    assert (0 <= i && i < argumentCount);
                    int index2 = argsBase + 2 * i;
                    return BootstrapMethodsReader.this.cr.getUShort(index2);
                }

                @Override
                public Object callArgument(ClassLoader cl, int i) {
                    try {
                        int index2 = this.callArgumentIndex(i);
                        int t = this.callArgumentKind(i);
                        switch (t) {
                            case 1: {
                                return cp.getCPUtf8(index2);
                            }
                            case 7: {
                                return cp.getCPClass(index2);
                            }
                            case 8: {
                                return cp.getCPString(index2);
                            }
                            case 3: {
                                return cp.getCPInt(index2);
                            }
                            case 4: {
                                return Float.valueOf(cp.getCPFloat(index2));
                            }
                            case 6: {
                                return cp.getCPDouble(index2);
                            }
                            case 5: {
                                return cp.getCPLong(index2);
                            }
                            case 15: {
                                String className = cp.getCPHandleClass(index2);
                                String eltName = cp.getCPHandleName(index2);
                                String eltDesc = cp.getCPHandleType(index2);
                                MethodType type = MethodType.fromMethodDescriptorString(eltDesc, cl);
                                Class<?> cls = Class.forName(className.replace('/', '.'), false, cl);
                                Method m = cls.getDeclaredMethod(eltName, type.parameterList().toArray(new Class[type.parameterCount()]));
                                MethodHandles.Lookup lk = MethodHandles.lookup().in(cls);
                                m.setAccessible(true);
                                return lk.unreflect(m);
                            }
                            case 16: {
                                return MethodType.fromMethodDescriptorString(cp.getCPMethodType(index2), cl);
                            }
                        }
                        assert (false) : "invalid type " + t;
                    }
                    catch (InvalidClassFileException | ClassNotFoundException | IllegalAccessException | IllegalArgumentException | NoSuchMethodException | SecurityException e) {
                        throw new RuntimeException(e);
                    }
                    return null;
                }

                @Override
                public ConstantPoolParser getCP() {
                    return cp;
                }

                @Override
                public int getIndexInClassFile() {
                    return index;
                }
            };
            base += argumentCount * 2 + 4;
        }
    }

    public int count() {
        return this.entries.length;
    }

    public BootstrapMethod getEntry(int i) {
        return this.entries[i];
    }

    public static interface BootstrapMethod {
        public static final String LAMBDA_METAFACTORY_CLASS = "java/lang/invoke/LambdaMetafactory";
        public static final String BOOTSTRAP_METHOD_NAME = "metafactory";
        public static final String BOOTSTRAP_METHOD_TYPE = "(Ljava/lang/invoke/MethodHandles$Lookup;Ljava/lang/String;Ljava/lang/invoke/MethodType;Ljava/lang/invoke/MethodType;Ljava/lang/invoke/MethodHandle;Ljava/lang/invoke/MethodType;)Ljava/lang/invoke/CallSite;";

        public byte invokeType();

        public String methodClass();

        public String methodName();

        public String methodType();

        public int callArgumentCount();

        public Object callArgument(ClassLoader var1, int var2);

        public int callArgumentIndex(int var1);

        public int callArgumentKind(int var1);

        public ConstantPoolParser getCP();

        public int getIndexInClassFile();

        default public boolean isBootstrapForJavaLambdas() {
            return this.methodClass().equals(LAMBDA_METAFACTORY_CLASS) && this.methodName().equals(BOOTSTRAP_METHOD_NAME) && this.methodType().equals(BOOTSTRAP_METHOD_TYPE);
        }
    }
}

