/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.wala.shrike.shrikeBT;

import com.ibm.wala.shrike.shrikeBT.IConversionInstruction;
import com.ibm.wala.shrike.shrikeBT.IInstruction;
import com.ibm.wala.shrike.shrikeBT.Instruction;
import com.ibm.wala.shrike.shrikeBT.Util;

public final class ConversionInstruction
extends Instruction
implements IConversionInstruction {
    private final String fromType;
    private final String toType;
    private static final ConversionInstruction[] preallocated = ConversionInstruction.preallocate();

    private ConversionInstruction(short opcode) {
        super(opcode);
        if (opcode < 145) {
            int k = opcode - 133;
            this.toType = indexedTypes[ConversionInstruction.skip(k % 3, k / 3)];
        } else {
            this.toType = indexedTypes[opcode - 145 + 5];
        }
        this.fromType = opcode < 145 ? indexedTypes[(opcode - 133) / 3] : "I";
    }

    private static ConversionInstruction[] preallocate() {
        ConversionInstruction[] r = new ConversionInstruction[15];
        for (short i = 133; i <= 147; i = (short)(i + 1)) {
            r[i - 133] = new ConversionInstruction(i);
        }
        return r;
    }

    public static ConversionInstruction make(String fromType, String toType) throws IllegalArgumentException {
        int from = Util.getTypeIndex(fromType);
        int to = Util.getTypeIndex(toType);
        if (from < 0 || from > 3) {
            throw new IllegalArgumentException("Cannot convert from type " + fromType);
        }
        if (from == 0 && to >= 5 && to <= 7) {
            return preallocated[12 + (to - 5)];
        }
        if (to < 0 || to > 3) {
            throw new IllegalArgumentException("Cannot convert from type " + fromType + " to type " + toType);
        }
        if (to == from) {
            throw new IllegalArgumentException("Cannot convert from type " + fromType + " to same type");
        }
        return preallocated[from * 3 + (to > from ? to - 1 : to)];
    }

    @Override
    public int getPoppedCount() {
        return 1;
    }

    @Override
    public String getFromType() {
        return this.fromType;
    }

    private static int skip(int a, int b) {
        return a < b ? a : a + 1;
    }

    @Override
    public String getToType() {
        return this.toType;
    }

    @Override
    public String getPushedType(String[] types) {
        return this.getToType();
    }

    @Override
    public byte getPushedWordSize() {
        return Util.getWordSize(this.getToType());
    }

    public boolean equals(Object o) {
        if (o instanceof ConversionInstruction) {
            ConversionInstruction i = (ConversionInstruction)o;
            return i.opcode == this.opcode;
        }
        return false;
    }

    public int hashCode() {
        return this.opcode * 143111;
    }

    @Override
    public String toString() {
        return "Conversion(" + this.getFromType() + ',' + this.getToType() + ')';
    }

    @Override
    public void visit(IInstruction.Visitor v) throws NullPointerException {
        v.visitConversion(this);
    }

    @Override
    public boolean isPEI() {
        return false;
    }

    @Override
    public boolean throwsExceptionOnOverflow() {
        return false;
    }
}

