/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.wala.shrike.shrikeBT;

import com.ibm.wala.shrike.shrikeBT.IBinaryOpInstruction;
import com.ibm.wala.shrike.shrikeBT.IInstruction;
import com.ibm.wala.shrike.shrikeBT.Instruction;
import com.ibm.wala.shrike.shrikeBT.Util;

public final class BinaryOpInstruction
extends Instruction
implements IBinaryOpInstruction {
    private static final BinaryOpInstruction[] arithmeticOps = BinaryOpInstruction.preallocateArithmeticOps();
    private static final BinaryOpInstruction[] logicalOps = BinaryOpInstruction.preallocateLogicalOps();

    private BinaryOpInstruction(short opcode) {
        super(opcode);
    }

    private static BinaryOpInstruction[] preallocateArithmeticOps() {
        BinaryOpInstruction[] r = new BinaryOpInstruction[20];
        for (short i = 96; i <= 115; i = (short)(i + 1)) {
            r[i - 96] = new BinaryOpInstruction(i);
        }
        return r;
    }

    private static BinaryOpInstruction[] preallocateLogicalOps() {
        BinaryOpInstruction[] r = new BinaryOpInstruction[6];
        for (short i = 126; i <= 131; i = (short)(i + 1)) {
            r[i - 126] = new BinaryOpInstruction(i);
        }
        return r;
    }

    public static BinaryOpInstruction make(String type, IBinaryOpInstruction.Operator operator) throws IllegalArgumentException {
        if (operator == null) {
            throw new IllegalArgumentException("operator is null");
        }
        int t = Util.getTypeIndex(type);
        if (t < 0) {
            throw new IllegalArgumentException("Invalid type for BinaryOp: " + type);
        }
        if (operator.compareTo(IBinaryOpInstruction.Operator.REM) <= 0) {
            if (t > 3) {
                throw new IllegalArgumentException("Invalid type for BinaryOp: " + type);
            }
            return arithmeticOps[(operator.ordinal() - IBinaryOpInstruction.Operator.ADD.ordinal()) * 4 + t];
        }
        if (t > 1) {
            throw new IllegalArgumentException("Cannot use logical binaryOps on floating point type: " + type);
        }
        return logicalOps[(operator.ordinal() - IBinaryOpInstruction.Operator.AND.ordinal()) * 2 + t];
    }

    public boolean equals(Object o) {
        if (o instanceof BinaryOpInstruction) {
            BinaryOpInstruction i = (BinaryOpInstruction)o;
            return i.opcode == this.opcode;
        }
        return false;
    }

    @Override
    public IBinaryOpInstruction.Operator getOperator() {
        if (this.opcode < 126) {
            return IBinaryOpInstruction.Operator.values()[(this.opcode - 96) / 4];
        }
        return IBinaryOpInstruction.Operator.values()[5 + (this.opcode - 126) / 2];
    }

    public int hashCode() {
        return this.opcode + 13901901;
    }

    @Override
    public int getPoppedCount() {
        return 2;
    }

    @Override
    public String getPushedType(String[] types) {
        return this.getType();
    }

    @Override
    public byte getPushedWordSize() {
        return Util.getWordSize(this.getType());
    }

    @Override
    public String getType() {
        int t = this.opcode < 126 ? this.opcode - 96 & 3 : this.opcode - 126 & 1;
        return indexedTypes[t];
    }

    @Override
    public void visit(IInstruction.Visitor v) throws NullPointerException {
        v.visitBinaryOp(this);
    }

    @Override
    public String toString() {
        return "BinaryOp(" + this.getType() + ',' + this.getOperator() + ')';
    }

    @Override
    public boolean isPEI() {
        return this.opcode == 108 || this.opcode == 109 || this.opcode == 112 || this.opcode == 113;
    }

    @Override
    public boolean throwsExceptionOnOverflow() {
        return false;
    }

    @Override
    public boolean isUnsigned() {
        return false;
    }
}

