/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.wala.ipa.slicer;

import com.ibm.wala.ipa.callgraph.propagation.AbstractFieldPointerKey;
import com.ibm.wala.ipa.callgraph.propagation.PointerKey;
import com.ibm.wala.ipa.callgraph.propagation.StaticFieldKey;
import com.ibm.wala.types.TypeReference;
import com.ibm.wala.util.collections.HashSetFactory;
import com.ibm.wala.util.config.SetOfClasses;
import com.ibm.wala.util.debug.Assertions;
import java.util.Collection;
import java.util.HashSet;
import java.util.Set;

public class HeapExclusions {
    private static final boolean VERBOSE = false;
    private static final Collection<TypeReference> considered = HashSetFactory.make();
    private final SetOfClasses set;

    public HeapExclusions(SetOfClasses set) {
        this.set = set;
    }

    public Set<PointerKey> filter(Collection<PointerKey> s) {
        if (s == null) {
            throw new IllegalArgumentException("s is null");
        }
        HashSet<PointerKey> result = HashSetFactory.make();
        for (PointerKey p : s) {
            if (p instanceof AbstractFieldPointerKey) {
                AbstractFieldPointerKey f = (AbstractFieldPointerKey)p;
                if (f.getInstanceKey().getConcreteType() == null || this.set.contains(f.getInstanceKey().getConcreteType().getReference().getName().toString().substring(1))) continue;
                result.add(p);
                continue;
            }
            if (p instanceof StaticFieldKey) {
                StaticFieldKey sf = (StaticFieldKey)p;
                if (this.set.contains(sf.getField().getDeclaringClass().getReference().getName().toString().substring(1))) continue;
                result.add(p);
                continue;
            }
            Assertions.UNREACHABLE(s.getClass().toString());
        }
        return result;
    }

    private static void verboseAction(PointerKey p) {
        StaticFieldKey sf;
        TypeReference t;
        if (p instanceof AbstractFieldPointerKey) {
            TypeReference t2;
            AbstractFieldPointerKey f = (AbstractFieldPointerKey)p;
            if (f.getInstanceKey().getConcreteType() != null && !considered.contains(t2 = f.getInstanceKey().getConcreteType().getReference())) {
                considered.add(t2);
                System.err.println("Considered " + t2);
            }
        } else if (p instanceof StaticFieldKey && !considered.contains(t = (sf = (StaticFieldKey)p).getField().getDeclaringClass().getReference())) {
            considered.add(t);
            System.err.println("Considered " + t);
        }
    }

    public boolean excludes(PointerKey pk) {
        TypeReference t = HeapExclusions.getType(pk);
        return t == null ? false : this.set.contains(t.getName().toString().substring(1));
    }

    public static TypeReference getType(PointerKey pk) {
        if (pk instanceof AbstractFieldPointerKey) {
            AbstractFieldPointerKey f = (AbstractFieldPointerKey)pk;
            if (f.getInstanceKey().getConcreteType() != null) {
                return f.getInstanceKey().getConcreteType().getReference();
            }
        } else if (pk instanceof StaticFieldKey) {
            StaticFieldKey sf = (StaticFieldKey)pk;
            return sf.getField().getDeclaringClass().getReference();
        }
        return null;
    }
}

