/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.wala.ipa.cfg.exceptionpruning.filter;

import com.ibm.wala.analysis.arraybounds.ArrayOutOfBoundsAnalysis;
import com.ibm.wala.ipa.cfg.exceptionpruning.ExceptionFilter;
import com.ibm.wala.ipa.cfg.exceptionpruning.FilteredException;
import com.ibm.wala.ssa.SSAInstruction;
import com.ibm.wala.types.TypeReference;
import java.util.Collection;
import java.util.Collections;

public class ArrayOutOfBoundFilter
implements ExceptionFilter<SSAInstruction> {
    private final ArrayOutOfBoundsAnalysis analysis;

    public ArrayOutOfBoundFilter(ArrayOutOfBoundsAnalysis analysis) {
        this.analysis = analysis;
    }

    @Override
    public boolean alwaysThrowsException(SSAInstruction instruction) {
        return false;
    }

    @Override
    public Collection<FilteredException> filteredExceptions(SSAInstruction instruction) {
        ArrayOutOfBoundsAnalysis.UnnecessaryCheck unnecessary = this.analysis.getBoundsCheckNecessary().get(instruction);
        if (unnecessary == ArrayOutOfBoundsAnalysis.UnnecessaryCheck.BOTH) {
            return Collections.singletonList(new FilteredException(TypeReference.JavaLangArrayIndexOutOfBoundsException));
        }
        return Collections.emptyList();
    }
}

