/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.wala.ipa.cfg.exceptionpruning;

import com.ibm.wala.classLoader.IClass;
import com.ibm.wala.ipa.cfg.exceptionpruning.FilteredException;
import com.ibm.wala.ipa.cha.ClassHierarchy;
import com.ibm.wala.types.TypeReference;
import java.util.Collection;
import java.util.LinkedHashSet;
import java.util.Set;

public class ExceptionMatcher {
    private Set<TypeReference> ignoreExact = new LinkedHashSet<TypeReference>();
    private Set<TypeReference> ignoreSubclass = new LinkedHashSet<TypeReference>();
    private final Set<TypeReference> retainedExceptions;
    private ClassHierarchy cha;
    private final boolean areAllExceptionsIgnored;

    public static boolean isFiltered(Collection<TypeReference> thrownExceptions, Collection<FilteredException> filteredExceptions, ClassHierarchy cha) {
        ExceptionMatcher matcher = new ExceptionMatcher(thrownExceptions, filteredExceptions, cha);
        return matcher.areAllExceptionsIgnored();
    }

    public static Set<TypeReference> retainedExceptions(Collection<TypeReference> thrownExceptions, Collection<FilteredException> filteredExceptions, ClassHierarchy cha) {
        ExceptionMatcher matcher = new ExceptionMatcher(thrownExceptions, filteredExceptions, cha);
        return matcher.getRetainedExceptions();
    }

    private ExceptionMatcher(Collection<TypeReference> thrownExceptions, Collection<FilteredException> filteredExceptions, ClassHierarchy cha) {
        this.cha = cha;
        this.retainedExceptions = new LinkedHashSet<TypeReference>();
        this.fillIgnore(filteredExceptions);
        this.computeRetainedExceptions(thrownExceptions);
        this.areAllExceptionsIgnored = this.retainedExceptions.isEmpty();
        this.free();
    }

    private void computeRetainedExceptions(Collection<TypeReference> thrownExceptions) {
        for (TypeReference exception : thrownExceptions) {
            if (this.isFiltered(exception)) continue;
            this.retainedExceptions.add(exception);
        }
    }

    private boolean areAllExceptionsIgnored() {
        return this.areAllExceptionsIgnored;
    }

    private void fillIgnore(Collection<FilteredException> filteredExceptions) {
        for (FilteredException filteredException : filteredExceptions) {
            TypeReference exception = filteredException.getException();
            this.ignoreExact.add(exception);
            if (!filteredException.isSubclassFiltered()) continue;
            this.ignoreSubclass.add(exception);
        }
    }

    private void free() {
        this.ignoreExact = null;
        this.ignoreSubclass = null;
        this.cha = null;
    }

    private boolean isFiltered(TypeReference exception) {
        boolean isFiltered = false;
        if (this.ignoreExact.contains(exception)) {
            isFiltered = true;
        } else {
            for (TypeReference ignoreException : this.ignoreSubclass) {
                IClass exceptionClass = this.cha.lookupClass(exception);
                IClass ignoreClass = this.cha.lookupClass(ignoreException);
                if (!this.cha.isAssignableFrom(ignoreClass, exceptionClass)) continue;
                isFiltered = true;
                break;
            }
        }
        return isFiltered;
    }

    public Set<TypeReference> getRetainedExceptions() {
        return this.retainedExceptions;
    }
}

