/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.wala.ipa.cfg;

import com.ibm.wala.cfg.ControlFlowGraph;
import com.ibm.wala.cfg.IBasicBlock;
import com.ibm.wala.classLoader.CallSiteReference;
import com.ibm.wala.ipa.callgraph.CGNode;
import com.ibm.wala.ipa.callgraph.CallGraph;
import com.ibm.wala.ipa.cfg.BasicBlockInContext;
import com.ibm.wala.ssa.ISSABasicBlock;
import com.ibm.wala.ssa.SSAAbstractInvokeInstruction;
import com.ibm.wala.ssa.SSAInstruction;
import com.ibm.wala.util.collections.FilterIterator;
import com.ibm.wala.util.collections.IndiscriminateFilter;
import com.ibm.wala.util.collections.Iterator2Iterable;
import com.ibm.wala.util.collections.MapIterator;
import com.ibm.wala.util.debug.Assertions;
import com.ibm.wala.util.debug.UnimplementedError;
import com.ibm.wala.util.graph.NumberedGraph;
import com.ibm.wala.util.graph.impl.SlowSparseNumberedGraph;
import com.ibm.wala.util.intset.BitVector;
import com.ibm.wala.util.intset.BitVectorIntSet;
import com.ibm.wala.util.intset.IntSet;
import com.ibm.wala.util.intset.MutableIntSet;
import java.util.Iterator;
import java.util.Set;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.stream.Stream;

public abstract class AbstractInterproceduralCFG<T extends ISSABasicBlock>
implements NumberedGraph<BasicBlockInContext<T>> {
    private static final int DEBUG_LEVEL = 0;
    private static final boolean WARN_ON_EAGER_CONSTRUCTION = false;
    private static final boolean FAIL_ON_EAGER_CONSTRUCTION = false;
    private static final boolean CALL_TO_RETURN_EDGES = true;
    private final NumberedGraph<BasicBlockInContext<T>> g = new SlowSparseNumberedGraph<BasicBlockInContext<T>>(2){
        private static final long serialVersionUID = 1L;

        @Override
        protected String nodeString(BasicBlockInContext<T> n, boolean forEdge) {
            if (forEdge) {
                return n.toString();
            }
            StringBuilder sb = new StringBuilder(n.toString());
            n.iterator().forEachRemaining(inst -> sb.append("\n").append(inst.toString()));
            return sb.toString();
        }
    };
    private final CallGraph cg;
    private final Predicate<CGNode> relevant;
    private final BitVector hasCallVector = new BitVector();
    private MutableIntSet cgNodesVisited = new BitVectorIntSet();
    private MutableIntSet cgNodesWithCallerEdges = new BitVectorIntSet();
    private MutableIntSet handledCalls = new BitVectorIntSet();
    private MutableIntSet handledReturns = new BitVectorIntSet();
    private MutableIntSet addedSuccs = new BitVectorIntSet();
    private MutableIntSet addedPreds = new BitVectorIntSet();
    private boolean constructedFullGraph = false;
    private final Predicate<BasicBlockInContext<T>> isCall = this::hasCall;

    public void callGraphUpdated() {
        this.cgNodesVisited = new BitVectorIntSet();
        this.cgNodesWithCallerEdges = new BitVectorIntSet();
        this.handledCalls = new BitVectorIntSet();
        this.handledReturns = new BitVectorIntSet();
        this.addedSuccs = new BitVectorIntSet();
        this.addedPreds = new BitVectorIntSet();
    }

    public abstract ControlFlowGraph<SSAInstruction, T> getCFG(CGNode var1);

    public AbstractInterproceduralCFG(CallGraph cg) {
        this(cg, IndiscriminateFilter.singleton());
    }

    public AbstractInterproceduralCFG(CallGraph CG, Predicate<CGNode> relevant) {
        this.cg = CG;
        this.relevant = relevant;
    }

    private void addIntraproceduralNodesAndEdgesForCGNodeIfNeeded(CGNode n) {
        if (!this.cgNodesVisited.contains(this.cg.getNumber(n)) && this.relevant.test(n)) {
            this.cgNodesVisited.add(this.cg.getNumber(n));
            ControlFlowGraph<SSAInstruction, T> cfg = this.getCFG(n);
            if (cfg != null) {
                this.addNodeForEachBasicBlock(cfg, n);
                SSAInstruction[] instrs = cfg.getInstructions();
                for (ISSABasicBlock bb : cfg) {
                    if (bb == cfg.entry()) continue;
                    this.addEdgesToNonEntryBlock(n, cfg, instrs, bb);
                }
            }
        }
    }

    protected void addEdgesToNonEntryBlock(CGNode n, ControlFlowGraph<?, T> cfg, SSAInstruction[] instrs, T bb) {
        for (ISSABasicBlock pb : Iterator2Iterable.make(cfg.getPredNodes(bb))) {
            BasicBlockInContext<T> b;
            BasicBlockInContext<ISSABasicBlock> p;
            if (pb.equals(cfg.entry())) {
                BasicBlockInContext<ISSABasicBlock> p2 = new BasicBlockInContext<ISSABasicBlock>(n, pb);
                BasicBlockInContext<T> b2 = new BasicBlockInContext<T>(n, bb);
                this.g.addEdge(p2, b2);
                continue;
            }
            SSAInstruction inst = this.getLastInstructionForBlock(pb, instrs);
            if (inst instanceof SSAAbstractInvokeInstruction) {
                p = new BasicBlockInContext<ISSABasicBlock>(n, pb);
                b = new BasicBlockInContext<T>(n, bb);
                this.g.addEdge(p, b);
                continue;
            }
            p = new BasicBlockInContext<ISSABasicBlock>(n, pb);
            b = new BasicBlockInContext<T>(n, bb);
            if (!this.g.containsNode(p) || !this.g.containsNode(b)) {
                assert (this.g.containsNode(p)) : "IPCFG does not contain " + p;
                assert (this.g.containsNode(b)) : "IPCFG does not contain " + b;
            }
            this.g.addEdge(p, b);
        }
    }

    protected SSAInstruction getLastInstructionForBlock(T pb, SSAInstruction[] instrs) {
        int index = pb.getLastInstructionIndex();
        SSAInstruction inst = instrs[index];
        return inst;
    }

    private void addEdgesFromExitToReturn(CGNode caller, T returnBlock, CGNode target, ControlFlowGraph<SSAInstruction, ? extends T> targetCFG) {
        ISSABasicBlock texit = (ISSABasicBlock)targetCFG.exit();
        BasicBlockInContext<ISSABasicBlock> exit = new BasicBlockInContext<ISSABasicBlock>(target, texit);
        this.addNodeForBasicBlockIfNeeded(exit);
        BasicBlockInContext<T> ret = new BasicBlockInContext<T>(caller, returnBlock);
        if (!this.g.containsNode(exit) || !this.g.containsNode(ret)) {
            assert (this.g.containsNode(exit)) : "IPCFG does not contain " + exit;
            assert (this.g.containsNode(ret)) : "IPCFG does not contain " + ret;
        }
        this.g.addEdge(exit, ret);
    }

    private void addEdgesFromCallToEntry(CGNode caller, T callBlock, CGNode target, ControlFlowGraph<SSAInstruction, ? extends T> targetCFG) {
        ISSABasicBlock tentry = (ISSABasicBlock)targetCFG.entry();
        BasicBlockInContext<ISSABasicBlock> entry = new BasicBlockInContext<ISSABasicBlock>(target, tentry);
        this.addNodeForBasicBlockIfNeeded(entry);
        BasicBlockInContext<T> call = new BasicBlockInContext<T>(caller, callBlock);
        if (!this.g.containsNode(entry) || !this.g.containsNode(call)) {
            assert (this.g.containsNode(entry)) : "IPCFG does not contain " + entry;
            assert (this.g.containsNode(call)) : "IPCFG does not contain " + call;
        }
        this.g.addEdge(call, entry);
    }

    private void addInterproceduralEdgesForEntryAndExitBlocks(CGNode n, ControlFlowGraph<SSAInstruction, ? extends T> cfg) {
        ISSABasicBlock entryBlock = (ISSABasicBlock)cfg.entry();
        ISSABasicBlock exitBlock = (ISSABasicBlock)cfg.exit();
        for (CGNode caller : Iterator2Iterable.make(this.cg.getPredNodes(n))) {
            if (!this.relevant.test(caller)) continue;
            this.addEntryAndExitEdgesToCaller(n, entryBlock, exitBlock, caller);
        }
    }

    private void addEntryAndExitEdgesToCaller(CGNode n, T entryBlock, T exitBlock, CGNode caller) {
        ControlFlowGraph<SSAInstruction, ISSABasicBlock> ccfg = this.getCFG(caller);
        if (ccfg != null) {
            SSAInstruction[] cinsts = ccfg.getInstructions();
            for (int i = 0; i < cinsts.length; ++i) {
                if (!(cinsts[i] instanceof SSAAbstractInvokeInstruction)) continue;
                SSAAbstractInvokeInstruction call = (SSAAbstractInvokeInstruction)cinsts[i];
                CallSiteReference site = call.getCallSite();
                assert (site.getProgramCounter() == ccfg.getProgramCounter(i));
                if (!this.cg.getPossibleTargets(caller, site).contains(n)) continue;
                ISSABasicBlock callerBB = (ISSABasicBlock)ccfg.getBlockForInstruction(i);
                BasicBlockInContext<ISSABasicBlock> b1 = new BasicBlockInContext<ISSABasicBlock>(caller, callerBB);
                this.addNodeForBasicBlockIfNeeded(b1);
                BasicBlockInContext<T> b2 = new BasicBlockInContext<T>(n, entryBlock);
                this.g.addEdge(b1, b2);
                for (ISSABasicBlock returnBB : Iterator2Iterable.make(ccfg.getSuccNodes(callerBB))) {
                    BasicBlockInContext<T> b3 = new BasicBlockInContext<T>(n, exitBlock);
                    BasicBlockInContext<ISSABasicBlock> b4 = new BasicBlockInContext<ISSABasicBlock>(caller, returnBB);
                    this.addNodeForBasicBlockIfNeeded(b4);
                    this.g.addEdge(b3, b4);
                }
            }
        }
    }

    private void addNodeForEachBasicBlock(ControlFlowGraph<? extends SSAInstruction, ? extends T> cfg, CGNode N) {
        for (ISSABasicBlock bb : cfg) {
            BasicBlockInContext<ISSABasicBlock> b = new BasicBlockInContext<ISSABasicBlock>(N, bb);
            this.addNodeForBasicBlockIfNeeded(b);
        }
    }

    private void addNodeForBasicBlockIfNeeded(BasicBlockInContext<T> b) {
        if (!this.g.containsNode(b)) {
            this.g.addNode(b);
            ControlFlowGraph<SSAInstruction, T> cfg = this.getCFG(b);
            if (this.hasCall(b, cfg)) {
                this.hasCallVector.set(this.g.getNumber(b));
            }
        }
    }

    public ControlFlowGraph<SSAInstruction, T> getCFG(BasicBlockInContext<T> B) throws IllegalArgumentException {
        if (B == null) {
            throw new IllegalArgumentException("B == null");
        }
        return this.getCFG(this.getCGNode(B));
    }

    public CGNode getCGNode(BasicBlockInContext<T> B) throws IllegalArgumentException {
        if (B == null) {
            throw new IllegalArgumentException("B == null");
        }
        return B.getNode();
    }

    @Override
    public void removeNodeAndEdges(BasicBlockInContext<T> N) throws UnsupportedOperationException {
        throw new UnsupportedOperationException();
    }

    @Override
    public Iterator<BasicBlockInContext<T>> iterator() {
        this.constructFullGraph("iterator");
        return this.g.iterator();
    }

    @Override
    public Stream<BasicBlockInContext<T>> stream() {
        this.constructFullGraph("stream");
        return this.g.stream();
    }

    @Override
    public int getNumberOfNodes() {
        this.constructFullGraph("getNumberOfNodes");
        return this.g.getNumberOfNodes();
    }

    private void constructFullGraph(String onBehalfOf) {
        if (!this.constructedFullGraph) {
            for (CGNode n : this.cg) {
                this.addIntraproceduralNodesAndEdgesForCGNodeIfNeeded(n);
                this.addEdgesToCallees(n);
            }
            for (int i = 0; i < this.g.getMaxNumber(); ++i) {
                this.addedSuccs.add(i);
                this.addedPreds.add(i);
            }
            this.constructedFullGraph = true;
        }
    }

    private void addEdgesToCallees(CGNode n) {
        ControlFlowGraph<SSAInstruction, T> cfg = this.getCFG(n);
        if (cfg != null) {
            for (ISSABasicBlock bb : cfg) {
                BasicBlockInContext<ISSABasicBlock> block = new BasicBlockInContext<ISSABasicBlock>(n, bb);
                if (!this.hasCall(block)) continue;
                this.addCalleeEdgesForCall(n, block);
            }
        }
    }

    private void addCalleeEdgesForReturn(CGNode node, BasicBlockInContext<T> returnBlock) {
        int num = this.g.getNumber(returnBlock);
        if (!this.handledReturns.contains(num)) {
            this.handledReturns.add(num);
            ControlFlowGraph<SSAInstruction, T> cfg = this.getCFG(returnBlock);
            Iterator<T> it = cfg.getPredNodes(returnBlock.getDelegate());
            while (it.hasNext()) {
                ISSABasicBlock b = (ISSABasicBlock)it.next();
                BasicBlockInContext<ISSABasicBlock> block = new BasicBlockInContext<ISSABasicBlock>(node, b);
                if (!this.hasCall(block)) continue;
                this.addCalleeEdgesForCall(node, block);
            }
        }
    }

    private void addCalleeEdgesForCall(CGNode n, BasicBlockInContext<T> callBlock) {
        int num = this.g.getNumber(callBlock);
        if (!this.handledCalls.contains(num)) {
            this.handledCalls.add(num);
            ControlFlowGraph<SSAInstruction, T> cfg = this.getCFG(n);
            CallSiteReference site = this.getCallSiteForCallBlock(callBlock, cfg);
            boolean irrelevantTargets = false;
            for (CGNode tn : this.cg.getPossibleTargets(n, site)) {
                if (!this.relevant.test(tn)) {
                    irrelevantTargets = true;
                    continue;
                }
                ControlFlowGraph<SSAInstruction, T> tcfg = this.getCFG(tn);
                if (tcfg == null) continue;
                T cbDelegate = callBlock.getDelegate();
                this.addEdgesFromCallToEntry(n, cbDelegate, tn, tcfg);
                Iterator<T> returnBlocks = cfg.getSuccNodes(cbDelegate);
                while (returnBlocks.hasNext()) {
                    ISSABasicBlock retBlock = (ISSABasicBlock)returnBlocks.next();
                    this.addEdgesFromExitToReturn(n, retBlock, tn, tcfg);
                    if (!irrelevantTargets) continue;
                    this.g.addEdge(callBlock, new BasicBlockInContext<ISSABasicBlock>(n, retBlock));
                }
            }
        }
    }

    private void addCallerEdges(CGNode n) {
        int num = this.cg.getNumber(n);
        if (!this.cgNodesWithCallerEdges.contains(num)) {
            this.cgNodesWithCallerEdges.add(num);
            ControlFlowGraph<SSAInstruction, T> cfg = this.getCFG(n);
            this.addInterproceduralEdgesForEntryAndExitBlocks(n, cfg);
        }
    }

    @Override
    public void addNode(BasicBlockInContext<T> n) throws UnsupportedOperationException {
        throw new UnsupportedOperationException();
    }

    @Override
    public void removeNode(BasicBlockInContext<T> n) throws UnsupportedOperationException {
        throw new UnsupportedOperationException();
    }

    @Override
    public Iterator<BasicBlockInContext<T>> getPredNodes(BasicBlockInContext<T> N) {
        this.initForPred(N);
        return this.g.getPredNodes(N);
    }

    private void initForPred(BasicBlockInContext<T> N) {
        CGNode node = this.getCGNode(N);
        this.addIntraproceduralNodesAndEdgesForCGNodeIfNeeded(node);
        int num = this.g.getNumber(N);
        if (!this.addedPreds.contains(num)) {
            this.addedPreds.add(num);
            if (N.getDelegate().isEntryBlock()) {
                this.addCallerEdges(node);
            }
            if (this.isReturn(N)) {
                this.addCalleeEdgesForReturn(node, N);
            }
        }
    }

    private void initForSucc(BasicBlockInContext<T> N) {
        CGNode node = this.getCGNode(N);
        this.addIntraproceduralNodesAndEdgesForCGNodeIfNeeded(node);
        int num = this.g.getNumber(N);
        if (!this.addedSuccs.contains(num)) {
            this.addedSuccs.add(num);
            if (N.getDelegate().isExitBlock()) {
                this.addCallerEdges(node);
            }
            if (this.hasCall(N)) {
                this.addCalleeEdgesForCall(node, N);
            }
        }
    }

    @Override
    public int getPredNodeCount(BasicBlockInContext<T> N) {
        this.initForPred(N);
        return this.g.getPredNodeCount(N);
    }

    @Override
    public Iterator<BasicBlockInContext<T>> getSuccNodes(BasicBlockInContext<T> N) {
        this.initForSucc(N);
        return this.g.getSuccNodes(N);
    }

    @Override
    public int getSuccNodeCount(BasicBlockInContext<T> N) {
        this.initForSucc(N);
        return this.g.getSuccNodeCount(N);
    }

    @Override
    public void addEdge(BasicBlockInContext<T> src, BasicBlockInContext<T> dst) throws UnsupportedOperationException {
        throw new UnsupportedOperationException();
    }

    @Override
    public void removeEdge(BasicBlockInContext<T> src, BasicBlockInContext<T> dst) throws UnsupportedOperationException {
        throw new UnsupportedOperationException();
    }

    @Override
    public void removeAllIncidentEdges(BasicBlockInContext<T> node) throws UnsupportedOperationException {
        throw new UnsupportedOperationException();
    }

    public String toString() {
        return this.g.toString();
    }

    @Override
    public boolean containsNode(BasicBlockInContext<T> N) {
        return this.g.containsNode(N);
    }

    public boolean hasCall(BasicBlockInContext<T> B) {
        this.addNodeForBasicBlockIfNeeded(B);
        return this.hasCallVector.get(this.getNumber(B));
    }

    protected boolean hasCall(BasicBlockInContext<T> B, ControlFlowGraph<SSAInstruction, T> cfg) {
        SSAInstruction[] statements = cfg.getInstructions();
        int lastIndex = B.getLastInstructionIndex();
        if (lastIndex >= 0) {
            if (statements.length <= lastIndex) {
                System.err.println(statements.length);
                System.err.println(cfg);
                assert (lastIndex < statements.length) : "bad BB " + B + " and CFG for " + this.getCGNode(B);
            }
            SSAInstruction last = statements[lastIndex];
            return last instanceof SSAAbstractInvokeInstruction;
        }
        return false;
    }

    public Set<CGNode> getCallTargets(BasicBlockInContext<T> B) {
        if (B == null) {
            throw new IllegalArgumentException("B is null");
        }
        ControlFlowGraph<SSAInstruction, T> cfg = this.getCFG(B);
        return this.getCallTargets(B, cfg, this.getCGNode(B));
    }

    private Set<CGNode> getCallTargets(IBasicBlock<SSAInstruction> B, ControlFlowGraph<SSAInstruction, T> cfg, CGNode Bnode) {
        CallSiteReference site = this.getCallSiteForCallBlock(B, cfg);
        return this.cg.getPossibleTargets(Bnode, site);
    }

    protected CallSiteReference getCallSiteForCallBlock(IBasicBlock<SSAInstruction> B, ControlFlowGraph<SSAInstruction, T> cfg) {
        SSAInstruction[] statements = cfg.getInstructions();
        SSAAbstractInvokeInstruction call = (SSAAbstractInvokeInstruction)statements[B.getLastInstructionIndex()];
        int pc = cfg.getProgramCounter(B.getLastInstructionIndex());
        CallSiteReference site = call.getCallSite();
        assert (site.getProgramCounter() == pc);
        return site;
    }

    @Override
    public void removeIncomingEdges(BasicBlockInContext<T> node) throws UnsupportedOperationException {
        throw new UnsupportedOperationException();
    }

    @Override
    public void removeOutgoingEdges(BasicBlockInContext<T> node) throws UnsupportedOperationException {
        throw new UnsupportedOperationException();
    }

    @Override
    public boolean hasEdge(BasicBlockInContext<T> src, BasicBlockInContext<T> dst) {
        if (!this.addedSuccs.contains(this.getNumber(src))) {
            if (!src.getNode().equals(dst.getNode())) {
                CGNode callee;
                if (src.getDelegate().isExitBlock()) {
                    CGNode callee2 = src.getNode();
                    if (!this.cgNodesWithCallerEdges.contains(this.cg.getNumber(callee2))) {
                        CGNode caller = dst.getNode();
                        T exitBlock = src.getDelegate();
                        ISSABasicBlock entryBlock = (ISSABasicBlock)this.getCFG(callee2).entry();
                        this.addEntryAndExitEdgesToCaller(callee2, entryBlock, exitBlock, caller);
                    }
                } else if (this.hasCall(src) && dst.getDelegate().isEntryBlock() && !this.cgNodesWithCallerEdges.contains(this.cg.getNumber(callee = dst.getNode()))) {
                    CGNode caller = src.getNode();
                    T entryBlock = dst.getDelegate();
                    ISSABasicBlock exitBlock = (ISSABasicBlock)this.getCFG(callee).exit();
                    this.addEntryAndExitEdgesToCaller(callee, entryBlock, exitBlock, caller);
                }
            } else {
                this.addIntraproceduralNodesAndEdgesForCGNodeIfNeeded(src.getNode());
            }
        }
        this.addedSuccs.add(this.getNumber(src));
        return this.g.hasEdge(src, dst);
    }

    @Override
    public int getNumber(BasicBlockInContext<T> N) {
        this.addNodeForBasicBlockIfNeeded(N);
        return this.g.getNumber(N);
    }

    @Override
    public BasicBlockInContext<T> getNode(int number) throws UnimplementedError {
        return (BasicBlockInContext)this.g.getNode(number);
    }

    @Override
    public int getMaxNumber() {
        this.constructFullGraph("getMaxNumber");
        return this.g.getMaxNumber();
    }

    @Override
    public Iterator<BasicBlockInContext<T>> iterateNodes(IntSet s) throws UnimplementedError {
        Assertions.UNREACHABLE();
        return null;
    }

    @Override
    public IntSet getSuccNodeNumbers(BasicBlockInContext<T> node) {
        this.initForSucc(node);
        return this.g.getSuccNodeNumbers(node);
    }

    @Override
    public IntSet getPredNodeNumbers(BasicBlockInContext<T> node) {
        this.initForPred(node);
        return this.g.getPredNodeNumbers(node);
    }

    public BasicBlockInContext<T> getEntry(CGNode n) {
        ControlFlowGraph<SSAInstruction, T> cfg = this.getCFG(n);
        if (cfg != null) {
            ISSABasicBlock entry = (ISSABasicBlock)cfg.entry();
            return new BasicBlockInContext<ISSABasicBlock>(n, entry);
        }
        return null;
    }

    public BasicBlockInContext<T> getExit(CGNode n) {
        ControlFlowGraph<SSAInstruction, T> cfg = this.getCFG(n);
        ISSABasicBlock entry = (ISSABasicBlock)cfg.exit();
        return new BasicBlockInContext<ISSABasicBlock>(n, entry);
    }

    public Iterator<BasicBlockInContext<T>> getReturnSites(BasicBlockInContext<T> callBlock) {
        if (callBlock == null) {
            throw new IllegalArgumentException("bb is null");
        }
        CGNode node = callBlock.getNode();
        Predicate<BasicBlockInContext> isReturn = other -> !other.isEntryBlock() && node.equals(other.getNode());
        return new FilterIterator<BasicBlockInContext<T>>(this.getSuccNodes(callBlock), isReturn);
    }

    public Iterator<BasicBlockInContext<T>> getCallSites(BasicBlockInContext<T> returnBlock, CGNode callee) {
        if (returnBlock == null) {
            throw new IllegalArgumentException("bb is null");
        }
        ControlFlowGraph<SSAInstruction, T> cfg = this.getCFG(returnBlock);
        Iterator<T> it = cfg.getPredNodes(returnBlock.getDelegate());
        CGNode node = returnBlock.getNode();
        Predicate<ISSABasicBlock> dispatchFilter = callBlock -> {
            BasicBlockInContext<ISSABasicBlock> bb = new BasicBlockInContext<ISSABasicBlock>(node, (ISSABasicBlock)callBlock);
            if (!this.hasCall(bb, cfg)) {
                return false;
            }
            if (callee != null) {
                return this.getCallTargets(bb).contains(callee);
            }
            return this.getCallTargets(bb).isEmpty();
        };
        it = new FilterIterator<ISSABasicBlock>(it, dispatchFilter);
        Function<ISSABasicBlock, BasicBlockInContext> toContext = object -> {
            ISSABasicBlock b = object;
            return new BasicBlockInContext<ISSABasicBlock>(node, b);
        };
        MapIterator<ISSABasicBlock, BasicBlockInContext> m = new MapIterator<ISSABasicBlock, BasicBlockInContext>(it, toContext);
        return new FilterIterator<BasicBlockInContext<T>>(m, this.isCall);
    }

    public boolean isReturn(BasicBlockInContext<T> bb) throws IllegalArgumentException {
        if (bb == null) {
            throw new IllegalArgumentException("bb == null");
        }
        ControlFlowGraph<SSAInstruction, T> cfg = this.getCFG(bb);
        for (ISSABasicBlock b : Iterator2Iterable.make(cfg.getPredNodes(bb.getDelegate()))) {
            if (!this.hasCall(new BasicBlockInContext<ISSABasicBlock>(bb.getNode(), b))) continue;
            return true;
        }
        return false;
    }

    public CallGraph getCallGraph() {
        return this.cg;
    }
}

