/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.wala.ipa.callgraph.propagation.cfa;

import com.ibm.wala.classLoader.IClass;
import com.ibm.wala.classLoader.IField;
import com.ibm.wala.classLoader.NewSiteReference;
import com.ibm.wala.classLoader.ProgramCounter;
import com.ibm.wala.ipa.callgraph.AnalysisOptions;
import com.ibm.wala.ipa.callgraph.CGNode;
import com.ibm.wala.ipa.callgraph.propagation.AllocationSiteInNodeFactory;
import com.ibm.wala.ipa.callgraph.propagation.ClassBasedInstanceKeys;
import com.ibm.wala.ipa.callgraph.propagation.ConstantKey;
import com.ibm.wala.ipa.callgraph.propagation.InstanceKey;
import com.ibm.wala.ipa.callgraph.propagation.InstanceKeyFactory;
import com.ibm.wala.ipa.callgraph.propagation.SmushedAllocationSiteInstanceKeys;
import com.ibm.wala.ipa.callgraph.propagation.rta.RTAContextInterpreter;
import com.ibm.wala.ipa.cha.IClassHierarchy;
import com.ibm.wala.types.ClassLoaderReference;
import com.ibm.wala.types.TypeName;
import com.ibm.wala.types.TypeReference;
import com.ibm.wala.util.collections.HashMapFactory;
import com.ibm.wala.util.collections.HashSetFactory;
import com.ibm.wala.util.collections.Iterator2Iterable;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;

public class ZeroXInstanceKeys
implements InstanceKeyFactory {
    private static final TypeName JavaLangStringBufferName = TypeName.string2TypeName("Ljava/lang/StringBuffer");
    public static final TypeReference JavaLangStringBuffer = TypeReference.findOrCreate(ClassLoaderReference.Primordial, JavaLangStringBufferName);
    private static final TypeName JavaLangStringBuilderName = TypeName.string2TypeName("Ljava/lang/StringBuilder");
    public static final TypeReference JavaLangStringBuilder = TypeReference.findOrCreate(ClassLoaderReference.Primordial, JavaLangStringBuilderName);
    private static final TypeName JavaLangAbstractStringBuilderName = TypeName.string2TypeName("Ljava/lang/AbstractStringBuilder");
    public static final TypeReference JavaLangAbstractStringBuilder = TypeReference.findOrCreate(ClassLoaderReference.Primordial, JavaLangAbstractStringBuilderName);
    public static final int NONE = 0;
    public static final int ALLOCATIONS = 1;
    public static final int SMUSH_STRINGS = 2;
    public static final int SMUSH_THROWABLES = 4;
    public static final int SMUSH_PRIMITIVE_HOLDERS = 8;
    public static final int SMUSH_MANY = 16;
    public static final int CONSTANT_SPECIFIC = 32;
    private final int SMUSH_LIMIT = 25;
    private final int policy;
    private final ClassBasedInstanceKeys classBased;
    private final AllocationSiteInNodeFactory siteBased;
    private final SmushedAllocationSiteInstanceKeys smushed;
    private final IClassHierarchy cha;
    private final RTAContextInterpreter contextInterpreter;
    protected final Map<CGNode, Set<IClass>> smushMap = HashMapFactory.make();

    public ZeroXInstanceKeys(AnalysisOptions options, IClassHierarchy cha, RTAContextInterpreter contextInterpreter, int policy) {
        if (options == null) {
            throw new IllegalArgumentException("null options");
        }
        this.policy = policy;
        if (this.disambiguateConstants()) {
            options.setUseConstantSpecificKeys(true);
        }
        this.classBased = new ClassBasedInstanceKeys(options, cha);
        this.siteBased = new AllocationSiteInNodeFactory(options, cha);
        this.smushed = new SmushedAllocationSiteInstanceKeys(options, cha);
        this.cha = cha;
        this.contextInterpreter = contextInterpreter;
    }

    private boolean smushMany() {
        return (this.policy & 0x10) > 0;
    }

    private boolean allocationPolicy() {
        return (this.policy & 1) > 0;
    }

    private boolean smushStrings() {
        return (this.policy & 2) > 0;
    }

    public boolean smushThrowables() {
        return (this.policy & 4) > 0;
    }

    private boolean smushPrimHolders() {
        return (this.policy & 8) > 0;
    }

    public boolean disambiguateConstants() {
        return (this.policy & 0x20) > 0;
    }

    @Override
    public InstanceKey getInstanceKeyForAllocation(CGNode node, NewSiteReference allocation) {
        if (allocation == null) {
            throw new IllegalArgumentException("allocation is null");
        }
        TypeReference t = allocation.getDeclaredType();
        IClass C = this.cha.lookupClass(t);
        if (C != null && this.isInteresting(C)) {
            if (this.smushMany()) {
                if (this.exceedsSmushLimit(C, node)) {
                    return this.smushed.getInstanceKeyForAllocation(node, allocation);
                }
                return this.siteBased.getInstanceKeyForAllocation(node, allocation);
            }
            return this.siteBased.getInstanceKeyForAllocation(node, allocation);
        }
        return this.classBased.getInstanceKeyForAllocation(node, allocation);
    }

    private boolean exceedsSmushLimit(IClass c, CGNode node) {
        Set<IClass> s = this.smushMap.get(node);
        if (s == null) {
            Map<IClass, Integer> count = this.countAllocsByType(node);
            HashSet smushees = HashSetFactory.make(5);
            for (Map.Entry<IClass, Integer> e : count.entrySet()) {
                Integer i = e.getValue();
                if (i <= 25) continue;
                smushees.add(e.getKey());
            }
            s = smushees.isEmpty() ? Collections.emptySet() : smushees;
            this.smushMap.put(node, s);
        }
        return s.contains(c);
    }

    private Map<IClass, Integer> countAllocsByType(CGNode node) {
        HashMap<IClass, Integer> count = HashMapFactory.make();
        for (NewSiteReference n : Iterator2Iterable.make(this.contextInterpreter.iterateNewSites(node))) {
            IClass alloc = this.cha.lookupClass(n.getDeclaredType());
            if (alloc == null) continue;
            count.merge(alloc, 1, Integer::sum);
        }
        return count;
    }

    @Override
    public InstanceKey getInstanceKeyForMultiNewArray(CGNode node, NewSiteReference allocation, int dim) {
        if (this.allocationPolicy()) {
            return this.siteBased.getInstanceKeyForMultiNewArray(node, allocation, dim);
        }
        return this.classBased.getInstanceKeyForMultiNewArray(node, allocation, dim);
    }

    @Override
    public <T> InstanceKey getInstanceKeyForConstant(TypeReference type, T S) {
        if (type == null) {
            throw new IllegalArgumentException("null type");
        }
        if (this.disambiguateConstants() || ZeroXInstanceKeys.isReflectiveType(type)) {
            return new ConstantKey<T>(S, this.getClassHierarchy().lookupClass(type));
        }
        return this.classBased.getInstanceKeyForConstant(type, S);
    }

    private static boolean isReflectiveType(TypeReference type) {
        return type.equals(TypeReference.JavaLangReflectConstructor) || type.equals(TypeReference.JavaLangReflectMethod);
    }

    @Override
    public InstanceKey getInstanceKeyForPEI(CGNode node, ProgramCounter pei, TypeReference type) {
        return this.classBased.getInstanceKeyForPEI(node, pei, type);
    }

    @Override
    public InstanceKey getInstanceKeyForMetadataObject(Object obj, TypeReference objType) {
        return this.classBased.getInstanceKeyForMetadataObject(obj, objType);
    }

    public boolean isInteresting(IClass C) {
        if (!this.allocationPolicy()) {
            return false;
        }
        if (this.smushStrings() && ZeroXInstanceKeys.isStringish(C)) {
            return false;
        }
        if (this.smushThrowables() && (ZeroXInstanceKeys.isThrowable(C) || ZeroXInstanceKeys.isStackTraceElement(C))) {
            return false;
        }
        return !this.smushPrimHolders() || !this.allFieldsArePrimitive(C);
    }

    public static boolean isStringish(IClass C) {
        if (C == null) {
            throw new IllegalArgumentException("C is null");
        }
        return C.getReference().equals(TypeReference.JavaLangString) || C.getReference().equals(JavaLangStringBuffer) || C.getReference().equals(JavaLangStringBuilder) || C.getReference().equals(JavaLangAbstractStringBuilder);
    }

    public static boolean isThrowable(IClass c) {
        if (c == null) {
            throw new IllegalArgumentException("null c");
        }
        return c.getClassHierarchy().isSubclassOf(c, c.getClassHierarchy().lookupClass(TypeReference.JavaLangThrowable));
    }

    public static boolean isStackTraceElement(IClass c) {
        if (c == null) {
            throw new IllegalArgumentException("C is null");
        }
        return c.getReference().equals(TypeReference.JavaLangStackTraceElement);
    }

    private boolean allFieldsArePrimitive(IClass c) {
        if (c.isArrayClass()) {
            TypeReference t = c.getReference().getArrayElementType();
            return t.isPrimitiveType();
        }
        if (c.getReference().equals(TypeReference.JavaLangObject)) {
            return true;
        }
        for (IField f : c.getDeclaredInstanceFields()) {
            if (!f.getReference().getFieldType().isReferenceType()) continue;
            return false;
        }
        return this.allFieldsArePrimitive(c.getSuperclass());
    }

    protected IClassHierarchy getClassHierarchy() {
        return this.cha;
    }

    public ClassBasedInstanceKeys getClassBasedInstanceKeys() {
        return this.classBased;
    }
}

