/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.wala.ipa.callgraph.impl;

import com.ibm.wala.ipa.callgraph.CGNode;
import com.ibm.wala.util.collections.EmptyIterator;
import com.ibm.wala.util.collections.IntMapIterator;
import com.ibm.wala.util.graph.NumberedEdgeManager;
import com.ibm.wala.util.graph.NumberedNodeManager;
import com.ibm.wala.util.intset.BasicNaturalRelation;
import com.ibm.wala.util.intset.IBinaryNaturalRelation;
import com.ibm.wala.util.intset.IntSet;
import java.util.Iterator;
import java.util.function.IntFunction;

public abstract class ExplicitPredecessorsEdgeManager
implements NumberedEdgeManager<CGNode> {
    private final NumberedNodeManager<CGNode> nodeManager;
    protected final IntFunction<CGNode> toNode;
    protected final IBinaryNaturalRelation predecessors = new BasicNaturalRelation(new byte[]{2}, 0);

    protected ExplicitPredecessorsEdgeManager(NumberedNodeManager<CGNode> nodeManager) {
        this.nodeManager = nodeManager;
        this.toNode = nodeManager::getNode;
    }

    @Override
    public IntSet getPredNodeNumbers(CGNode node) {
        int y = this.nodeManager.getNumber(node);
        return this.predecessors.getRelated(y);
    }

    @Override
    public Iterator<CGNode> getPredNodes(CGNode N) {
        IntSet s = this.getPredNodeNumbers(N);
        if (s == null) {
            return EmptyIterator.instance();
        }
        return new IntMapIterator<CGNode>(s.intIterator(), this.toNode);
    }

    @Override
    public int getPredNodeCount(CGNode node) {
        int y = this.nodeManager.getNumber(node);
        return this.predecessors.getRelatedCount(y);
    }
}

