/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.wala.ipa.callgraph;

import com.ibm.wala.classLoader.ArrayClassLoader;
import com.ibm.wala.classLoader.BinaryDirectoryTreeModule;
import com.ibm.wala.classLoader.ClassFileModule;
import com.ibm.wala.classLoader.IClassLoader;
import com.ibm.wala.classLoader.JarFileModule;
import com.ibm.wala.classLoader.JarStreamModule;
import com.ibm.wala.classLoader.Language;
import com.ibm.wala.classLoader.Module;
import com.ibm.wala.classLoader.SourceDirectoryTreeModule;
import com.ibm.wala.classLoader.SourceFileModule;
import com.ibm.wala.core.util.strings.Atom;
import com.ibm.wala.core.util.strings.ImmutableByteArray;
import com.ibm.wala.ipa.callgraph.ShallowAnalysisScope;
import com.ibm.wala.shrike.shrikeCT.InvalidClassFileException;
import com.ibm.wala.types.ClassLoaderReference;
import com.ibm.wala.types.Descriptor;
import com.ibm.wala.types.MethodReference;
import com.ibm.wala.types.TypeName;
import com.ibm.wala.types.TypeReference;
import com.ibm.wala.util.collections.FilterIterator;
import com.ibm.wala.util.collections.HashMapFactory;
import com.ibm.wala.util.collections.HashSetFactory;
import com.ibm.wala.util.collections.MapIterator;
import com.ibm.wala.util.collections.MapUtil;
import com.ibm.wala.util.config.SetOfClasses;
import com.ibm.wala.util.debug.Assertions;
import com.ibm.wala.util.io.RtJar;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.NotSerializableException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.jar.Attributes;
import java.util.jar.JarFile;
import java.util.jar.Manifest;

public class AnalysisScope {
    private static final int DEBUG_LEVEL = 0;
    public static final Atom PRIMORDIAL = Atom.findOrCreateUnicodeAtom("Primordial");
    public static final Atom EXTENSION = Atom.findOrCreateUnicodeAtom("Extension");
    public static final Atom APPLICATION = Atom.findOrCreateUnicodeAtom("Application");
    public static final Atom SYNTHETIC = Atom.findOrCreateUnicodeAtom("Synthetic");
    private SetOfClasses exclusions;
    public final LinkedHashMap<Atom, ClassLoaderReference> loadersByName = new LinkedHashMap();
    private final ArrayClassLoader arrayClassLoader = new ArrayClassLoader();
    private final Map<ClassLoaderReference, List<Module>> moduleMap = HashMapFactory.make(3);
    private final Map<Atom, Language> languages;
    private final HashMap<ClassLoaderReference, String> loaderImplByRef = HashMapFactory.make();

    public static AnalysisScope createJavaAnalysisScope() {
        AnalysisScope scope = new AnalysisScope(Collections.singleton(Language.JAVA));
        scope.initForJava();
        return scope;
    }

    protected void initForJava() {
        this.initCoreForJava();
        this.initSynthetic(this.loadersByName.get(APPLICATION));
    }

    protected void initCoreForJava() {
        ClassLoaderReference primordial = new ClassLoaderReference(PRIMORDIAL, ClassLoaderReference.Java, null);
        ClassLoaderReference extension = new ClassLoaderReference(EXTENSION, ClassLoaderReference.Java, primordial);
        ClassLoaderReference application = new ClassLoaderReference(APPLICATION, ClassLoaderReference.Java, extension);
        this.loadersByName.put(PRIMORDIAL, primordial);
        this.loadersByName.put(EXTENSION, extension);
        this.loadersByName.put(APPLICATION, application);
    }

    protected void initSynthetic(ClassLoaderReference parent) {
        ClassLoaderReference synthetic = new ClassLoaderReference(SYNTHETIC, ClassLoaderReference.Java, parent);
        this.setLoaderImpl(synthetic, "com.ibm.wala.ipa.summaries.BypassSyntheticClassLoader");
        this.loadersByName.put(SYNTHETIC, synthetic);
    }

    protected AnalysisScope(Collection<? extends Language> languages) {
        this.languages = new HashMap<Atom, Language>();
        for (Language language : languages) {
            this.languages.put(language.getName(), language);
        }
    }

    public Language getLanguage(Atom name) {
        return this.languages.get(name);
    }

    public boolean isApplicationLoader(IClassLoader loader) {
        return loader.getReference().equals(this.getLoader(APPLICATION));
    }

    public ClassLoaderReference getPrimordialLoader() {
        return this.getLoader(PRIMORDIAL);
    }

    public ClassLoaderReference getExtensionLoader() {
        return this.getLoader(EXTENSION);
    }

    public ClassLoaderReference getApplicationLoader() {
        return this.getLoader(APPLICATION);
    }

    public ClassLoaderReference getSyntheticLoader() {
        return this.getLoader(SYNTHETIC);
    }

    public Collection<Language> getLanguages() {
        return this.languages.values();
    }

    public Set<Language> getBaseLanguages() {
        HashSet<Language> result = HashSetFactory.make();
        for (Language language : this.getLanguages()) {
            if (language.getBaseLanguage() != null) continue;
            result.add(language);
        }
        return result;
    }

    public void addSourceFileToScope(ClassLoaderReference loader, File file, String fileName) throws IllegalArgumentException {
        List<Module> s = MapUtil.findOrCreateList(this.moduleMap, loader);
        s.add(new SourceFileModule(file, fileName, null));
    }

    public void addClassFileToScope(ClassLoaderReference loader, File file) throws IllegalArgumentException, InvalidClassFileException {
        List<Module> s = MapUtil.findOrCreateList(this.moduleMap, loader);
        s.add(new ClassFileModule(file, null));
    }

    public void addInputStreamForJarToScope(ClassLoaderReference loader, InputStream stream) throws IOException {
        MapUtil.findOrCreateList(this.moduleMap, loader).add(new JarStreamModule(stream));
    }

    public void addToScope(ClassLoaderReference loader, JarFile file) {
        List<Module> s = MapUtil.findOrCreateList(this.moduleMap, loader);
        s.add(new JarFileModule(file));
    }

    public void addToScope(ClassLoaderReference loader, Module m) {
        if (m == null) {
            throw new IllegalArgumentException("null m");
        }
        List<Module> s = MapUtil.findOrCreateList(this.moduleMap, loader);
        s.add(m);
    }

    public void addToScope(AnalysisScope other) {
        if (other == null) {
            throw new IllegalArgumentException("null other");
        }
        for (ClassLoaderReference loader : other.getLoaders()) {
            for (Module m : other.getModules(loader)) {
                this.addToScope(loader, m);
            }
        }
    }

    public void addToScopeHead(ClassLoaderReference loader, Module m) {
        if (m == null) {
            throw new IllegalArgumentException("null m");
        }
        List<Module> s = MapUtil.findOrCreateList(this.moduleMap, loader);
        s.add(0, m);
    }

    public ClassLoaderReference getLoader(Atom name) throws IllegalArgumentException {
        if (name == null) {
            throw new IllegalArgumentException("name is null");
        }
        if (name.length() == 0) {
            throw new IllegalArgumentException("empty atom is not a legal class loader name");
        }
        return this.loadersByName.get(name);
    }

    protected ClassLoaderReference classLoaderName2Ref(String clName) {
        return this.getLoader(Atom.findOrCreateUnicodeAtom(clName));
    }

    public String getLoaderImpl(ClassLoaderReference ref) {
        return this.loaderImplByRef.get(ref);
    }

    public void setLoaderImpl(ClassLoaderReference ref, String implClass) {
        if (ref == null) {
            throw new IllegalArgumentException("null ref");
        }
        if (implClass == null) {
            throw new IllegalArgumentException("null implClass");
        }
        this.loaderImplByRef.put(ref, implClass);
    }

    public Collection<ClassLoaderReference> getLoaders() {
        return Collections.unmodifiableCollection(this.loadersByName.values());
    }

    public int getNumberOfLoaders() {
        return this.loadersByName.values().size();
    }

    public SetOfClasses getExclusions() {
        return this.exclusions;
    }

    public void setExclusions(SetOfClasses classes) {
        this.exclusions = classes;
    }

    public String toString() {
        StringBuilder result = new StringBuilder();
        for (ClassLoaderReference loader : this.loadersByName.values()) {
            result.append(loader.getName());
            result.append('\n');
            for (Module m : this.getModules(loader)) {
                result.append(' ');
                result.append(m);
                result.append('\n');
            }
        }
        result.append(this.getExclusionString());
        result.append('\n');
        return result.toString();
    }

    protected Object getExclusionString() {
        return "Exclusions: " + this.exclusions;
    }

    public MethodReference findMethod(Atom loader, String klass, Atom name, ImmutableByteArray desc) {
        if (desc == null) {
            throw new IllegalArgumentException("null desc");
        }
        ClassLoaderReference clr = this.getLoader(loader);
        Descriptor ddesc = Descriptor.findOrCreate(this.languages.get(clr.getLanguage()), desc);
        TypeReference type = TypeReference.findOrCreate(clr, TypeName.string2TypeName(klass));
        return MethodReference.findOrCreate(type, name, ddesc);
    }

    public List<Module> getModules(ClassLoaderReference loader) {
        List<Module> result = this.moduleMap.get(loader);
        return result == null ? Collections.emptyList() : result;
    }

    public ArrayClassLoader getArrayClassLoader() {
        return this.arrayClassLoader;
    }

    private JarFile getRtJar() {
        return RtJar.getRtJar(new MapIterator<Module, JarFile>(new FilterIterator<Module>(this.getModules(this.getPrimordialLoader()).iterator(), JarFileModule.class::isInstance), M -> ((JarFileModule)M).getJarFile()));
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public String getJavaLibraryVersion() throws IllegalStateException {
        try (JarFile rtJar = this.getRtJar();){
            if (rtJar == null) {
                throw new IllegalStateException("cannot find runtime libraries");
            }
            assert (!rtJar.getName().endsWith(".jmod")) : String.format("main runtime library is \"%s\", but WALA does not yet know how to get the library version of a Java module", rtJar.getName());
            Manifest man = rtJar.getManifest();
            assert (man != null) : "runtime library has no manifest!";
            String result = man.getMainAttributes().getValue("Specification-Version");
            if (result == null) {
                Attributes att = man.getMainAttributes();
                System.err.println("main attributes:" + att);
                Assertions.UNREACHABLE("Manifest for " + rtJar.getName() + " has no value for Specification-Version");
            }
            String string = result;
            return string;
        }
        catch (IOException e) {
            Assertions.UNREACHABLE("error getting rt.jar manifest!");
            return null;
        }
    }

    public boolean isJava18Libraries() throws IllegalStateException {
        return this.getJavaLibraryVersion().startsWith("1.8");
    }

    public boolean isJava17Libraries() throws IllegalStateException {
        return this.getJavaLibraryVersion().startsWith("1.7");
    }

    public boolean isJava16Libraries() throws IllegalStateException {
        return this.getJavaLibraryVersion().startsWith("1.6");
    }

    public boolean isJava15Libraries() throws IllegalStateException {
        return this.getJavaLibraryVersion().startsWith("1.5");
    }

    public boolean isJava14Libraries() throws IllegalStateException {
        return this.getJavaLibraryVersion().startsWith("1.4");
    }

    public ShallowAnalysisScope toShallowAnalysisScope() throws NotSerializableException {
        if (this.getArrayClassLoader().getNumberOfClasses() != 0) {
            throw new NotSerializableException("Scope was already used for building array classes");
        }
        ArrayList<String> moduleLines = new ArrayList<String>();
        for (Map.Entry<ClassLoaderReference, List<Module>> entry : this.moduleMap.entrySet()) {
            ClassLoaderReference classLoaderReference = entry.getKey();
            String moduleLdr = classLoaderReference.getName().toString();
            String moduleLang = classLoaderReference.getLanguage().toString();
            assert (Language.JAVA.getName().equals(classLoaderReference.getLanguage())) : "Java language only is currently supported";
            for (Module m : entry.getValue()) {
                String modulePath;
                String moduleType;
                if (m instanceof JarFileModule) {
                    moduleType = "jarFile";
                    modulePath = ((JarFileModule)m).getAbsolutePath();
                } else if (m instanceof BinaryDirectoryTreeModule) {
                    moduleType = "binaryDir";
                    modulePath = ((BinaryDirectoryTreeModule)m).getPath();
                } else if (m instanceof SourceDirectoryTreeModule) {
                    moduleType = "sourceDir";
                    modulePath = ((SourceDirectoryTreeModule)m).getPath();
                } else if (m instanceof SourceFileModule) {
                    moduleType = "sourceFile";
                    modulePath = ((SourceFileModule)m).getAbsolutePath();
                } else {
                    Assertions.UNREACHABLE("Module type isn't supported - " + m);
                    continue;
                }
                modulePath = modulePath.replace("\\", "/");
                String moduleDescrLine = String.format("%s,%s,%s,%s", moduleLdr, moduleLang, moduleType, modulePath);
                moduleLines.add(moduleDescrLine);
            }
        }
        ArrayList<String> ldrImplLines = new ArrayList<String>();
        for (Map.Entry<ClassLoaderReference, String> entry : this.loaderImplByRef.entrySet()) {
            ClassLoaderReference lrReference = entry.getKey();
            String ldrName = lrReference.getName().toString();
            String ldrLang = lrReference.getLanguage().toString();
            assert (Language.JAVA.getName().equals(lrReference.getLanguage())) : "Java language only is currently supported";
            String ldrImplName = entry.getValue();
            String ldrImplDescrLine = String.format("%s,%s,%s,%s", ldrName, ldrLang, "loaderImpl", ldrImplName);
            ldrImplLines.add(ldrImplDescrLine);
        }
        ShallowAnalysisScope shallowAnalysisScope = new ShallowAnalysisScope(this.getExclusions(), moduleLines, ldrImplLines);
        return shallowAnalysisScope;
    }
}

