/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.wala.core.util.io;

import java.net.MalformedURLException;
import java.net.URI;

public class FileSuffixes {
    private static final String CLASS_SUFFIX = ".class";
    private static final String JAR_SUFFIX = ".jar";
    private static final String WAR_SUFFIX = ".war";
    private static final String DEX_SUFFIX = ".dex";
    private static final String APK_SUFFIX = ".apk";

    public static boolean isDexFile(URI uri) {
        if (uri == null) {
            throw new IllegalArgumentException("uri is null");
        }
        if (uri.toString().startsWith("jar:")) {
            try {
                String filePart = uri.toURL().getFile().toLowerCase();
                return FileSuffixes.isDexFile(filePart);
            }
            catch (MalformedURLException e) {
                throw new IllegalArgumentException(e);
            }
        }
        assert (uri.getPath() != null);
        return FileSuffixes.isDexFile(uri.getPath());
    }

    public static boolean isDexFile(String fileName) {
        if (fileName == null) {
            throw new IllegalArgumentException("fileName is null");
        }
        return fileName.toLowerCase().endsWith(DEX_SUFFIX);
    }

    public static boolean isApkFile(String fileName) {
        if (fileName == null) {
            throw new IllegalArgumentException("fileName is null");
        }
        return fileName.toLowerCase().endsWith(APK_SUFFIX);
    }

    public static boolean isClassFile(String fileName) {
        if (fileName == null) {
            throw new IllegalArgumentException("fileName is null");
        }
        return fileName.endsWith(CLASS_SUFFIX);
    }

    public static boolean isSourceFile(String fileName) {
        if (fileName == null) {
            throw new IllegalArgumentException("fileName is null");
        }
        return fileName.endsWith(".java");
    }

    public static boolean isJarFile(String fileName) {
        if (fileName == null) {
            throw new IllegalArgumentException("fileName is null");
        }
        return fileName.endsWith(JAR_SUFFIX);
    }

    public static boolean isWarFile(String fileName) {
        if (fileName == null) {
            throw new IllegalArgumentException("fileName is null");
        }
        return fileName.endsWith(WAR_SUFFIX);
    }

    public static String stripSuffix(String fileName) {
        if (fileName == null) {
            throw new IllegalArgumentException("fileName is null");
        }
        int suffixIndex = fileName.indexOf(CLASS_SUFFIX);
        int n = suffixIndex = suffixIndex > -1 ? suffixIndex : fileName.indexOf(".java");
        if (suffixIndex > -1) {
            return fileName.substring(0, suffixIndex);
        }
        return fileName;
    }

    public static boolean isRessourceFromJar(URI uri) {
        return uri.toString().startsWith("jar:");
    }
}

