/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.wala.core.tests.callGraph;

import com.ibm.wala.classLoader.Language;
import com.ibm.wala.core.util.config.AnalysisScopeReader;
import com.ibm.wala.core.util.io.FileProvider;
import com.ibm.wala.ipa.callgraph.AnalysisOptions;
import com.ibm.wala.ipa.callgraph.AnalysisScope;
import com.ibm.wala.ipa.callgraph.CallGraph;
import com.ibm.wala.ipa.callgraph.CallGraphBuilder;
import com.ibm.wala.ipa.callgraph.Entrypoint;
import com.ibm.wala.ipa.callgraph.IAnalysisCacheView;
import com.ibm.wala.ipa.callgraph.impl.Util;
import com.ibm.wala.ipa.callgraph.propagation.InstanceKey;
import com.ibm.wala.ipa.callgraph.propagation.PointerAnalysis;
import com.ibm.wala.ipa.callgraph.propagation.SSAPropagationCallGraphBuilder;
import com.ibm.wala.ipa.cha.IClassHierarchy;
import com.ibm.wala.util.CancelException;
import com.ibm.wala.util.collections.Pair;
import java.io.IOException;

public class CallGraphTestUtil {
    private static final ClassLoader MY_CLASSLOADER = CallGraphTestUtil.class.getClassLoader();
    public static String REGRESSION_EXCLUSIONS = "Java60RegressionExclusions.txt";
    public static String REGRESSION_EXCLUSIONS_FOR_GUI = "Java60RegressionExclusionsForGUI.txt";
    private static final boolean CHECK_FOOTPRINT = false;

    public static AnalysisOptions makeAnalysisOptions(AnalysisScope scope, Iterable<Entrypoint> entrypoints) {
        AnalysisOptions options = new AnalysisOptions(scope, entrypoints);
        return options;
    }

    public static AnalysisScope makeJ2SEAnalysisScope(String scopeFile, String exclusionsFile) throws IOException {
        return CallGraphTestUtil.makeJ2SEAnalysisScope(scopeFile, exclusionsFile, MY_CLASSLOADER);
    }

    public static AnalysisScope makeJ2SEAnalysisScope(String scopeFile, String exclusionsFile, ClassLoader myClassLoader) throws IOException {
        AnalysisScope scope = AnalysisScopeReader.instance.readJavaScope(scopeFile, new FileProvider().getFile(exclusionsFile), myClassLoader);
        return scope;
    }

    public static CallGraph buildRTA(AnalysisOptions options, IAnalysisCacheView cache, IClassHierarchy cha) throws IllegalArgumentException, CancelException {
        Object S = null;
        CallGraphBuilder<InstanceKey> builder = Util.makeRTABuilder(options, cache, cha);
        CallGraph cg = builder.makeCallGraph(options, null);
        return cg;
    }

    public static CallGraph buildZeroCFA(AnalysisOptions options, IAnalysisCacheView cache, IClassHierarchy cha, boolean testPAtoString) throws IllegalArgumentException, CancelException {
        Object S = null;
        SSAPropagationCallGraphBuilder builder = Util.makeZeroCFABuilder(Language.JAVA, options, cache, cha);
        CallGraph cg = builder.makeCallGraph(options, null);
        if (testPAtoString) {
            String string = builder.getPointerAnalysis().toString();
        }
        return cg;
    }

    public static CallGraph buildVanillaZeroOneCFA(AnalysisOptions options, IAnalysisCacheView cache, IClassHierarchy cha) throws IllegalArgumentException, CancelException {
        Object S = null;
        SSAPropagationCallGraphBuilder builder = Util.makeVanillaZeroOneCFABuilder(Language.JAVA, options, cache, cha);
        CallGraph cg = builder.makeCallGraph(options, null);
        return cg;
    }

    public static CallGraph buildZeroOneCFA(AnalysisOptions options, IAnalysisCacheView cache, IClassHierarchy cha, boolean testPAtoString) throws IllegalArgumentException, CancelException {
        Object S = null;
        SSAPropagationCallGraphBuilder builder = Util.makeZeroOneCFABuilder(Language.JAVA, options, cache, cha);
        CallGraph cg = builder.makeCallGraph(options, null);
        if (testPAtoString) {
            String string = builder.getPointerAnalysis().toString();
        }
        return cg;
    }

    public static CallGraph buildZeroContainerCFA(AnalysisOptions options, IAnalysisCacheView cache, IClassHierarchy cha) throws IllegalArgumentException, CancelException {
        Object S = null;
        SSAPropagationCallGraphBuilder builder = Util.makeZeroContainerCFABuilder(options, cache, cha);
        CallGraph cg = builder.makeCallGraph(options, null);
        return cg;
    }

    public static CallGraph buildZeroOneContainerCFA(AnalysisOptions options, IAnalysisCacheView cache, IClassHierarchy cha) throws IllegalArgumentException, CancelException {
        Object S = null;
        SSAPropagationCallGraphBuilder builder = Util.makeZeroOneContainerCFABuilder(options, cache, cha);
        CallGraph cg = builder.makeCallGraph(options, null);
        return cg;
    }

    public static Pair<CallGraph, PointerAnalysis<InstanceKey>> buildNCFA(int n, AnalysisOptions options, IAnalysisCacheView cache, IClassHierarchy cha) throws IllegalArgumentException, CancelException {
        Object S = null;
        SSAPropagationCallGraphBuilder builder = Util.makeNCFABuilder(n, options, cache, cha);
        CallGraph cg = builder.makeCallGraph(options, null);
        return Pair.make(cg, builder.getPointerAnalysis());
    }
}

