/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.wala.classLoader;

import com.ibm.wala.classLoader.AbstractNestedJarFileModule;
import com.ibm.wala.classLoader.JarFileModule;
import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.util.zip.ZipEntry;

public class NestedJarFileModule
extends AbstractNestedJarFileModule {
    private final JarFileModule parent;
    private final ZipEntry entry;

    public NestedJarFileModule(JarFileModule parent, ZipEntry entry) {
        super(parent);
        this.parent = parent;
        this.entry = entry;
        if (parent == null) {
            throw new IllegalArgumentException("null parent");
        }
        if (entry == null) {
            throw new IllegalArgumentException("null entry");
        }
    }

    @Override
    public InputStream getNestedContents() {
        return new ByteArrayInputStream(this.parent.getContents(this.entry));
    }

    public String toString() {
        return "Nested Jar File:" + this.entry.getName();
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.parent == null ? 0 : this.parent.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        NestedJarFileModule other = (NestedJarFileModule)obj;
        return !(this.parent == null ? other.parent != null : !this.parent.equals(other.parent));
    }
}

