/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.wala.cfg.exc.intra;

import com.ibm.wala.cfg.ControlFlowGraph;
import com.ibm.wala.cfg.exc.intra.MutableCFG;
import com.ibm.wala.cfg.exc.intra.NullPointerState;
import com.ibm.wala.cfg.exc.intra.NullPointerTransferFunctionProvider;
import com.ibm.wala.dataflow.graph.IKilldallFramework;
import com.ibm.wala.ssa.IR;
import com.ibm.wala.ssa.ISSABasicBlock;
import com.ibm.wala.ssa.SSAInstruction;
import com.ibm.wala.util.graph.Acyclic;
import com.ibm.wala.util.graph.Graph;
import com.ibm.wala.util.intset.IBinaryNaturalRelation;
import com.ibm.wala.util.intset.IntPair;

public class NullPointerFrameWork<T extends ISSABasicBlock>
implements IKilldallFramework<T, NullPointerState> {
    private final Graph<T> flow;
    private final NullPointerTransferFunctionProvider<T> transferFunct;

    public NullPointerFrameWork(ControlFlowGraph<SSAInstruction, T> cfg, IR ir) {
        IBinaryNaturalRelation backEdges = Acyclic.computeBackEdges(cfg, cfg.entry());
        boolean hasBackEdge = backEdges.iterator().hasNext();
        if (hasBackEdge) {
            MutableCFG<SSAInstruction, ISSABasicBlock> cfg2 = MutableCFG.copyFrom(cfg);
            for (IntPair edge : backEdges) {
                ISSABasicBlock from = (ISSABasicBlock)cfg2.getNode(edge.getX());
                ISSABasicBlock to = (ISSABasicBlock)cfg2.getNode(edge.getY());
                cfg2.removeEdge(from, to);
                cfg2.addEdge(from, (ISSABasicBlock)cfg.exit());
            }
            this.flow = cfg2;
        } else {
            this.flow = cfg;
        }
        this.transferFunct = new NullPointerTransferFunctionProvider<T>(cfg, ir);
    }

    @Override
    public Graph<T> getFlowGraph() {
        return this.flow;
    }

    public NullPointerTransferFunctionProvider<T> getTransferFunctionProvider() {
        return this.transferFunct;
    }
}

