/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.wala.cfg.exc.intra;

import com.ibm.wala.cfg.ControlFlowGraph;
import com.ibm.wala.cfg.exc.ExceptionPruningAnalysis;
import com.ibm.wala.cfg.exc.intra.IntraprocNullPointerAnalysis;
import com.ibm.wala.cfg.exc.intra.MethodState;
import com.ibm.wala.cfg.exc.intra.NullPointerState;
import com.ibm.wala.cfg.exc.intra.ParameterState;
import com.ibm.wala.ssa.IR;
import com.ibm.wala.ssa.SSAInstruction;
import com.ibm.wala.ssa.analysis.ExplodedControlFlowGraph;
import com.ibm.wala.ssa.analysis.IExplodedBasicBlock;
import com.ibm.wala.types.TypeReference;
import com.ibm.wala.util.CancelException;
import com.ibm.wala.util.MonitorUtil;
import com.ibm.wala.util.graph.GraphIntegrity;
import java.util.List;

public class ExplodedCFGNullPointerAnalysis
implements ExceptionPruningAnalysis<SSAInstruction, IExplodedBasicBlock> {
    private final TypeReference[] ignoredExceptions;
    private IntraprocNullPointerAnalysis<IExplodedBasicBlock> intra;
    private final IR ir;
    private final ParameterState initialState;
    private final MethodState mState;
    private final boolean optHasExceptions;

    public ExplodedCFGNullPointerAnalysis(TypeReference[] ignoredExceptions, IR ir, ParameterState paramState, MethodState mState, boolean optHasExceptions) {
        this.ignoredExceptions = ignoredExceptions != null ? (TypeReference[])ignoredExceptions.clone() : null;
        this.ir = ir;
        this.initialState = paramState == null ? ParameterState.createDefault(ir.getMethod()) : paramState;
        this.mState = mState == null ? MethodState.DEFAULT : mState;
        this.optHasExceptions = optHasExceptions;
    }

    @Override
    public int compute(MonitorUtil.IProgressMonitor progress) throws GraphIntegrity.UnsoundGraphException, CancelException {
        ExplodedControlFlowGraph orig = ExplodedControlFlowGraph.make(this.ir);
        this.intra = new IntraprocNullPointerAnalysis<IExplodedBasicBlock>(this.ir, orig, this.ignoredExceptions, this.initialState, this.mState);
        this.intra.run(progress);
        return this.intra.getNumberOfDeletedEdges();
    }

    @Override
    public ControlFlowGraph<SSAInstruction, IExplodedBasicBlock> getCFG() {
        if (this.intra == null) {
            throw new IllegalStateException("Run compute(IProgressMonitor) first.");
        }
        return this.intra.getPrunedCFG();
    }

    @Override
    public boolean hasExceptions() {
        if (this.intra == null) {
            throw new IllegalStateException("Run compute(IProgressMonitor) first.");
        }
        ControlFlowGraph<SSAInstruction, IExplodedBasicBlock> cfg = this.intra.getPrunedCFG();
        boolean hasException = false;
        for (IExplodedBasicBlock bb : cfg) {
            List<IExplodedBasicBlock> succ;
            if (bb.getInstruction() == null || (succ = cfg.getExceptionalSuccessors(bb)) == null || succ.isEmpty() || this.optHasExceptions && !succ.contains(cfg.exit())) continue;
            hasException = true;
            break;
        }
        return hasException;
    }

    @Override
    public NullPointerState getState(IExplodedBasicBlock bb) {
        if (this.intra == null) {
            throw new IllegalStateException("Run compute(IProgressMonitor) first.");
        }
        return this.intra.getState(bb);
    }
}

