/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.wala.cfg.exc.inter;

import com.ibm.wala.cfg.ControlFlowGraph;
import com.ibm.wala.cfg.exc.ExceptionPruningAnalysis;
import com.ibm.wala.cfg.exc.inter.AnalysisUtil;
import com.ibm.wala.cfg.exc.intra.NullPointerState;
import com.ibm.wala.ipa.callgraph.CGNode;
import com.ibm.wala.ssa.SSAAbstractInvokeInstruction;
import com.ibm.wala.ssa.SSAInstruction;
import com.ibm.wala.ssa.SymbolTable;
import com.ibm.wala.ssa.analysis.IExplodedBasicBlock;
import com.ibm.wala.util.CancelException;
import com.ibm.wala.util.MonitorUtil;
import com.ibm.wala.util.graph.GraphIntegrity;
import java.util.HashMap;

final class IntraprocAnalysisState
implements ExceptionPruningAnalysis<SSAInstruction, IExplodedBasicBlock> {
    private final ControlFlowGraph<SSAInstruction, IExplodedBasicBlock> cfg;
    private final HashMap<IExplodedBasicBlock, NullPointerState> statesOfSsaVars = new HashMap();
    private final HashMap<IExplodedBasicBlock, Object[]> valuesOfSsaVars = new HashMap();
    private final HashMap<IExplodedBasicBlock, int[]> numbersOfSsaVarsThatAreParemerters = new HashMap();
    private final boolean noAnalysisPossible;
    private final int deletedEdges;
    private boolean throwsException = true;

    IntraprocAnalysisState() {
        this.cfg = null;
        this.noAnalysisPossible = true;
        this.deletedEdges = 0;
    }

    IntraprocAnalysisState(ExceptionPruningAnalysis<SSAInstruction, IExplodedBasicBlock> intra, CGNode node, ControlFlowGraph<SSAInstruction, IExplodedBasicBlock> cfg, int deletedEdges) {
        this.cfg = cfg;
        this.noAnalysisPossible = false;
        this.deletedEdges = deletedEdges;
        SymbolTable sym = node.getIR().getSymbolTable();
        for (IExplodedBasicBlock block : cfg) {
            NullPointerState state = intra.getState(block);
            this.statesOfSsaVars.put(block, state);
            if (block.getInstruction() != null) {
                int numberOfSSAVars = block.getInstruction().getNumberOfUses();
                Object[] values = new Object[numberOfSSAVars];
                for (int j = 0; j < numberOfSSAVars; ++j) {
                    boolean isContant = sym.isConstant(j);
                    values[j] = isContant ? sym.getConstantValue(j) : null;
                }
                this.valuesOfSsaVars.put(block, values);
            } else {
                this.valuesOfSsaVars.put(block, null);
            }
            if (block.getInstruction() instanceof SSAAbstractInvokeInstruction) {
                SSAAbstractInvokeInstruction instr = (SSAAbstractInvokeInstruction)block.getInstruction();
                int[] numbersOfParams = AnalysisUtil.getParameterNumbers(instr);
                this.numbersOfSsaVarsThatAreParemerters.put(block, numbersOfParams);
                continue;
            }
            this.numbersOfSsaVarsThatAreParemerters.put(block, null);
        }
    }

    @Override
    public int compute(MonitorUtil.IProgressMonitor progress) throws GraphIntegrity.UnsoundGraphException, CancelException {
        return this.deletedEdges;
    }

    @Override
    public NullPointerState getState(IExplodedBasicBlock block) {
        if (this.noAnalysisPossible) {
            throw new IllegalStateException();
        }
        return this.statesOfSsaVars.get(block);
    }

    public Object[] getValues(IExplodedBasicBlock block) {
        if (this.noAnalysisPossible) {
            throw new IllegalStateException();
        }
        return this.valuesOfSsaVars.get(block);
    }

    public int[] getInjectedParameters(IExplodedBasicBlock block) {
        if (this.noAnalysisPossible) {
            throw new IllegalStateException();
        }
        if (!(block.getInstruction() instanceof SSAAbstractInvokeInstruction)) {
            throw new IllegalArgumentException();
        }
        assert (block.getInstruction() instanceof SSAAbstractInvokeInstruction);
        return this.numbersOfSsaVarsThatAreParemerters.get(block);
    }

    @Override
    public ControlFlowGraph<SSAInstruction, IExplodedBasicBlock> getCFG() {
        return this.noAnalysisPossible ? null : this.cfg;
    }

    public boolean canBeAnalyzed() {
        return !this.noAnalysisPossible;
    }

    public void setHasExceptions(boolean throwsException) {
        this.throwsException = throwsException;
    }

    @Override
    public boolean hasExceptions() {
        return this.throwsException;
    }

    public String toString() {
        if (this.noAnalysisPossible) {
            return "";
        }
        String ls = System.getProperty("line.separator");
        return this.statesOfSsaVars + ls + this.valuesOfSsaVars + ls + this.numbersOfSsaVarsThatAreParemerters;
    }
}

