/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.wala.cfg;

import com.ibm.wala.cfg.ControlFlowGraph;
import com.ibm.wala.cfg.IBasicBlock;
import com.ibm.wala.shrike.shrikeBT.IConditionalBranchInstruction;
import com.ibm.wala.ssa.SSAConditionalBranchInstruction;
import com.ibm.wala.ssa.SSAInstruction;
import com.ibm.wala.ssa.SSASwitchInstruction;
import com.ibm.wala.util.collections.Iterator2Iterable;
import com.ibm.wala.util.debug.Assertions;

public class Util {
    public static SSAInstruction getLastInstruction(ControlFlowGraph<? extends SSAInstruction, ?> cfg, IBasicBlock<?> b) {
        if (b == null) {
            throw new IllegalArgumentException("b is null");
        }
        if (cfg == null) {
            throw new IllegalArgumentException("G is null");
        }
        return cfg.getInstructions()[b.getLastInstructionIndex()];
    }

    public static boolean endsWithConditionalBranch(ControlFlowGraph<? extends SSAInstruction, ?> G, IBasicBlock<?> b) {
        return Util.getLastInstruction(G, b) instanceof SSAConditionalBranchInstruction;
    }

    public static boolean endsWithSwitch(ControlFlowGraph<? extends SSAInstruction, ?> G, IBasicBlock<?> b) {
        return Util.getLastInstruction(G, b) instanceof SSASwitchInstruction;
    }

    public static <I, T extends IBasicBlock<I>> T getFallThruBlock(ControlFlowGraph<I, T> G, T b) {
        if (b == null) {
            throw new IllegalArgumentException("b is null");
        }
        if (G == null) {
            throw new IllegalArgumentException("G is null");
        }
        return G.getBlockForInstruction(b.getLastInstructionIndex() + 1);
    }

    public static <I extends SSAInstruction, T extends IBasicBlock<I>> T getNotTakenSuccessor(ControlFlowGraph<I, T> G, T b) {
        if (G == null) {
            throw new IllegalArgumentException("G is null");
        }
        if (!Util.endsWithConditionalBranch(G, b)) {
            throw new IllegalArgumentException(b.toString() + " does not end with a conditional branch");
        }
        return Util.getFallThruBlock(G, b);
    }

    public static <I extends SSAInstruction, T extends IBasicBlock<I>> T getTakenSuccessor(ControlFlowGraph<I, T> G, T b) {
        if (G == null) {
            throw new IllegalArgumentException("G is null");
        }
        if (!Util.endsWithConditionalBranch(G, b)) {
            throw new IllegalArgumentException(b.toString() + " does not end with a conditional branch");
        }
        T fs = Util.getNotTakenSuccessor(G, b);
        for (T s : Iterator2Iterable.make(G.getSuccNodes(b))) {
            if (s == fs) continue;
            return s;
        }
        return fs;
    }

    public static <I extends SSAInstruction, T extends IBasicBlock<I>> T resolveSwitch(ControlFlowGraph<I, T> G, T b, int c) {
        assert (Util.endsWithSwitch(G, b));
        SSASwitchInstruction s = (SSASwitchInstruction)Util.getLastInstruction(G, b);
        int[] casesAndLabels = s.getCasesAndLabels();
        for (int i = 0; i < casesAndLabels.length; i += 2) {
            if (casesAndLabels[i] != c) continue;
            return G.getBlockForInstruction(casesAndLabels[i + 1]);
        }
        return G.getBlockForInstruction(s.getDefault());
    }

    public static <I extends SSAInstruction, T extends IBasicBlock<I>> boolean isSwitchDefault(ControlFlowGraph<I, T> G, T b, T s) {
        if (G == null) {
            throw new IllegalArgumentException("G is null");
        }
        assert (Util.endsWithSwitch(G, b));
        SSASwitchInstruction sw = (SSASwitchInstruction)Util.getLastInstruction(G, b);
        assert (G.getBlockForInstruction(sw.getDefault()) != null);
        return G.getBlockForInstruction(sw.getDefault()).equals(s);
    }

    public static <I extends SSAInstruction, T extends IBasicBlock<I>> int getSwitchLabel(ControlFlowGraph<I, T> G, T b, T s) {
        assert (Util.endsWithSwitch(G, b));
        SSASwitchInstruction sw = (SSASwitchInstruction)Util.getLastInstruction(G, b);
        int[] casesAndLabels = sw.getCasesAndLabels();
        for (int i = 0; i < casesAndLabels.length; i += 2) {
            if (!G.getBlockForInstruction(casesAndLabels[i + 1]).equals(s)) continue;
            return casesAndLabels[i];
        }
        Assertions.UNREACHABLE();
        return -1;
    }

    public static <I extends SSAInstruction, T extends IBasicBlock<I>> T resolveBranch(ControlFlowGraph<I, T> G, T bb, int c1, int c2) {
        SSAConditionalBranchInstruction c = (SSAConditionalBranchInstruction)Util.getLastInstruction(G, bb);
        IConditionalBranchInstruction.Operator operator = (IConditionalBranchInstruction.Operator)c.getOperator();
        switch (operator) {
            case EQ: {
                if (c1 == c2) {
                    return Util.getTakenSuccessor(G, bb);
                }
                return Util.getNotTakenSuccessor(G, bb);
            }
            case NE: {
                if (c1 != c2) {
                    return Util.getTakenSuccessor(G, bb);
                }
                return Util.getNotTakenSuccessor(G, bb);
            }
            case LT: {
                if (c1 < c2) {
                    return Util.getTakenSuccessor(G, bb);
                }
                return Util.getNotTakenSuccessor(G, bb);
            }
            case GE: {
                if (c1 >= c2) {
                    return Util.getTakenSuccessor(G, bb);
                }
                return Util.getNotTakenSuccessor(G, bb);
            }
            case GT: {
                if (c1 > c2) {
                    return Util.getTakenSuccessor(G, bb);
                }
                return Util.getNotTakenSuccessor(G, bb);
            }
            case LE: {
                if (c1 <= c2) {
                    return Util.getTakenSuccessor(G, bb);
                }
                return Util.getNotTakenSuccessor(G, bb);
            }
        }
        throw new UnsupportedOperationException(String.format("unexpected operator %s", operator));
    }

    public static <I, T extends IBasicBlock<I>> int whichPred(ControlFlowGraph<I, T> cfg, T a, T b) {
        if (cfg == null) {
            throw new IllegalArgumentException("cfg is null");
        }
        if (a == null) {
            throw new IllegalArgumentException("a is null");
        }
        if (b == null) {
            throw new IllegalArgumentException("b is null");
        }
        int i = 0;
        for (T p : Iterator2Iterable.make(cfg.getPredNodes(b))) {
            if (p.equals(a)) {
                return i;
            }
            ++i;
        }
        Assertions.UNREACHABLE("Invalid: a must be a predecessor of b! " + a + ' ' + b);
        return -1;
    }
}

