/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.wala.analysis.exceptionanalysis;

import com.ibm.wala.classLoader.CallSiteReference;
import com.ibm.wala.classLoader.IClass;
import com.ibm.wala.core.util.ssa.InstructionByIIndexMap;
import com.ibm.wala.ipa.callgraph.CGNode;
import com.ibm.wala.ipa.callgraph.propagation.InstanceKey;
import com.ibm.wala.ipa.callgraph.propagation.PointerAnalysis;
import com.ibm.wala.ipa.callgraph.propagation.PointerKey;
import com.ibm.wala.ipa.cfg.exceptionpruning.ExceptionFilter;
import com.ibm.wala.ipa.cfg.exceptionpruning.FilteredException;
import com.ibm.wala.ipa.cha.ClassHierarchy;
import com.ibm.wala.ssa.IR;
import com.ibm.wala.ssa.ISSABasicBlock;
import com.ibm.wala.ssa.SSAInstruction;
import com.ibm.wala.ssa.SSAInvokeInstruction;
import com.ibm.wala.ssa.SSAThrowInstruction;
import com.ibm.wala.types.TypeReference;
import com.ibm.wala.util.intset.IntIterator;
import com.ibm.wala.util.intset.IntSet;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;

public class IntraproceduralExceptionAnalysis {
    private final Set<TypeReference> exceptions;
    private Set<TypeReference> possiblyCaughtExceptions;
    private PointerAnalysis<InstanceKey> pointerAnalysis;
    private CGNode node;
    private ClassHierarchy classHierachy;
    private ExceptionFilter<SSAInstruction> filter;
    private IR ir;
    private boolean dummy = false;
    private Map<SSAInstruction, Boolean> allExceptionsCaught;

    public static IntraproceduralExceptionAnalysis newDummy() {
        return new IntraproceduralExceptionAnalysis();
    }

    private IntraproceduralExceptionAnalysis() {
        this.dummy = true;
        this.exceptions = Collections.emptySet();
    }

    @Deprecated
    public IntraproceduralExceptionAnalysis(IR ir, ExceptionFilter<SSAInstruction> filter, ClassHierarchy cha) {
        this(ir, filter, cha, null, null);
    }

    public IntraproceduralExceptionAnalysis(CGNode node, ExceptionFilter<SSAInstruction> filter, ClassHierarchy cha, PointerAnalysis<InstanceKey> pointerAnalysis) {
        this(node.getIR(), filter, cha, pointerAnalysis, node);
    }

    public IntraproceduralExceptionAnalysis(IR ir, ExceptionFilter<SSAInstruction> filter, ClassHierarchy cha, PointerAnalysis<InstanceKey> pointerAnalysis, CGNode node) {
        this.pointerAnalysis = pointerAnalysis;
        this.classHierachy = cha;
        this.filter = filter;
        this.ir = ir;
        this.node = node;
        this.exceptions = new LinkedHashSet<TypeReference>();
        this.possiblyCaughtExceptions = new LinkedHashSet<TypeReference>();
        this.allExceptionsCaught = new InstructionByIIndexMap<SSAInstruction, Boolean>();
        this.compute();
    }

    private void compute() {
        if (this.ir != null) {
            for (ISSABasicBlock block : this.ir.getControlFlowGraph()) {
                SSAInstruction throwingInstruction = IntraproceduralExceptionAnalysis.getThrowingInstruction(block);
                if (throwingInstruction != null && throwingInstruction.isPEI()) {
                    Set<TypeReference> thrownExceptions = this.collectThrownExceptions(throwingInstruction);
                    Set<TypeReference> caughtExceptions = this.collectCaughtExceptions(block);
                    Set<TypeReference> filteredExceptions = this.collectFilteredExceptions(throwingInstruction);
                    thrownExceptions.removeAll(filteredExceptions);
                    thrownExceptions.removeAll(caughtExceptions);
                    this.allExceptionsCaught.put(throwingInstruction, thrownExceptions.isEmpty());
                    this.exceptions.addAll(thrownExceptions);
                }
                if (!block.isCatchBlock()) continue;
                Iterator<TypeReference> it = block.getCaughtExceptionTypes();
                while (it.hasNext()) {
                    this.possiblyCaughtExceptions.add(it.next());
                }
            }
        }
        LinkedHashSet<TypeReference> subClasses = new LinkedHashSet<TypeReference>();
        for (TypeReference caught : this.possiblyCaughtExceptions) {
            if (this.classHierachy.lookupClass(caught) == null) continue;
            for (IClass iclass : this.classHierachy.computeSubClasses(caught)) {
                subClasses.add(iclass.getReference());
            }
        }
        this.possiblyCaughtExceptions.addAll(subClasses);
    }

    public Set<TypeReference> getPossiblyCaughtExceptions() {
        return this.possiblyCaughtExceptions;
    }

    private Set<TypeReference> collectFilteredExceptions(SSAInstruction throwingInstruction) {
        if (this.filter != null) {
            LinkedHashSet<TypeReference> filtered = new LinkedHashSet<TypeReference>();
            Collection<FilteredException> filters = this.filter.filteredExceptions(throwingInstruction);
            for (FilteredException filter : filters) {
                if (filter.isSubclassFiltered()) {
                    for (IClass iclass : this.classHierachy.computeSubClasses(filter.getException())) {
                        filtered.add(iclass.getReference());
                    }
                    continue;
                }
                filtered.add(filter.getException());
            }
            return filtered;
        }
        return Collections.emptySet();
    }

    public Set<TypeReference> collectThrownExceptions(SSAInstruction throwingInstruction) {
        final LinkedHashSet<TypeReference> result = new LinkedHashSet<TypeReference>(throwingInstruction.getExceptionTypes());
        throwingInstruction.visit(new SSAInstruction.Visitor(){

            @Override
            public void visitThrow(SSAThrowInstruction instruction) {
                IntraproceduralExceptionAnalysis.this.addThrown(result, instruction);
            }
        });
        return result;
    }

    private void addThrown(LinkedHashSet<TypeReference> addTo, SSAThrowInstruction instruction) {
        int exceptionVariable = instruction.getException();
        if (this.pointerAnalysis != null) {
            PointerKey pointerKey = this.pointerAnalysis.getHeapModel().getPointerKeyForLocal(this.node, exceptionVariable);
            Iterator<PointerKey> it = this.pointerAnalysis.getHeapGraph().getSuccNodes((InstanceKey)((Object)pointerKey));
            while (it.hasNext()) {
                PointerKey next = it.next();
                if (next instanceof InstanceKey) {
                    InstanceKey instanceKey = (InstanceKey)((Object)next);
                    IClass iclass = instanceKey.getConcreteType();
                    addTo.add(iclass.getReference());
                    continue;
                }
                throw new IllegalStateException("Internal error: Expected InstanceKey, got " + next.getClass().getName());
            }
        }
    }

    public static SSAInstruction getThrowingInstruction(ISSABasicBlock block) {
        SSAInstruction lastInstruction;
        SSAInstruction result = null;
        if (block.getLastInstructionIndex() >= 0 && (lastInstruction = block.getLastInstruction()) != null && lastInstruction.isPEI()) {
            result = lastInstruction;
        }
        return result;
    }

    private Set<TypeReference> collectCaughtExceptions(ISSABasicBlock block) {
        LinkedHashSet<TypeReference> result = new LinkedHashSet<TypeReference>();
        List<ISSABasicBlock> exceptionalSuccessors = this.ir.getControlFlowGraph().getExceptionalSuccessors(block);
        for (ISSABasicBlock succ : exceptionalSuccessors) {
            if (!succ.isCatchBlock()) continue;
            Iterator<TypeReference> it = succ.getCaughtExceptionTypes();
            while (it.hasNext()) {
                result.add(it.next());
            }
        }
        LinkedHashSet<TypeReference> subClasses = new LinkedHashSet<TypeReference>();
        for (TypeReference caught : result) {
            if (this.classHierachy.lookupClass(caught) == null) continue;
            for (IClass iclass : this.classHierachy.computeSubClasses(caught)) {
                subClasses.add(iclass.getReference());
            }
        }
        result.addAll(subClasses);
        return result;
    }

    public Set<TypeReference> getCaughtExceptions(CallSiteReference callsite) {
        Set<TypeReference> result = null;
        if (this.dummy) {
            result = Collections.emptySet();
        } else {
            IntSet iindices = this.ir.getCallInstructionIndices(callsite);
            IntIterator it = iindices.intIterator();
            while (it.hasNext()) {
                int iindex = it.next();
                SSAInstruction instruction = this.ir.getInstructions()[iindex];
                if (!(instruction instanceof SSAInvokeInstruction)) {
                    throw new IllegalArgumentException("The given callsite dose not correspond to an invoke instruction." + instruction);
                }
                ISSABasicBlock block = this.ir.getBasicBlockForInstruction(instruction);
                if (result == null) {
                    result = new LinkedHashSet<TypeReference>(this.collectCaughtExceptions(block));
                    continue;
                }
                result.retainAll(this.collectCaughtExceptions(block));
            }
        }
        return result;
    }

    public boolean hasUncaughtExceptions(SSAInstruction instruction) {
        Boolean allCaught = this.allExceptionsCaught.get(instruction);
        return allCaught == null ? true : allCaught == false;
    }

    public Set<TypeReference> getExceptions() {
        return this.exceptions;
    }
}

