/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.wala.analysis.exceptionanalysis;

import com.ibm.wala.analysis.exceptionanalysis.CGIntraproceduralExceptionAnalysis;
import com.ibm.wala.analysis.exceptionanalysis.Exception2BitvectorTransformer;
import com.ibm.wala.analysis.exceptionanalysis.ExceptionTransferFunctionProvider;
import com.ibm.wala.analysis.exceptionanalysis.InitializedBitVectorSolver;
import com.ibm.wala.analysis.exceptionanalysis.IntraproceduralExceptionAnalysis;
import com.ibm.wala.classLoader.CallSiteReference;
import com.ibm.wala.dataflow.graph.BitVectorFramework;
import com.ibm.wala.dataflow.graph.BitVectorSolver;
import com.ibm.wala.dataflow.graph.IKilldallFramework;
import com.ibm.wala.fixpoint.BitVectorVariable;
import com.ibm.wala.ipa.callgraph.CGNode;
import com.ibm.wala.ipa.callgraph.CallGraph;
import com.ibm.wala.ipa.callgraph.propagation.InstanceKey;
import com.ibm.wala.ipa.callgraph.propagation.PointerAnalysis;
import com.ibm.wala.ipa.cfg.exceptionpruning.ExceptionFilter;
import com.ibm.wala.ipa.cfg.exceptionpruning.ExceptionMatcher;
import com.ibm.wala.ipa.cfg.exceptionpruning.filter.DummyFilter;
import com.ibm.wala.ipa.cfg.exceptionpruning.interprocedural.IgnoreExceptionsInterFilter;
import com.ibm.wala.ipa.cfg.exceptionpruning.interprocedural.InterproceduralExceptionFilter;
import com.ibm.wala.ipa.cha.ClassHierarchy;
import com.ibm.wala.ssa.ISSABasicBlock;
import com.ibm.wala.ssa.SSAInstruction;
import com.ibm.wala.ssa.SSAInvokeInstruction;
import com.ibm.wala.types.TypeReference;
import com.ibm.wala.util.CancelException;
import com.ibm.wala.util.MonitorUtil;
import com.ibm.wala.util.graph.impl.InvertedGraph;
import java.util.Iterator;
import java.util.Set;

public class ExceptionAnalysis {
    private final BitVectorSolver<CGNode> solver;
    private final Exception2BitvectorTransformer transformer;
    private final InterproceduralExceptionFilter<SSAInstruction> filter;
    private final ClassHierarchy cha;
    private final CGIntraproceduralExceptionAnalysis intraResult;
    private final CallGraph cg;
    private boolean isSolved = false;

    public ExceptionAnalysis(CallGraph callgraph, PointerAnalysis<InstanceKey> pointerAnalysis, ClassHierarchy cha) {
        this(callgraph, pointerAnalysis, cha, null);
    }

    public ExceptionAnalysis(CallGraph callgraph, PointerAnalysis<InstanceKey> pointerAnalysis, ClassHierarchy cha, InterproceduralExceptionFilter<SSAInstruction> filter) {
        this.cha = cha;
        this.cg = callgraph;
        this.filter = filter == null ? new IgnoreExceptionsInterFilter<SSAInstruction>(new DummyFilter()) : filter;
        this.intraResult = new CGIntraproceduralExceptionAnalysis(callgraph, pointerAnalysis, cha, this.filter);
        this.transformer = new Exception2BitvectorTransformer(this.intraResult.getExceptions());
        ExceptionTransferFunctionProvider transferFunctionProvider = new ExceptionTransferFunctionProvider(this.intraResult, callgraph, this.transformer);
        InvertedGraph<CGNode> graph = new InvertedGraph<CGNode>(callgraph);
        BitVectorFramework<CGNode, TypeReference> problem = new BitVectorFramework<CGNode, TypeReference>(graph, transferFunctionProvider, this.transformer.getValues());
        this.solver = new InitializedBitVectorSolver((IKilldallFramework<CGNode, BitVectorVariable>)problem);
        this.solver.initForFirstSolve();
    }

    public void solve() {
        try {
            this.solver.solve(null);
        }
        catch (CancelException e) {
            throw new RuntimeException("Internal Error: Got Cancel Exception, but didn't use Progressmonitor!", e);
        }
        this.isSolved = true;
    }

    public void solve(MonitorUtil.IProgressMonitor monitor) throws CancelException {
        this.solver.solve(monitor);
        this.isSolved = true;
    }

    public boolean catchesException(CGNode node, ISSABasicBlock throwBlock, ISSABasicBlock catchBlock) {
        if (!this.isSolved) {
            throw new IllegalStateException("You need to use .solve() first!");
        }
        if (node.getIR().getControlFlowGraph().getExceptionalSuccessors(throwBlock).contains(catchBlock) && catchBlock.isCatchBlock()) {
            SSAInstruction instruction = IntraproceduralExceptionAnalysis.getThrowingInstruction(throwBlock);
            assert (instruction != null);
            Iterator<TypeReference> caughtExceptions = catchBlock.getCaughtExceptionTypes();
            Set<TypeReference> thrownExceptions = this.getExceptions(node, instruction);
            boolean isCaught = false;
            block0: while (caughtExceptions.hasNext() && !isCaught) {
                TypeReference caughtException = caughtExceptions.next();
                for (TypeReference thrownException : thrownExceptions) {
                    if (!(isCaught |= this.cha.isAssignableFrom(this.cha.lookupClass(caughtException), this.cha.lookupClass(thrownException)))) continue;
                    continue block0;
                }
            }
            return isCaught;
        }
        return false;
    }

    public boolean hasUncaughtExceptions(CGNode node, ISSABasicBlock block) {
        if (!this.isSolved) {
            throw new IllegalStateException("You need to use .solve() first!");
        }
        SSAInstruction instruction = IntraproceduralExceptionAnalysis.getThrowingInstruction(block);
        if (instruction != null) {
            Set<TypeReference> exceptions = this.getExceptions(node, instruction);
            boolean allCaught = true;
            for (TypeReference thrownException : exceptions) {
                boolean isCaught = false;
                for (ISSABasicBlock catchBlock : node.getIR().getControlFlowGraph().getExceptionalSuccessors(block)) {
                    TypeReference caughtException;
                    Iterator<TypeReference> caughtExceptions = catchBlock.getCaughtExceptionTypes();
                    while (caughtExceptions.hasNext() && !isCaught && !(isCaught |= this.cha.isAssignableFrom(this.cha.lookupClass(caughtException = caughtExceptions.next()), this.cha.lookupClass(thrownException)))) {
                    }
                    if (!isCaught) continue;
                    break;
                }
                if (allCaught &= isCaught) continue;
                break;
            }
            return !allCaught;
        }
        return false;
    }

    public Set<TypeReference> getExceptions(final CGNode node, SSAInstruction instruction) {
        if (!this.isSolved) {
            throw new IllegalStateException("You need to use .solve() first!");
        }
        final Set<TypeReference> thrown = this.intraResult.getAnalysis(node).collectThrownExceptions(instruction);
        instruction.visit(new SSAInstruction.Visitor(){

            @Override
            public void visitInvoke(SSAInvokeInstruction instruction) {
                CallSiteReference site = instruction.getCallSite();
                Set<CGNode> targets = ExceptionAnalysis.this.cg.getPossibleTargets(node, site);
                for (CGNode target : targets) {
                    thrown.addAll(ExceptionAnalysis.this.getCGNodeExceptions(target));
                }
            }
        });
        Set<TypeReference> result = thrown;
        if (this.filter != null) {
            ExceptionFilter<SSAInstruction> nodeFilter = this.filter.getFilter(node);
            result = ExceptionMatcher.retainedExceptions(thrown, nodeFilter.filteredExceptions(instruction), this.cha);
        }
        return result;
    }

    public Set<TypeReference> getCGNodeExceptions(CGNode node) {
        if (!this.isSolved) {
            throw new IllegalStateException("You need to use .solve() first!");
        }
        BitVectorVariable nodeResult = (BitVectorVariable)this.solver.getOut(node);
        if (nodeResult != null) {
            return this.transformer.computeExceptions(nodeResult);
        }
        return null;
    }

    public InterproceduralExceptionFilter<SSAInstruction> getFilter() {
        if (!this.isSolved) {
            throw new IllegalStateException("You need to use .solve() first!");
        }
        return this.filter;
    }
}

