/*
 * Decompiled with CFR 0.152.
 */
package codetoolkit.janalysis.dg.pdg;

import codetoolkit.janalysis.common.graph.AbstractProgramGraph;
import codetoolkit.janalysis.common.graph.Edge;
import codetoolkit.janalysis.dg.DEPEdge;
import codetoolkit.janalysis.dg.DEPNode;
import codetoolkit.janalysis.dg.cfg.CFEdge;
import codetoolkit.janalysis.dg.cfg.ControlFlowGraph;
import codetoolkit.janalysis.utils.Logger;
import codetoolkit.janalysis.utils.StringUtils;
import java.lang.invoke.CallSite;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;

public class ProgramDependenceGraph
extends AbstractProgramGraph<DEPNode, DEPEdge> {
    private String name;
    private DEPNode entry;
    private List<DEPNode> params;

    public ProgramDependenceGraph(String name) {
        this.name = name;
        this.entry = null;
        this.params = new ArrayList<DEPNode>();
        this.properties.put("label", "PDG");
        this.properties.put("type", "Program Dependence Graph (PDG)");
    }

    public String getName() {
        return this.name;
    }

    public void setEntry(DEPNode entry) {
        this.entry = entry;
    }

    public DEPNode getEntry() {
        return this.entry;
    }

    public void addParams(List<DEPNode> params) {
        this.params = params;
        for (DEPNode param : params) {
            this.addVertex(param);
        }
    }

    public List<DEPNode> getParams() {
        return this.params;
    }

    public void attachCFG(ControlFlowGraph cfg) {
        this.entry = cfg.getEntry();
        for (DEPNode param : this.params) {
            this.addVertex(param);
        }
        Iterator ctrlNodes = cfg.allVerticesIterator();
        while (ctrlNodes.hasNext()) {
            DEPNode ctrlNode = (DEPNode)ctrlNodes.next();
            this.addVertex(ctrlNode);
        }
        Iterator ctrlEdges = cfg.allEdgesIterator();
        while (ctrlEdges.hasNext()) {
            Edge ctrlEdge = ctrlEdges.next();
            this.addEdge(new Edge<DEPNode, DEPEdge>((DEPNode)ctrlEdge.source, new DEPEdge(DEPEdge.Type.CTRL, ((CFEdge)ctrlEdge.label).getLabel()), (DEPNode)ctrlEdge.target));
        }
    }

    public List<Edge<DEPNode, DEPEdge>> ctrlEdges() {
        ArrayList<Edge<DEPNode, DEPEdge>> ctrlEdges = new ArrayList<Edge<DEPNode, DEPEdge>>();
        for (Edge edge : this.allEdges) {
            if (((DEPEdge)edge.label).getType() != DEPEdge.Type.CTRL) continue;
            ctrlEdges.add(edge);
        }
        return ctrlEdges;
    }

    public List<Edge<DEPNode, DEPEdge>> dataEdges() {
        ArrayList<Edge<DEPNode, DEPEdge>> dataEdges = new ArrayList<Edge<DEPNode, DEPEdge>>();
        for (Edge edge : this.allEdges) {
            if (((DEPEdge)edge.label).getType() != DEPEdge.Type.DATA) continue;
            dataEdges.add(edge);
        }
        return dataEdges;
    }

    public List<Edge<DEPNode, DEPEdge>> outCtrlEdges(DEPNode node) {
        ArrayList<Edge<DEPNode, DEPEdge>> edges = new ArrayList<Edge<DEPNode, DEPEdge>>();
        Iterator outEdges = this.outgoingEdgesIterator(node);
        while (outEdges.hasNext()) {
            Edge out = outEdges.next();
            if (((DEPEdge)out.label).getType() != DEPEdge.Type.CTRL) continue;
            edges.add(out);
        }
        return edges;
    }

    public List<Edge<DEPNode, DEPEdge>> outDataEdges(DEPNode node) {
        ArrayList<Edge<DEPNode, DEPEdge>> edges = new ArrayList<Edge<DEPNode, DEPEdge>>();
        Iterator outEdges = this.outgoingEdgesIterator(node);
        while (outEdges.hasNext()) {
            Edge out = outEdges.next();
            if (((DEPEdge)out.label).getType() != DEPEdge.Type.DATA) continue;
            edges.add(out);
        }
        return edges;
    }

    public void printAllNodesUseDefs(Logger.Level level) {
        for (DEPNode node : this.allVertices) {
            Logger.log(node, level);
            Logger.log("  + USEs: " + Arrays.toString(node.getAllUSEs()), level);
            Logger.log("  + DEFs: " + Arrays.toString(node.getAllDEFs()) + "\n", level);
        }
    }

    @Override
    public String exportDOT() {
        return this.exportDOT(true);
    }

    public String exportDOT(boolean ctrlEdgeLabels) {
        String trg;
        String src;
        StringBuilder dot = new StringBuilder();
        dot.append("digraph PDG {\n");
        dot.append("  // graph-vertices\n");
        LinkedHashMap<DEPNode, CallSite> nodeNames = new LinkedHashMap<DEPNode, CallSite>();
        int nodeCounter = 1;
        for (DEPNode node : this.params) {
            String string = "v" + nodeCounter++;
            nodeNames.put(node, (CallSite)((Object)string));
            StringBuilder label = new StringBuilder("  [label=\"");
            if (node.getLineOfCode() > 0) {
                label.append(node.getLineOfCode()).append(":  ");
            }
            String code = node.getCode();
            label.append(StringUtils.escape(code)).append("\", shape=box, style=filled, fillcolor=orange];");
            dot.append("  " + string + label.toString() + "\n");
        }
        HashSet<DEPNode> paramNodes = new HashSet<DEPNode>(this.params);
        for (DEPNode dEPNode : this.allVertices) {
            if (paramNodes.contains(dEPNode)) continue;
            String name = "v" + nodeCounter++;
            nodeNames.put(dEPNode, (CallSite)((Object)name));
            StringBuilder label = new StringBuilder("  [label=\"");
            if (dEPNode.getLineOfCode() > 0) {
                label.append(dEPNode.getLineOfCode()).append(":  ");
            }
            String code = dEPNode.getCode();
            label.append(StringUtils.escape(code)).append("\"];");
            dot.append("  " + name + label.toString() + "\n");
        }
        dot.append("  // graph-edges\n");
        for (Edge edge : this.ctrlEdges()) {
            src = (String)nodeNames.get(edge.source);
            trg = (String)nodeNames.get(edge.target);
            if (ctrlEdgeLabels) {
                dot.append("  " + src + " -> " + trg + "  [arrowhead=empty, color=gray, style=dashed, label=\"" + ((DEPEdge)edge.label).getLabel() + "\"];\n");
                continue;
            }
            dot.append("  " + src + " -> " + trg + "  [arrowhead=empty, color=gray, style=dashed];\n");
        }
        for (Edge edge : this.dataEdges()) {
            src = (String)nodeNames.get(edge.source);
            trg = (String)nodeNames.get(edge.target);
            dot.append("   " + src + " -> " + trg + "   [style=bold, label=\" " + ((DEPEdge)edge.label).getLabel() + "\"];\n");
        }
        dot.append("  // end-of-graph\n}\n");
        return dot.toString();
    }

    @Override
    public String exportJSON() {
        StringBuilder json = new StringBuilder();
        json.append("{\n  \"directed\": true,\n");
        json.append("  \"multigraph\": true,\n");
        block6: for (Map.Entry property : this.properties.entrySet()) {
            switch ((String)property.getKey()) {
                case "directed": {
                    continue block6;
                }
            }
            json.append("  \"" + (String)property.getKey() + "\": \"" + (String)property.getValue() + "\",\n");
        }
        LinkedHashMap<DEPNode, Integer> nodeNames = new LinkedHashMap<DEPNode, Integer>();
        json.append("  \"nodes\": [\n");
        int nodeCounter = 0;
        for (DEPNode node : this.allVertices) {
            json.append("    {\n");
            json.append("      \"id\": " + nodeCounter + ",\n");
            json.append("      \"line\": " + node.getLineOfCode() + ",\n");
            String code = node.getCode();
            json.append("      \"label\": \"" + StringUtils.escape(code) + "\",\n");
            json.append("      \"defs\": " + StringUtils.toJsonArray(node.getAllDEFs()) + ",\n");
            json.append("      \"uses\": " + StringUtils.toJsonArray(node.getAllUSEs()) + "\n");
            nodeNames.put(node, nodeCounter);
            if (++nodeCounter == this.vertexCount()) {
                json.append("    }\n");
                continue;
            }
            json.append("    },\n");
        }
        json.append("  ],\n\n  \"edges\": [\n");
        int edgeCounter = 0;
        for (Edge<DEPNode, DEPEdge> edge : this.ctrlEdges()) {
            json.append("    {\n");
            json.append("      \"id\": " + edgeCounter + ",\n");
            json.append("      \"source\": " + nodeNames.get(edge.source) + ",\n");
            json.append("      \"target\": " + nodeNames.get(edge.target) + ",\n");
            json.append("      \"type\": \"Control\",\n");
            json.append("      \"label\": \"" + ((DEPEdge)edge.label).getLabel() + "\"\n");
            if (++edgeCounter == this.edgeCount()) {
                json.append("    }\n");
                continue;
            }
            json.append("    },\n");
        }
        for (Edge<DEPNode, DEPEdge> edge : this.dataEdges()) {
            json.append("    {\n");
            json.append("      \"id\": " + edgeCounter + ",\n");
            json.append("      \"source\": " + nodeNames.get(edge.source) + ",\n");
            json.append("      \"target\": " + nodeNames.get(edge.target) + ",\n");
            json.append("      \"type\": \"Data\",\n");
            json.append("      \"label\": \"" + ((DEPEdge)edge.label).getLabel() + "\"\n");
            if (++edgeCounter == this.edgeCount()) {
                json.append("    }\n");
                continue;
            }
            json.append("    },\n");
        }
        json.append("  ]\n}\n");
        return json.toString();
    }
}

