/*
 * Decompiled with CFR 0.152.
 */
package codetoolkit.janalysis.common.collections;

import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.Set;

public class IdentityLinkedHashSet<E>
implements Set<E> {
    private final LinkedHashSet<IdentityWrapper> set;

    public IdentityLinkedHashSet() {
        this.set = new LinkedHashSet(16, 0.8f);
    }

    public IdentityLinkedHashSet(int capcity) {
        this.set = new LinkedHashSet(capcity, 0.8f);
    }

    public IdentityLinkedHashSet(Set<E> set) {
        this.set = new LinkedHashSet(16, 0.8f);
        for (E e : set) {
            this.set.add(new IdentityWrapper(e));
        }
    }

    @Override
    public boolean add(E e) {
        return this.set.add(new IdentityWrapper(e));
    }

    @Override
    public boolean addAll(Collection<? extends E> c) {
        boolean result = false;
        for (E e : c) {
            result |= this.add(e);
        }
        return result;
    }

    @Override
    public boolean remove(Object o) {
        return this.set.remove(new IdentityWrapper(o));
    }

    @Override
    public boolean removeAll(Collection<?> c) {
        boolean result = false;
        for (Object obj : c) {
            result |= this.remove(obj);
        }
        return result;
    }

    @Override
    public int size() {
        return this.set.size();
    }

    @Override
    public boolean isEmpty() {
        return this.set.isEmpty();
    }

    @Override
    public boolean contains(Object obj) {
        return this.set.contains(new IdentityWrapper(obj));
    }

    @Override
    public boolean containsAll(Collection<?> c) {
        boolean result = true;
        for (Object obj : c) {
            result &= this.contains(obj);
        }
        return result;
    }

    @Override
    public void clear() {
        this.set.clear();
    }

    @Override
    public Iterator<E> iterator() {
        Iterator iter = new Iterator<E>(){
            private Iterator<IdentityWrapper> wrpIter;
            {
                this.wrpIter = IdentityLinkedHashSet.this.set.iterator();
            }

            @Override
            public boolean hasNext() {
                return this.wrpIter.hasNext();
            }

            @Override
            public E next() {
                return this.wrpIter.next().ELEM;
            }

            @Override
            public void remove() {
                this.wrpIter.remove();
            }
        };
        return iter;
    }

    @Override
    public Object[] toArray() {
        Object[] array = new Object[this.set.size()];
        int idx = 0;
        for (IdentityWrapper wrp : this.set) {
            array[idx] = wrp.ELEM;
            ++idx;
        }
        return array;
    }

    @Override
    public <T> T[] toArray(T[] array) {
        int idx = 0;
        for (IdentityWrapper wrp : this.set) {
            array[idx] = wrp.ELEM;
            ++idx;
        }
        return array;
    }

    @Override
    public boolean retainAll(Collection<?> c) {
        boolean result = false;
        Iterator iter = this.set.iterator();
        while (iter.hasNext()) {
            IdentityWrapper wrp = (IdentityWrapper)iter.next();
            if (c.contains(wrp.ELEM)) continue;
            iter.remove();
            result = true;
        }
        return result;
    }

    private static class IdentityWrapper {
        public final Object ELEM;

        IdentityWrapper(Object elem) {
            this.ELEM = elem;
        }

        public boolean equals(Object obj) {
            return obj instanceof IdentityWrapper && this.ELEM == ((IdentityWrapper)obj).ELEM;
        }

        public int hashCode() {
            return System.identityHashCode(this.ELEM);
        }
    }
}

