/*
 * Decompiled with CFR 0.152.
 */
package codetoolkit.janalysis.ast;

import codetoolkit.janalysis.ast.ASEdge;
import codetoolkit.janalysis.ast.ASNode;
import codetoolkit.janalysis.common.graph.AbstractProgramGraph;
import codetoolkit.janalysis.common.graph.Edge;
import codetoolkit.janalysis.utils.StringUtils;
import java.lang.invoke.CallSite;
import java.util.LinkedHashMap;
import java.util.Map;

public class AbstractSyntaxTree
extends AbstractProgramGraph<ASNode, ASEdge> {
    public final ASNode root;

    public AbstractSyntaxTree() {
        this.root = new ASNode(ASNode.Type.ROOT);
        this.properties.put("label", "AST");
        this.properties.put("type", "Abstract Syntax Tree (AST)");
        this.addVertex(this.root);
    }

    public AbstractSyntaxTree(AbstractSyntaxTree ast) {
        super(ast);
        this.root = ast.root;
    }

    @Override
    public String exportDOT() {
        StringBuilder dot = new StringBuilder();
        dot.append("digraph AST {\n");
        dot.append("  // graph-vertices\n");
        LinkedHashMap<ASNode, CallSite> nodeNames = new LinkedHashMap<ASNode, CallSite>();
        int nodeCounter = 1;
        for (ASNode node : this.allVertices) {
            String name = "n" + nodeCounter++;
            nodeNames.put(node, (CallSite)((Object)name));
            StringBuilder label = new StringBuilder("  [label=\"");
            label.append(StringUtils.escape(node.toString())).append("\"];");
            dot.append("  " + name + label.toString() + "\n");
        }
        dot.append("  // graph-edges\n");
        for (Edge edge : this.allEdges) {
            String src = (String)nodeNames.get(edge.source);
            String trg = (String)nodeNames.get(edge.target);
            dot.append("  " + src + " -> " + trg + ";\n");
        }
        dot.append("  // end-of-graph\n}\n");
        return dot.toString();
    }

    @Override
    public String exportJSON() {
        StringBuilder json = new StringBuilder();
        json.append("{\n  \"directed\": true,\n");
        block6: for (Map.Entry property : this.properties.entrySet()) {
            switch ((String)property.getKey()) {
                case "directed": {
                    continue block6;
                }
            }
            json.append("  \"" + (String)property.getKey() + "\": \"" + (String)property.getValue() + "\",\n");
        }
        json.append("  \"nodes\": [\n");
        LinkedHashMap<ASNode, Integer> nodeIDs = new LinkedHashMap<ASNode, Integer>();
        int nodeCounter = 0;
        for (ASNode node : this.allVertices) {
            json.append("    {\n");
            json.append("      \"id\": " + nodeCounter + ",\n");
            json.append("      \"line\": " + node.getLineOfCode() + ",\n");
            json.append("      \"type\": \"" + node.getType() + "\",\n");
            String code = node.getCode();
            code = StringUtils.isEmpty(code) ? node.getType().label : StringUtils.escape(code);
            json.append("      \"label\": \"" + code + "\",\n");
            String normalized = node.getNormalizedCode();
            normalized = StringUtils.isEmpty(normalized) ? code : StringUtils.escape(normalized);
            json.append("      \"normalized\": \"" + normalized + "\"\n");
            nodeIDs.put(node, nodeCounter);
            if (++nodeCounter == this.allVertices.size()) {
                json.append("    }\n");
                continue;
            }
            json.append("    },\n");
        }
        json.append("  ],\n\n  \"edges\": [\n");
        int edgeCounter = 0;
        for (Edge edge : this.allEdges) {
            json.append("    {\n");
            json.append("      \"id\": " + edgeCounter + ",\n");
            json.append("      \"source\": " + nodeIDs.get(edge.source) + ",\n");
            json.append("      \"target\": " + nodeIDs.get(edge.target) + ",\n");
            json.append("      \"label\": \"\"\n");
            if (++edgeCounter == this.allEdges.size()) {
                json.append("    }\n");
                continue;
            }
            json.append("    },\n");
        }
        json.append("  ]\n}\n");
        return json.toString();
    }
}

