"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
require("source-map-support/register");
const cdk = require("@aws-cdk/core");
const cfn = require("@aws-cdk/aws-cloudformation");
const config_1 = require("./config");
const util_1 = require("./util");
class DatadogIntegrationStack extends cdk.Stack {
    constructor(scope, id, props) {
        super(scope, id, props);
        this.DATADOG_AWS_ACCOUNT_ID = "464622532012"; // DO NOT CHANGE!
        const propsWithDefaults = config_1.applyDefaultsToConfig(props);
        let policyMacroStack;
        if (propsWithDefaults.installDatadogPolicyMacro) {
            policyMacroStack = this.createPolicyMacroStack();
        }
        this.createIntegrationRole(propsWithDefaults, policyMacroStack);
        this.createForwarderStack(propsWithDefaults);
    }
    createPolicyMacroStack() {
        return new cfn.CfnStack(this, "PolicyMacroStack", {
            templateUrl: "https://datadog-cloudformation-template.s3.amazonaws.com/aws/datadog_policy_macro.yaml",
        });
    }
    createIntegrationRole(props, policyMacroStack) {
        const integrationRoleStack = new cfn.CfnStack(this, "IntegrationRoleStack", {
            templateUrl: "https://datadog-cloudformation-template.s3.amazonaws.com/aws/datadog_integration_role.yaml",
            parameters: Object.assign({
                ExternalId: props.externalId,
                Permissions: props.permissions.toString(),
                IAMRoleName: props.iamRoleName,
                LogArchives: util_1.bucketsToString(props.logArchives),
                CloudTrails: util_1.bucketsToString(props.cloudTrails),
                DdAWSAccountId: this.DATADOG_AWS_ACCOUNT_ID,
            }, { ...props.additionalIntegrationRoleParams }),
        });
        if (policyMacroStack) {
            integrationRoleStack.addDependsOn(policyMacroStack);
        }
        return integrationRoleStack;
    }
    createForwarderStack(props) {
        return new cfn.CfnStack(this, "ForwarderStack", {
            templateUrl: `https://datadog-cloudformation-template.s3.amazonaws.com/aws/forwarder/${props.forwarderVersion}.yaml`,
            parameters: Object.assign({
                DdApiKey: "USE_ARN",
                DdApiKeySecretArn: props.apiKey.secretArn,
                DdSite: props.site,
                FunctionName: props.forwarderName,
            }, { ...props.additionalForwarderParams }),
        });
    }
}
exports.DatadogIntegrationStack = DatadogIntegrationStack;
//# sourceMappingURL=data:application/json;base64,eyJ2ZXJzaW9uIjozLCJmaWxlIjoiaW5kZXguanMiLCJzb3VyY2VSb290IjoiIiwic291cmNlcyI6WyJpbmRleC50cyJdLCJuYW1lcyI6W10sIm1hcHBpbmdzIjoiOztBQUFBLHVDQUFxQztBQUNyQyxxQ0FBcUM7QUFDckMsbURBQW1EO0FBR25ELHFDQUdrQjtBQUNsQixpQ0FBeUM7QUEyR3pDLE1BQWEsdUJBQXdCLFNBQVEsR0FBRyxDQUFDLEtBQUs7SUFHcEQsWUFDRSxLQUFvQixFQUNwQixFQUFVLEVBQ1YsS0FBb0M7UUFFcEMsS0FBSyxDQUFDLEtBQUssRUFBRSxFQUFFLEVBQUUsS0FBSyxDQUFDLENBQUM7UUFQbEIsMkJBQXNCLEdBQUcsY0FBYyxDQUFDLENBQUMsaUJBQWlCO1FBUWhFLE1BQU0saUJBQWlCLEdBQUcsOEJBQXFCLENBQUMsS0FBSyxDQUFDLENBQUM7UUFFdkQsSUFBSSxnQkFBMEMsQ0FBQztRQUMvQyxJQUFJLGlCQUFpQixDQUFDLHlCQUF5QixFQUFFO1lBQy9DLGdCQUFnQixHQUFHLElBQUksQ0FBQyxzQkFBc0IsRUFBRSxDQUFDO1NBQ2xEO1FBRUQsSUFBSSxDQUFDLHFCQUFxQixDQUFDLGlCQUFpQixFQUFFLGdCQUFnQixDQUFDLENBQUM7UUFDaEUsSUFBSSxDQUFDLG9CQUFvQixDQUFDLGlCQUFpQixDQUFDLENBQUM7SUFDL0MsQ0FBQztJQUVPLHNCQUFzQjtRQUM1QixPQUFPLElBQUksR0FBRyxDQUFDLFFBQVEsQ0FBQyxJQUFJLEVBQUUsa0JBQWtCLEVBQUU7WUFDaEQsV0FBVyxFQUNULHdGQUF3RjtTQUMzRixDQUFDLENBQUM7SUFDTCxDQUFDO0lBRU8scUJBQXFCLENBQzNCLEtBQTJDLEVBQzNDLGdCQUErQjtRQUUvQixNQUFNLG9CQUFvQixHQUFHLElBQUksR0FBRyxDQUFDLFFBQVEsQ0FDM0MsSUFBSSxFQUNKLHNCQUFzQixFQUN0QjtZQUNFLFdBQVcsRUFDVCw0RkFBNEY7WUFDOUYsVUFBVSxFQUFFLE1BQU0sQ0FBQyxNQUFNLENBQ3ZCO2dCQUNFLFVBQVUsRUFBRSxLQUFLLENBQUMsVUFBVTtnQkFDNUIsV0FBVyxFQUFFLEtBQUssQ0FBQyxXQUFXLENBQUMsUUFBUSxFQUFFO2dCQUN6QyxXQUFXLEVBQUUsS0FBSyxDQUFDLFdBQVc7Z0JBQzlCLFdBQVcsRUFBRSxzQkFBZSxDQUFDLEtBQUssQ0FBQyxXQUFXLENBQUM7Z0JBQy9DLFdBQVcsRUFBRSxzQkFBZSxDQUFDLEtBQUssQ0FBQyxXQUFXLENBQUM7Z0JBQy9DLGNBQWMsRUFBRSxJQUFJLENBQUMsc0JBQXNCO2FBQzVDLEVBQ0QsRUFBRSxHQUFHLEtBQUssQ0FBQywrQkFBK0IsRUFBRSxDQUM3QztTQUNGLENBQ0YsQ0FBQztRQUVGLElBQUksZ0JBQWdCLEVBQUU7WUFDcEIsb0JBQW9CLENBQUMsWUFBWSxDQUFDLGdCQUFnQixDQUFDLENBQUM7U0FDckQ7UUFFRCxPQUFPLG9CQUFvQixDQUFDO0lBQzlCLENBQUM7SUFFTyxvQkFBb0IsQ0FDMUIsS0FBMkM7UUFFM0MsT0FBTyxJQUFJLEdBQUcsQ0FBQyxRQUFRLENBQUMsSUFBSSxFQUFFLGdCQUFnQixFQUFFO1lBQzlDLFdBQVcsRUFBRSwwRUFBMEUsS0FBSyxDQUFDLGdCQUFnQixPQUFPO1lBQ3BILFVBQVUsRUFBRSxNQUFNLENBQUMsTUFBTSxDQUN2QjtnQkFDRSxRQUFRLEVBQUUsU0FBUztnQkFDbkIsaUJBQWlCLEVBQUUsS0FBSyxDQUFDLE1BQU0sQ0FBQyxTQUFTO2dCQUN6QyxNQUFNLEVBQUUsS0FBSyxDQUFDLElBQUk7Z0JBQ2xCLFlBQVksRUFBRSxLQUFLLENBQUMsYUFBYTthQUNsQyxFQUNELEVBQUUsR0FBRyxLQUFLLENBQUMseUJBQXlCLEVBQUUsQ0FDdkM7U0FDRixDQUFDLENBQUM7SUFDTCxDQUFDO0NBQ0Y7QUExRUQsMERBMEVDIiwic291cmNlc0NvbnRlbnQiOlsiaW1wb3J0IFwic291cmNlLW1hcC1zdXBwb3J0L3JlZ2lzdGVyXCI7XG5pbXBvcnQgKiBhcyBjZGsgZnJvbSBcIkBhd3MtY2RrL2NvcmVcIjtcbmltcG9ydCAqIGFzIGNmbiBmcm9tIFwiQGF3cy1jZGsvYXdzLWNsb3VkZm9ybWF0aW9uXCI7XG5pbXBvcnQgKiBhcyBzZWNyZXRzIGZyb20gXCJAYXdzLWNkay9hd3Mtc2VjcmV0c21hbmFnZXJcIjtcbmltcG9ydCAqIGFzIHMzIGZyb20gXCJAYXdzLWNkay9hd3MtczNcIjtcbmltcG9ydCB7XG4gIGFwcGx5RGVmYXVsdHNUb0NvbmZpZyxcbiAgRGF0YWRvZ0ludGVncmF0aW9uQ29uZmlnV2l0aERlZmF1bHRzLFxufSBmcm9tIFwiLi9jb25maWdcIjtcbmltcG9ydCB7IGJ1Y2tldHNUb1N0cmluZyB9IGZyb20gXCIuL3V0aWxcIjtcblxudHlwZSBEYXRhZG9nUGVybWlzc2lvbnNMZXZlbCA9IFwiRnVsbFwiIHwgXCJDb3JlXCI7XG5leHBvcnQgaW50ZXJmYWNlIERhdGFkb2dJbnRlZ3JhdGlvbkNvbmZpZyB7XG4gIC8qKlxuICAgKiBBUEkga2V5IGZvciB0aGUgRGF0YWRvZyBhY2NvdW50IChmaW5kIGF0IGh0dHBzOi8vYXBwLmRhdGFkb2docS5jb20vYWNjb3VudC9zZXR0aW5ncyNhcGkpXG4gICAqL1xuICByZWFkb25seSBhcGlLZXk6IHNlY3JldHMuSVNlY3JldDtcblxuICAvKipcbiAgICogRXh0ZXJuYWwgSUQgZm9yIHRoZSBEYXRhZG9nIHJvbGUgKGdlbmVyYXRlIGF0XG4gICAqIGh0dHBzOi8vYXBwLmRhdGFkb2docS5jb20vYWNjb3VudC9zZXR0aW5ncyNpbnRlZ3JhdGlvbnMvYW1hem9uLXdlYi1zZXJ2aWNlcylcbiAgICovXG4gIHJlYWRvbmx5IGV4dGVybmFsSWQ6IHN0cmluZztcblxuICAvKipcbiAgICogRGVmaW5lIHlvdXIgRGF0YWRvZyBTaXRlIHRvIHNlbmQgZGF0YSB0by5cbiAgICogRm9yIHRoZSBEYXRhZG9nIEVVIHNpdGUsIHNldCB0byBkYXRhZG9naHEuZXVcbiAgICpcbiAgICogQGRlZmF1bHQgZGF0YWRvZ2hxLmNvbVxuICAgKi9cbiAgcmVhZG9ubHkgc2l0ZT86IHN0cmluZztcblxuICAvKipcbiAgICogQ3VzdG9taXplIHRoZSBuYW1lIG9mIElBTSByb2xlIGZvciBEYXRhZG9nIEFXUyBpbnRlZ3JhdGlvblxuICAgKlxuICAgKiBAZGVmYXVsdCBEYXRhZG9nSW50ZWdyYXRpb25Sb2xlXG4gICAqL1xuICByZWFkb25seSBpYW1Sb2xlTmFtZT86IHN0cmluZztcblxuICAvKipcbiAgICogQ3VzdG9taXplIHRoZSBwZXJtaXNzaW9uIGxldmVsIGZvciB0aGUgRGF0YWRvZyBJQU0gcm9sZS5cbiAgICogU2VsZWN0IFwiQ29yZVwiIHRvIG9ubHkgZ3JhbnQgRGF0YWRvZyByZWFkLW9ubHkgcGVybWlzc2lvbnMgKG5vdCByZWNvbW1lbmRlZCkuXG4gICAqXG4gICAqIEBkZWZhdWx0IEZ1bGxcbiAgICovXG4gIHJlYWRvbmx5IHBlcm1pc3Npb25zPzogRGF0YWRvZ1Blcm1pc3Npb25zTGV2ZWw7XG5cbiAgLyoqXG4gICAqIFRoZSBEYXRhZG9nIEZvcndhcmRlciBMYW1iZGEgZnVuY3Rpb24gbmFtZS4gRE8gTk9UIGNoYW5nZSB3aGVuIHVwZGF0aW5nIGFuIGV4aXN0aW5nXG4gICAqIENsb3VkRm9ybWF0aW9uIHN0YWNrLCBvdGhlcndpc2UgdGhlIGN1cnJlbnQgZm9yd2FyZGVyIGZ1bmN0aW9uIHdpbGwgYmUgcmVwbGFjZWQgYW5kXG4gICAqIGFsbCB0aGUgdHJpZ2dlcnMgd2lsbCBiZSBsb3N0LlxuICAgKlxuICAgKiBAZGVmYXVsdCBEYXRhZG9nRm9yd2FyZGVyXG4gICAqL1xuICByZWFkb25seSBmb3J3YXJkZXJOYW1lPzogc3RyaW5nO1xuXG4gIC8qKlxuICAgKiBTcGVjaWZ5IGEgdmVyc2lvbiBvZiB0aGUgZm9yd2FyZGVyIHRvIHVzZS4gU2VlXG4gICAqIGh0dHBzOi8vZ2l0aHViLmNvbS9EYXRhRG9nL2RhdGFkb2ctc2VydmVybGVzcy1mdW5jdGlvbnMvcmVsZWFzZXMuIFBhc3MgdGhpc1xuICAgKiBwYXJhbWV0ZXIgYXMgYSB2ZXJzaW9uIHN0cmluZywgZS5nLiwgJzMuOS4wJ1xuICAgKlxuICAgKiBAZGVmYXVsdCBsYXRlc3RcbiAgICovXG4gIHJlYWRvbmx5IGZvcndhcmRlclZlcnNpb24/OiBzdHJpbmc7XG5cbiAgLyoqXG4gICAqIElmIHlvdSBhbHJlYWR5IGRlcGxveWVkIGEgc3RhY2sgdXNpbmcgdGhpcyB0ZW1wbGF0ZSwgc2V0IHRoaXMgcGFyYW1ldGVyIHRvIGZhbHNlXG4gICAqIHRvIHNraXAgdGhlIGluc3RhbGxhdGlvbiBvZiB0aGUgRGF0YWRvZ1BvbGljeSBNYWNybyBhZ2FpblxuICAgKlxuICAgKiBAZGVmYXVsdCB0cnVlXG4gICAqL1xuICByZWFkb25seSBpbnN0YWxsRGF0YWRvZ1BvbGljeU1hY3JvPzogYm9vbGVhbjtcblxuICAvKipcbiAgICogUzMgcGF0aHMgdG8gc3RvcmUgbG9nIGFyY2hpdmVzIGZvciBsb2cgcmVoeWRyYXRpb24uXG4gICAqIFBlcm1pc3Npb25zIHdpbGwgYmUgYXV0b21hdGljYWxseSBhZGRlZCB0byB0aGUgRGF0YWRvZyBpbnRlZ3JhdGlvbiBJQU0gcm9sZS5cbiAgICogaHR0cHM6Ly9kb2NzLmRhdGFkb2docS5jb20vbG9ncy9hcmNoaXZlcy9yZWh5ZHJhdGluZy8/dGFiPWF3c3NcbiAgICovXG4gIHJlYWRvbmx5IGxvZ0FyY2hpdmVzPzogczMuQnVja2V0W10gfCB1bmRlZmluZWQ7XG5cbiAgLyoqXG4gICAqIFMzIGJ1Y2tldHMgZm9yIERhdGFkb2cgQ2xvdWRUcmFpbCBpbnRlZ3JhdGlvbi4gUGVybWlzc2lvbnMgd2lsbCBiZSBhdXRvbWF0aWNhbGx5XG4gICAqIGFkZGVkIHRvIHRoZSBEYXRhZG9nIGludGVncmF0aW9uIElBTSByb2xlLlxuICAgKiBodHRwczovL2RvY3MuZGF0YWRvZ2hxLmNvbS9pbnRlZ3JhdGlvbnMvYW1hem9uX2Nsb3VkdHJhaWxcbiAgICovXG4gIHJlYWRvbmx5IGNsb3VkVHJhaWxzPzogczMuQnVja2V0W10gfCB1bmRlZmluZWQ7XG5cbiAgLyoqXG4gICAqIEFkZGl0aW9uYWwgcGFyYW1ldGVycyB0byBwYXNzIHRocm91Z2ggdG8gdGhlIHVuZGVybHlpbmcgRm9yd2FyZGVyIENsb3VkRm9ybWF0aW9uXG4gICAqIHRlbXBsYXRlLiBVc2UgdGhpcyBjb25zdHJ1Y3QgaWYgeW91IG5lZWQgdG8gc3BlY2lmeSBhIHRlbXBsYXRlIHZhcmlhYmxlIG5vdFxuICAgKiB5ZXQgZXhwb3NlZCB0aHJvdWdoIHRoaXMgbGlicmFyeS5cbiAgICpcbiAgICogU2VlIGh0dHBzOi8vZGF0YWRvZy1jbG91ZGZvcm1hdGlvbi10ZW1wbGF0ZS5zMy5hbWF6b25hd3MuY29tL2F3cy9mb3J3YXJkZXIvbGF0ZXN0LnlhbWxcbiAgICogZm9yIHRoZSBsYXRlc3QgcGFyYW1ldGVycy5cbiAgICovXG4gIHJlYWRvbmx5IGFkZGl0aW9uYWxGb3J3YXJkZXJQYXJhbXM/OiB7XG4gICAgW2tleTogc3RyaW5nXTogc3RyaW5nO1xuICB9O1xuXG4gIC8qKlxuICAgKiBBZGRpdGlvbmFsIHBhcmFtZXRlcnMgdG8gcGFzcyB0aHJvdWdoIHRvIHRoZSB1bmRlcmx5aW5nIEludGVncmF0aW9uIFJvbGUgQ2xvdWRGb3JtYXRpb25cbiAgICogdGVtcGxhdGUuIFVzZSB0aGlzIGNvbnN0cnVjdCBpZiB5b3UgbmVlZCB0byBzcGVjaWZ5IGEgdGVtcGxhdGUgdmFyaWFibGUgbm90XG4gICAqIHlldCBleHBvc2VkIHRocm91Z2ggdGhpcyBsaWJyYXJ5LlxuICAgKlxuICAgKiBTZWUgaHR0cHM6Ly9kYXRhZG9nLWNsb3VkZm9ybWF0aW9uLXRlbXBsYXRlLnMzLmFtYXpvbmF3cy5jb20vYXdzL2RhdGFkb2dfaW50ZWdyYXRpb25fcm9sZS55YW1sXG4gICAqIGZvciB0aGUgbGF0ZXN0IHBhcmFtZXRlcnMuXG4gICAqL1xuICByZWFkb25seSBhZGRpdGlvbmFsSW50ZWdyYXRpb25Sb2xlUGFyYW1zPzoge1xuICAgIFtrZXk6IHN0cmluZ106IHN0cmluZztcbiAgfTtcbn1cblxuZXhwb3J0IGludGVyZmFjZSBEYXRhZG9nSW50ZWdyYXRpb25TdGFja0NvbmZpZ1xuICBleHRlbmRzIERhdGFkb2dJbnRlZ3JhdGlvbkNvbmZpZyxcbiAgICBjZGsuU3RhY2tQcm9wcyB7fVxuXG5leHBvcnQgY2xhc3MgRGF0YWRvZ0ludGVncmF0aW9uU3RhY2sgZXh0ZW5kcyBjZGsuU3RhY2sge1xuICBwcml2YXRlIERBVEFET0dfQVdTX0FDQ09VTlRfSUQgPSBcIjQ2NDYyMjUzMjAxMlwiOyAvLyBETyBOT1QgQ0hBTkdFIVxuXG4gIGNvbnN0cnVjdG9yKFxuICAgIHNjb3BlOiBjZGsuQ29uc3RydWN0LFxuICAgIGlkOiBzdHJpbmcsXG4gICAgcHJvcHM6IERhdGFkb2dJbnRlZ3JhdGlvblN0YWNrQ29uZmlnXG4gICkge1xuICAgIHN1cGVyKHNjb3BlLCBpZCwgcHJvcHMpO1xuICAgIGNvbnN0IHByb3BzV2l0aERlZmF1bHRzID0gYXBwbHlEZWZhdWx0c1RvQ29uZmlnKHByb3BzKTtcblxuICAgIGxldCBwb2xpY3lNYWNyb1N0YWNrOiBjZm4uQ2ZuU3RhY2sgfCB1bmRlZmluZWQ7XG4gICAgaWYgKHByb3BzV2l0aERlZmF1bHRzLmluc3RhbGxEYXRhZG9nUG9saWN5TWFjcm8pIHtcbiAgICAgIHBvbGljeU1hY3JvU3RhY2sgPSB0aGlzLmNyZWF0ZVBvbGljeU1hY3JvU3RhY2soKTtcbiAgICB9XG5cbiAgICB0aGlzLmNyZWF0ZUludGVncmF0aW9uUm9sZShwcm9wc1dpdGhEZWZhdWx0cywgcG9saWN5TWFjcm9TdGFjayk7XG4gICAgdGhpcy5jcmVhdGVGb3J3YXJkZXJTdGFjayhwcm9wc1dpdGhEZWZhdWx0cyk7XG4gIH1cblxuICBwcml2YXRlIGNyZWF0ZVBvbGljeU1hY3JvU3RhY2soKTogY2ZuLkNmblN0YWNrIHtcbiAgICByZXR1cm4gbmV3IGNmbi5DZm5TdGFjayh0aGlzLCBcIlBvbGljeU1hY3JvU3RhY2tcIiwge1xuICAgICAgdGVtcGxhdGVVcmw6XG4gICAgICAgIFwiaHR0cHM6Ly9kYXRhZG9nLWNsb3VkZm9ybWF0aW9uLXRlbXBsYXRlLnMzLmFtYXpvbmF3cy5jb20vYXdzL2RhdGFkb2dfcG9saWN5X21hY3JvLnlhbWxcIixcbiAgICB9KTtcbiAgfVxuXG4gIHByaXZhdGUgY3JlYXRlSW50ZWdyYXRpb25Sb2xlKFxuICAgIHByb3BzOiBEYXRhZG9nSW50ZWdyYXRpb25Db25maWdXaXRoRGVmYXVsdHMsXG4gICAgcG9saWN5TWFjcm9TdGFjaz86IGNmbi5DZm5TdGFja1xuICApOiBjZm4uQ2ZuU3RhY2sge1xuICAgIGNvbnN0IGludGVncmF0aW9uUm9sZVN0YWNrID0gbmV3IGNmbi5DZm5TdGFjayhcbiAgICAgIHRoaXMsXG4gICAgICBcIkludGVncmF0aW9uUm9sZVN0YWNrXCIsXG4gICAgICB7XG4gICAgICAgIHRlbXBsYXRlVXJsOlxuICAgICAgICAgIFwiaHR0cHM6Ly9kYXRhZG9nLWNsb3VkZm9ybWF0aW9uLXRlbXBsYXRlLnMzLmFtYXpvbmF3cy5jb20vYXdzL2RhdGFkb2dfaW50ZWdyYXRpb25fcm9sZS55YW1sXCIsXG4gICAgICAgIHBhcmFtZXRlcnM6IE9iamVjdC5hc3NpZ24oXG4gICAgICAgICAge1xuICAgICAgICAgICAgRXh0ZXJuYWxJZDogcHJvcHMuZXh0ZXJuYWxJZCxcbiAgICAgICAgICAgIFBlcm1pc3Npb25zOiBwcm9wcy5wZXJtaXNzaW9ucy50b1N0cmluZygpLFxuICAgICAgICAgICAgSUFNUm9sZU5hbWU6IHByb3BzLmlhbVJvbGVOYW1lLFxuICAgICAgICAgICAgTG9nQXJjaGl2ZXM6IGJ1Y2tldHNUb1N0cmluZyhwcm9wcy5sb2dBcmNoaXZlcyksXG4gICAgICAgICAgICBDbG91ZFRyYWlsczogYnVja2V0c1RvU3RyaW5nKHByb3BzLmNsb3VkVHJhaWxzKSxcbiAgICAgICAgICAgIERkQVdTQWNjb3VudElkOiB0aGlzLkRBVEFET0dfQVdTX0FDQ09VTlRfSUQsXG4gICAgICAgICAgfSxcbiAgICAgICAgICB7IC4uLnByb3BzLmFkZGl0aW9uYWxJbnRlZ3JhdGlvblJvbGVQYXJhbXMgfVxuICAgICAgICApLFxuICAgICAgfVxuICAgICk7XG5cbiAgICBpZiAocG9saWN5TWFjcm9TdGFjaykge1xuICAgICAgaW50ZWdyYXRpb25Sb2xlU3RhY2suYWRkRGVwZW5kc09uKHBvbGljeU1hY3JvU3RhY2spO1xuICAgIH1cblxuICAgIHJldHVybiBpbnRlZ3JhdGlvblJvbGVTdGFjaztcbiAgfVxuXG4gIHByaXZhdGUgY3JlYXRlRm9yd2FyZGVyU3RhY2soXG4gICAgcHJvcHM6IERhdGFkb2dJbnRlZ3JhdGlvbkNvbmZpZ1dpdGhEZWZhdWx0c1xuICApOiBjZm4uQ2ZuU3RhY2sge1xuICAgIHJldHVybiBuZXcgY2ZuLkNmblN0YWNrKHRoaXMsIFwiRm9yd2FyZGVyU3RhY2tcIiwge1xuICAgICAgdGVtcGxhdGVVcmw6IGBodHRwczovL2RhdGFkb2ctY2xvdWRmb3JtYXRpb24tdGVtcGxhdGUuczMuYW1hem9uYXdzLmNvbS9hd3MvZm9yd2FyZGVyLyR7cHJvcHMuZm9yd2FyZGVyVmVyc2lvbn0ueWFtbGAsXG4gICAgICBwYXJhbWV0ZXJzOiBPYmplY3QuYXNzaWduKFxuICAgICAgICB7XG4gICAgICAgICAgRGRBcGlLZXk6IFwiVVNFX0FSTlwiLFxuICAgICAgICAgIERkQXBpS2V5U2VjcmV0QXJuOiBwcm9wcy5hcGlLZXkuc2VjcmV0QXJuLFxuICAgICAgICAgIERkU2l0ZTogcHJvcHMuc2l0ZSxcbiAgICAgICAgICBGdW5jdGlvbk5hbWU6IHByb3BzLmZvcndhcmRlck5hbWUsXG4gICAgICAgIH0sXG4gICAgICAgIHsgLi4ucHJvcHMuYWRkaXRpb25hbEZvcndhcmRlclBhcmFtcyB9XG4gICAgICApLFxuICAgIH0pO1xuICB9XG59XG4iXX0=