import tkinter as tk
from tkinter import ttk
import webbrowser

from biostats.datasets import dataset

class Example(ttk.Menubutton):

    def __init__(self, parent, master, text, width):
        
        # Initialize
        ttk.Menubutton.__init__(self, parent, text=text, width=width)
        self.master = master

        # Variable
        self.test_type = ["Basic", "t-Test", "ANOVA", "Exact Test", "Chi-Square Test", "Linear Regression", "Logistic Regression", "Nonparametric", "Others"]
        self.test_list = {
            "Basic"               : ["Numeric", "Numeric (Grouped)", "Categorical", "Contingency"] ,
            "t-Test"              : ["One-Sample t-Test", "Two-Sample t-Test", "Paired t-Test", "Pairwise t-Test"] ,
            "ANOVA"               : ["One-Way ANOVA", "Two-Way ANOVA", "One-Way ANCOVA", "Two-Way ANCOVA", "Multivariate ANOVA", "Repeated Measures ANOVA"] ,
            "Exact Test"          : ["Binomial Test", "Fisher's Exact Test", "McNemar's Exact Test"] ,
            "Chi-Square Test"     : ["Chi-Square Test", "Chi-Square Test (Fit)", "McNemar's Test", "Mantel-Haenszel Test"] ,
            "Linear Regression"   : ["Correlation", "Correlation Matrix", "Simple Linear Regression", "Multiple Linear Regression"] ,
            "Logistic Regression" : ["Simple Logistic Regression", "Multiple Logistic Regression", "Ordered Logistic Regression", "Multinomial Logistic Regression"] ,
            "Nonparametric"       : ["Median Test", "Sign Test", "Wilcoxon Signed-Rank Test", "Wilcoxon Rank-Sum Test", "Kruskal-Wallis Test", "Friedman Test", "Spearman's Rank Correlation"] ,
            "Others"              : ["Screening Test", "Epidemiologic Study", "Factor Analysis", "Principal Component Analysis", "Linear Discriminant Analysis"]
        }
        self.plot_type = ["Distribution", "Categorical", "Relational", "Multiple", "Others"]
        self.plot_list = {
            "Distribution" : ["Histogram", "Density Plot", "Cumulative Plot", "2D Histogram", "2D Density Plot"],
            "Categorical"  : ["Count Plot", "Strip Plot", "Swarm Plot", "Box Plot", "Boxen Plot", "Violin Plot", "Bar Plot"],
            "Relational"   : ["Scatter Plot", "Line Plot", "Regression Plot"],
            "Multiple"     : ["Ultimate Plot", "Pair Plot", "Joint Plot"],
            "Others"       : ["Heatmap", "FA Plot", "PCA Plot", "LDA Plot"]
        }

        # Setup
        self.setup()

    def setup(self):

        self.menu_0 = tk.Menu(self)
        self.config(menu=self.menu_0)

        self.menu_1 = {}
        self.which = tk.StringVar()

        for test_1 in self.test_type:
            self.menu_1[test_1] = tk.Menu(self.menu_0)
            self.menu_0.add_cascade(label=test_1, menu=self.menu_1[test_1])
            for test_2 in self.test_list[test_1]:
                self.menu_1[test_1].add_radiobutton(label=test_2, value=test_2, variable=self.which, command=self.change)
        
        self.menu_0.add_separator()

        for plot_1 in self.plot_type:
            self.menu_1[plot_1] = tk.Menu(self.menu_0)
            self.menu_0.add_cascade(label=plot_1, menu=self.menu_1[plot_1])
            for plot_2 in self.plot_list[plot_1]:
                self.menu_1[plot_1].add_radiobutton(label=plot_2, value=plot_2, variable=self.which, command=self.change)

    def change(self):

        which = self.which.get()

        if which == "Numeric":
            self.master.data_win.data_process(dataset("numeric.csv"))
            self.master.window.set(1)
            self.master.switch()
            self.master.test_win.test_1.set("Basic")
            self.master.test_win.test_2["Basic"].set("Numeric")
            self.master.test_win.test_change()
            self.master.test_win.option[0].check_more_var[0].set(1)
            self.master.test_win.option[0].check_more_var[1].set(1)
            self.master.test_win.option[0].check_more_var[2].set(1)
            self.master.test_win.change()
        
        if which == "Numeric (Grouped)":
            self.master.data_win.data_process(dataset("numeric_grouped.csv"))
            self.master.window.set(1)
            self.master.switch()
            self.master.test_win.test_1.set("Basic")
            self.master.test_win.test_2["Basic"].set("Numeric (Grouped)")
            self.master.test_win.test_change()
            self.master.test_win.option[0].radio_one_var.set(0)
            self.master.test_win.change()
            self.master.test_win.option[1].radio_one_var.set(1)
            self.master.test_win.change()

        if which == "Categorical":
            self.master.data_win.data_process(dataset("categorical.csv"))
            self.master.window.set(1)
            self.master.switch()
            self.master.test_win.test_1.set("Basic")
            self.master.test_win.test_2["Basic"].set("Categorical")
            self.master.test_win.test_change()
            self.master.test_win.option[0].radio_one_var.set(0)
            self.master.test_win.change()
        
        if which == "Contingency":
            self.master.data_win.data_process(dataset("contingency.csv"))
            self.master.window.set(1)
            self.master.switch()
            self.master.test_win.test_1.set("Basic")
            self.master.test_win.test_2["Basic"].set("Contingency")
            self.master.test_win.test_change()
            self.master.test_win.option[0].radio_one_var.set(0)
            self.master.test_win.change()
            self.master.test_win.option[1].radio_one_var.set(1)
            self.master.test_win.change()
            self.master.test_win.option[2].radio_one_var.set(0)
            self.master.test_win.change()

        if which == "One-Sample t-Test":
            self.master.data_win.data_process(dataset("one_sample_t_test.csv"))
            self.master.window.set(1)
            self.master.switch()
            self.master.test_win.test_1.set("t-Test")
            self.master.test_win.test_2["t-Test"].set("One-Sample t-Test")
            self.master.test_win.test_change()
            self.master.test_win.option[0].radio_one_var.set(0)
            self.master.test_win.change()
            self.master.test_win.option[1].entry_one_var.set(120)
            self.master.test_win.change()
            self.master.test_win.option[2].radio_one_var.set(0)
            self.master.test_win.change()

        if which == "Two-Sample t-Test":
            self.master.data_win.data_process(dataset("two_sample_t_test.csv"))
            self.master.window.set(1)
            self.master.switch()
            self.master.test_win.test_1.set("t-Test")
            self.master.test_win.test_2["t-Test"].set("Two-Sample t-Test")
            self.master.test_win.test_change()
            self.master.test_win.option[0].radio_one_var.set(0)
            self.master.test_win.change()
            self.master.test_win.option[1].radio_one_var.set(1)
            self.master.test_win.change()
            self.master.test_win.option[2].check_two_var[0].set(1)
            self.master.test_win.option[2].check_two_command()
            self.master.test_win.option[2].check_two_var[1].set(1)
            self.master.test_win.option[2].check_two_command()
            self.master.test_win.change()
            self.master.test_win.option[3].radio_one_var.set(0)
            self.master.test_win.change()

        if which == "Paired t-Test":
            self.master.data_win.data_process(dataset("paired_t_test.csv"))
            self.master.window.set(1)
            self.master.switch()
            self.master.test_win.test_1.set("t-Test")
            self.master.test_win.test_2["t-Test"].set("Paired t-Test")
            self.master.test_win.test_change()
            self.master.test_win.option[0].radio_one_var.set(0)
            self.master.test_win.change()
            self.master.test_win.option[1].radio_one_var.set(0)
            self.master.test_win.change()
            self.master.test_win.option[2].check_two_var[0].set(1)
            self.master.test_win.option[2].check_two_command()
            self.master.test_win.option[2].check_two_var[1].set(1)
            self.master.test_win.option[2].check_two_command()
            self.master.test_win.change()
            self.master.test_win.option[3].radio_one_var.set(1)
            self.master.test_win.change()

        if which == "Pairwise t-Test":
            self.master.data_win.data_process(dataset("pairwise_t_test.csv"))
            self.master.window.set(1)
            self.master.switch()
            self.master.test_win.test_1.set("t-Test")
            self.master.test_win.test_2["t-Test"].set("Pairwise t-Test")
            self.master.test_win.test_change()
            self.master.test_win.option[0].radio_one_var.set(0)
            self.master.test_win.change()
            self.master.test_win.option[1].radio_one_var.set(0)
            self.master.test_win.change()

        if which == "One-Way ANOVA":
            self.master.data_win.data_process(dataset("one_way_anova.csv"))
            self.master.window.set(1)
            self.master.switch()
            self.master.test_win.test_1.set("ANOVA")
            self.master.test_win.test_2["ANOVA"].set("One-Way ANOVA")
            self.master.test_win.test_change()
            self.master.test_win.option[0].radio_one_var.set(0)
            self.master.test_win.change()
            self.master.test_win.option[1].radio_one_var.set(0)
            self.master.test_win.change()

        if which == "Two-Way ANOVA":
            self.master.data_win.data_process(dataset("two_way_anova.csv"))
            self.master.window.set(1)
            self.master.switch()
            self.master.test_win.test_1.set("ANOVA")
            self.master.test_win.test_2["ANOVA"].set("Two-Way ANOVA")
            self.master.test_win.test_change()
            self.master.test_win.option[0].radio_one_var.set(0)
            self.master.test_win.change()
            self.master.test_win.option[1].radio_one_var.set(0)
            self.master.test_win.change()
            self.master.test_win.option[2].radio_one_var.set(1)
            self.master.test_win.change()

        if which == "One-Way ANCOVA":
            self.master.data_win.data_process(dataset("one_way_ancova.csv"))
            self.master.window.set(1)
            self.master.switch()
            self.master.test_win.test_1.set("ANOVA")
            self.master.test_win.test_2["ANOVA"].set("One-Way ANCOVA")
            self.master.test_win.test_change()
            self.master.test_win.option[0].radio_one_var.set(0)
            self.master.test_win.change()
            self.master.test_win.option[1].radio_one_var.set(0)
            self.master.test_win.change()
            self.master.test_win.option[2].radio_one_var.set(1)
            self.master.test_win.change()

        if which == "Two-Way ANCOVA":
            self.master.data_win.data_process(dataset("two_way_ancova.csv"))
            self.master.window.set(1)
            self.master.switch()
            self.master.test_win.test_1.set("ANOVA")
            self.master.test_win.test_2["ANOVA"].set("Two-Way ANCOVA")
            self.master.test_win.test_change()
            self.master.test_win.option[0].radio_one_var.set(0)
            self.master.test_win.change()
            self.master.test_win.option[1].radio_one_var.set(0)
            self.master.test_win.change()
            self.master.test_win.option[2].radio_one_var.set(1)
            self.master.test_win.change()
            self.master.test_win.option[3].radio_one_var.set(1)
            self.master.test_win.change()

        if which == "Multivariate ANOVA":
            self.master.data_win.data_process(dataset("multivariate_anova.csv"))
            self.master.window.set(1)
            self.master.switch()
            self.master.test_win.test_1.set("ANOVA")
            self.master.test_win.test_2["ANOVA"].set("Multivariate ANOVA")
            self.master.test_win.test_change()
            self.master.test_win.option[0].check_more_var[0].set(1)
            self.master.test_win.option[0].check_more_var[1].set(1)
            self.master.test_win.change()
            self.master.test_win.option[1].radio_one_var.set(0)
            self.master.test_win.change()

        if which == "Repeated Measures ANOVA":
            self.master.data_win.data_process(dataset("repeated_measures_anova.csv"))
            self.master.window.set(1)
            self.master.switch()
            self.master.test_win.test_1.set("ANOVA")
            self.master.test_win.test_2["ANOVA"].set("Repeated Measures ANOVA")
            self.master.test_win.test_change()
            self.master.test_win.option[0].radio_one_var.set(0)
            self.master.test_win.change()
            self.master.test_win.option[1].radio_one_var.set(1)
            self.master.test_win.change()
            self.master.test_win.option[2].radio_one_var.set(2)
            self.master.test_win.change()     

        if which == "Binomial Test":
            self.master.data_win.data_process(dataset("binomial_test.csv"))
            self.master.window.set(1)
            self.master.switch()
            self.master.test_win.test_1.set("Exact Test")
            self.master.test_win.test_2["Exact Test"].set("Binomial Test")
            self.master.test_win.test_change()
            self.master.test_win.option[0].radio_one_var.set(0)
            self.master.test_win.change()
            self.master.test_win.option[1].entry_more_var[0].set(9)
            self.master.test_win.option[1].entry_more_var[1].set(3)
            self.master.test_win.option[1].entry_more_var[2].set(3)
            self.master.test_win.option[1].entry_more_var[3].set(1)
            self.master.test_win.change()

        if which == "Fisher's Exact Test":
            self.master.data_win.data_process(dataset("fisher_exact_test.csv"))
            self.master.window.set(1)
            self.master.switch()
            self.master.test_win.test_1.set("Exact Test")
            self.master.test_win.test_2["Exact Test"].set("Fisher's Exact Test")
            self.master.test_win.test_change()
            self.master.test_win.option[0].radio_one_var.set(0)
            self.master.test_win.change()
            self.master.test_win.option[1].radio_one_var.set(1)
            self.master.test_win.change()
            self.master.test_win.option[2].radio_one_var.set(2)
            self.master.test_win.change()

        if which == "McNemar's Exact Test":
            self.master.data_win.data_process(dataset("mcnemar_exact_test.csv"))
            self.master.window.set(1)
            self.master.switch()
            self.master.test_win.test_1.set("Exact Test")
            self.master.test_win.test_2["Exact Test"].set("McNemar's Exact Test")
            self.master.test_win.test_change()
            self.master.test_win.option[0].radio_one_var.set(0)
            self.master.test_win.change()
            self.master.test_win.option[1].radio_one_var.set(1)
            self.master.test_win.change()
            self.master.test_win.option[2].radio_one_var.set(2)
            self.master.test_win.change()

        if which == "Chi-Square Test":
            self.master.data_win.data_process(dataset("chi_square_test.csv"))
            self.master.window.set(1)
            self.master.switch()
            self.master.test_win.test_1.set("Chi-Square Test")
            self.master.test_win.test_2["Chi-Square Test"].set("Chi-Square Test")
            self.master.test_win.test_change()
            self.master.test_win.option[0].radio_one_var.set(0)
            self.master.test_win.change()
            self.master.test_win.option[1].radio_one_var.set(1)
            self.master.test_win.change()
            self.master.test_win.option[2].radio_one_var.set(2)
            self.master.test_win.change()

        if which == "Chi-Square Test (Fit)":
            self.master.data_win.data_process(dataset("chi_square_test_fit.csv"))
            self.master.window.set(1)
            self.master.switch()
            self.master.test_win.test_1.set("Chi-Square Test")
            self.master.test_win.test_2["Chi-Square Test"].set("Chi-Square Test (Fit)")
            self.master.test_win.test_change()
            self.master.test_win.option[0].radio_one_var.set(0)
            self.master.test_win.change()
            self.master.test_win.option[1].entry_more_var[0].set(0.54)
            self.master.test_win.option[1].entry_more_var[1].set(0.40)
            self.master.test_win.option[1].entry_more_var[2].set(0.01)
            self.master.test_win.option[1].entry_more_var[3].set(0.05)
            self.master.test_win.change()

        if which == "McNemar's Test":
            self.master.data_win.data_process(dataset("mcnemar_test.csv"))
            self.master.window.set(1)
            self.master.switch()
            self.master.test_win.test_1.set("Chi-Square Test")
            self.master.test_win.test_2["Chi-Square Test"].set("McNemar's Test")
            self.master.test_win.test_change()
            self.master.test_win.option[0].radio_one_var.set(0)
            self.master.test_win.change()
            self.master.test_win.option[1].radio_one_var.set(1)
            self.master.test_win.change()
            self.master.test_win.option[2].radio_one_var.set(2)
            self.master.test_win.change()

        if which == "Mantel-Haenszel Test":
            self.master.data_win.data_process(dataset("mantel_haenszel_test.csv"))
            self.master.window.set(1)
            self.master.switch()
            self.master.test_win.test_1.set("Chi-Square Test")
            self.master.test_win.test_2["Chi-Square Test"].set("Mantel-Haenszel Test")
            self.master.test_win.test_change()
            self.master.test_win.option[0].radio_one_var.set(0)
            self.master.test_win.change()
            self.master.test_win.option[1].radio_one_var.set(1)
            self.master.test_win.change()
            self.master.test_win.option[2].radio_one_var.set(2)
            self.master.test_win.change()

        if which == "Correlation":
            self.master.data_win.data_process(dataset("correlation.csv"))
            self.master.window.set(1)
            self.master.switch()
            self.master.test_win.test_1.set("Linear Regression")
            self.master.test_win.test_2["Linear Regression"].set("Correlation")
            self.master.test_win.test_change()
            self.master.test_win.option[0].radio_one_var.set(0)
            self.master.test_win.change()
            self.master.test_win.option[1].radio_one_var.set(1)
            self.master.test_win.change()

        if which == "Correlation Matrix":
            self.master.data_win.data_process(dataset("correlation_matrix.csv"))
            self.master.window.set(1)
            self.master.switch()
            self.master.test_win.test_1.set("Linear Regression")
            self.master.test_win.test_2["Linear Regression"].set("Correlation Matrix")
            self.master.test_win.test_change()
            for i in range(7):
                self.master.test_win.option[0].check_more_var[i].set(1)
            self.master.test_win.change()

        if which == "Simple Linear Regression":
            self.master.data_win.data_process(dataset("simple_linear_regression.csv"))
            self.master.window.set(1)
            self.master.switch()
            self.master.test_win.test_1.set("Linear Regression")
            self.master.test_win.test_2["Linear Regression"].set("Simple Linear Regression")
            self.master.test_win.test_change()
            self.master.test_win.option[0].radio_one_var.set(0)
            self.master.test_win.change()
            self.master.test_win.option[1].radio_one_var.set(1)
            self.master.test_win.change()

        if which == "Multiple Linear Regression":
            self.master.data_win.data_process(dataset("multiple_linear_regression.csv"))
            self.master.window.set(1)
            self.master.switch()
            self.master.test_win.test_1.set("Linear Regression")
            self.master.test_win.test_2["Linear Regression"].set("Multiple Linear Regression")
            self.master.test_win.test_change()
            self.master.test_win.option[0].check_more_var[0].set(1)
            self.master.test_win.option[0].check_more_var[1].set(1)
            self.master.test_win.option[0].check_more_var[2].set(1)
            self.master.test_win.change()
            self.master.test_win.option[2].radio_one_var.set(3)
            self.master.test_win.change()

        if which == "Simple Logistic Regression":
            self.master.data_win.data_process(dataset("simple_logistic_regression.csv"))
            self.master.window.set(1)
            self.master.switch()
            self.master.test_win.test_1.set("Logistic Regression")
            self.master.test_win.test_2["Logistic Regression"].set("Simple Logistic Regression")
            self.master.test_win.test_change()
            self.master.test_win.option[0].radio_one_var.set(0)
            self.master.test_win.change()
            self.master.test_win.option[1].radio_one_var.set(0)
            self.master.test_win.change()
            self.master.test_win.option[2].radio_one_var.set(1)
            self.master.test_win.change()

        if which == "Multiple Logistic Regression":
            self.master.data_win.data_process(dataset("multiple_logistic_regression.csv"))
            self.master.window.set(1)
            self.master.switch()
            self.master.test_win.test_1.set("Logistic Regression")
            self.master.test_win.test_2["Logistic Regression"].set("Multiple Logistic Regression")
            self.master.test_win.test_change()
            for i in range(6):
                self.master.test_win.option[0].check_more_var[i].set(1)
            self.master.test_win.change()
            self.master.test_win.option[2].radio_one_var.set(5)
            self.master.test_win.change()
            self.master.test_win.option[3].radio_one_var.set(0)
            self.master.test_win.change()

        if which == "Ordered Logistic Regression":
            self.master.data_win.data_process(dataset("ordered_logistic_regression.csv"))
            self.master.window.set(1)
            self.master.switch()
            self.master.test_win.test_1.set("Logistic Regression")
            self.master.test_win.test_2["Logistic Regression"].set("Ordered Logistic Regression")
            self.master.test_win.test_change()
            self.master.test_win.option[0].check_more_var[0].set(1)
            self.master.test_win.option[0].check_more_var[1].set(1)
            self.master.test_win.option[0].check_more_var[2].set(1)
            self.master.test_win.change()
            self.master.test_win.option[2].radio_one_var.set(2)
            self.master.test_win.change()
            self.master.test_win.option[3].entry_more_var[0].set(3)
            self.master.test_win.option[3].entry_more_var[1].set(2)
            self.master.test_win.option[3].entry_more_var[2].set(1)
            self.master.test_win.change()

        if which == "Multinomial Logistic Regression":
            self.master.data_win.data_process(dataset("multinomial_logistic_regression.csv"))
            self.master.window.set(1)
            self.master.switch()
            self.master.test_win.test_1.set("Logistic Regression")
            self.master.test_win.test_2["Logistic Regression"].set("Multinomial Logistic Regression")
            self.master.test_win.test_change()
            self.master.test_win.option[0].check_more_var[0].set(1)
            self.master.test_win.change()
            self.master.test_win.option[1].check_more_var[1].set(1)
            self.master.test_win.change()
            self.master.test_win.option[2].radio_one_var.set(2)
            self.master.test_win.change()
            self.master.test_win.option[3].radio_one_var.set(2) 
            self.master.test_win.change()

        if which == "Median Test":
            self.master.data_win.data_process(dataset("median_test.csv"))
            self.master.window.set(1)
            self.master.switch()
            self.master.test_win.test_1.set("Nonparametric")
            self.master.test_win.test_2["Nonparametric"].set("Median Test")
            self.master.test_win.test_change()
            self.master.test_win.option[0].radio_one_var.set(0)
            self.master.test_win.change()
            self.master.test_win.option[1].entry_one_var.set(3)
            self.master.test_win.change()

        if which == "Sign Test":
            self.master.data_win.data_process(dataset("sign_test.csv"))
            self.master.window.set(1)
            self.master.switch()
            self.master.test_win.test_1.set("Nonparametric")
            self.master.test_win.test_2["Nonparametric"].set("Sign Test")
            self.master.test_win.test_change()
            self.master.test_win.option[0].radio_one_var.set(0)
            self.master.test_win.change()
            self.master.test_win.option[1].radio_one_var.set(0)
            self.master.test_win.change()
            self.master.test_win.option[2].check_two_var[0].set(1)
            self.master.test_win.option[2].check_two_command()
            self.master.test_win.option[2].check_two_var[1].set(1)
            self.master.test_win.option[2].check_two_command()
            self.master.test_win.change()
            self.master.test_win.option[3].radio_one_var.set(1)
            self.master.test_win.change()

        if which == "Wilcoxon Signed-Rank Test":
            self.master.data_win.data_process(dataset("wilcoxon_signed_rank_test.csv"))
            self.master.window.set(1)
            self.master.switch()
            self.master.test_win.test_1.set("Nonparametric")
            self.master.test_win.test_2["Nonparametric"].set("Wilcoxon Signed-Rank Test")
            self.master.test_win.test_change()
            self.master.test_win.option[0].radio_one_var.set(0)
            self.master.test_win.change()
            self.master.test_win.option[1].radio_one_var.set(0)
            self.master.test_win.change()
            self.master.test_win.option[2].check_two_var[0].set(1)
            self.master.test_win.option[2].check_two_command()
            self.master.test_win.option[2].check_two_var[1].set(1)
            self.master.test_win.option[2].check_two_command()
            self.master.test_win.change()
            self.master.test_win.option[3].radio_one_var.set(1)
            self.master.test_win.change()

        if which == "Wilcoxon Rank-Sum Test":
            self.master.data_win.data_process(dataset("wilcoxon_rank_sum_test.csv"))
            self.master.window.set(1)
            self.master.switch()
            self.master.test_win.test_1.set("Nonparametric")
            self.master.test_win.test_2["Nonparametric"].set("Wilcoxon Rank-Sum Test")
            self.master.test_win.test_change()
            self.master.test_win.option[0].radio_one_var.set(0)
            self.master.test_win.change()
            self.master.test_win.option[1].radio_one_var.set(1)
            self.master.test_win.change()
            self.master.test_win.option[2].check_two_var[0].set(1)
            self.master.test_win.option[2].check_two_command()
            self.master.test_win.option[2].check_two_var[1].set(1)
            self.master.test_win.option[2].check_two_command()
            self.master.test_win.change()

        if which == "Kruskal-Wallis Test":
            self.master.data_win.data_process(dataset("kruskal_wallis_test.csv"))
            self.master.window.set(1)
            self.master.switch()
            self.master.test_win.test_1.set("Nonparametric")
            self.master.test_win.test_2["Nonparametric"].set("Kruskal-Wallis Test")
            self.master.test_win.test_change()
            self.master.test_win.option[0].radio_one_var.set(0)
            self.master.test_win.change()
            self.master.test_win.option[1].radio_one_var.set(1)
            self.master.test_win.change()

        if which == "Friedman Test":
            self.master.data_win.data_process(dataset("friedman_test.csv"))
            self.master.window.set(1)
            self.master.switch()
            self.master.test_win.test_1.set("Nonparametric")
            self.master.test_win.test_2["Nonparametric"].set("Friedman Test")
            self.master.test_win.test_change()
            self.master.test_win.option[0].radio_one_var.set(0)
            self.master.test_win.change()
            self.master.test_win.option[1].radio_one_var.set(1)
            self.master.test_win.change()
            self.master.test_win.option[2].radio_one_var.set(2)
            self.master.test_win.change()

        if which == "Spearman's Rank Correlation":
            self.master.data_win.data_process(dataset("spearman_rank_correlation.csv"))
            self.master.window.set(1)
            self.master.switch()
            self.master.test_win.test_1.set("Nonparametric")
            self.master.test_win.test_2["Nonparametric"].set("Spearman's Rank Correlation")
            self.master.test_win.test_change()
            self.master.test_win.option[0].radio_one_var.set(0)
            self.master.test_win.change()
            self.master.test_win.option[1].radio_one_var.set(1)
            self.master.test_win.change()

        if which == "Screening Test":
            self.master.data_win.data_process(dataset("screening_test.csv"))
            self.master.window.set(1)
            self.master.switch()
            self.master.test_win.test_1.set("Others")
            self.master.test_win.test_2["Others"].set("Screening Test")
            self.master.test_win.test_change()
            self.master.test_win.option[0].radio_one_var.set(0)
            self.master.test_win.change()
            self.master.test_win.option[1].radio_one_var.set(0)
            self.master.test_win.change()
            self.master.test_win.option[2].radio_one_var.set(1)
            self.master.test_win.change()
            self.master.test_win.option[3].radio_one_var.set(1)
            self.master.test_win.change()

        if which == "Epidemiologic Study":
            self.master.data_win.data_process(dataset("epidemiologic_study.csv"))
            self.master.window.set(1)
            self.master.switch()
            self.master.test_win.test_1.set("Others")
            self.master.test_win.test_2["Others"].set("Epidemiologic Study")
            self.master.test_win.test_change()
            self.master.test_win.option[0].radio_one_var.set(0)
            self.master.test_win.change()
            self.master.test_win.option[1].radio_one_var.set(1)
            self.master.test_win.change()
            self.master.test_win.option[2].radio_one_var.set(1)
            self.master.test_win.change()
            self.master.test_win.option[3].radio_one_var.set(1)
            self.master.test_win.change()

        if which == "Factor Analysis":
            self.master.data_win.data_process(dataset("factor_analysis.csv"))
            self.master.window.set(1)
            self.master.switch()
            self.master.test_win.test_1.set("Others")
            self.master.test_win.test_2["Others"].set("Factor Analysis")
            self.master.test_win.test_change()
            for i in range(5):
                self.master.test_win.option[0].check_more_var[i].set(1)
            self.master.test_win.change()
            self.master.test_win.option[1].radio_one_var.set(1)
            self.master.test_win.change()
            self.master.test_win.option[2].entry_more_var[0].set(17.2)
            self.master.test_win.option[2].entry_more_var[1].set(2830)
            self.master.test_win.option[2].entry_more_var[2].set(12)
            self.master.test_win.option[2].entry_more_var[3].set(19)
            self.master.test_win.option[2].entry_more_var[4].set(121)
            self.master.test_win.change()

        if which == "Principal Component Analysis":
            self.master.data_win.data_process(dataset("principal_component_analysis.csv"))
            self.master.window.set(1)
            self.master.switch()
            self.master.test_win.test_1.set("Others")
            self.master.test_win.test_2["Others"].set("Principal Component Analysis")
            self.master.test_win.test_change()
            for i in range(4):
                self.master.test_win.option[0].check_more_var[i].set(1)
            self.master.test_win.change()
            self.master.test_win.option[1].entry_more_var[0].set(10.2)
            self.master.test_win.option[1].entry_more_var[1].set(211)
            self.master.test_win.option[1].entry_more_var[2].set(67)
            self.master.test_win.option[1].entry_more_var[3].set(32.3)
            self.master.test_win.change()

        if which == "Linear Discriminant Analysis":
            self.master.data_win.data_process(dataset("linear_discriminant_analysis.csv"))
            self.master.window.set(1)
            self.master.switch()
            self.master.test_win.test_1.set("Others")
            self.master.test_win.test_2["Others"].set("Linear Discriminant Analysis")
            self.master.test_win.test_change()
            for i in range(4):
                self.master.test_win.option[0].check_more_var[i].set(1)
            self.master.test_win.change()
            self.master.test_win.option[1].radio_one_var.set(0)
            self.master.test_win.change()
            self.master.test_win.option[2].entry_more_var[0].set(5.7)
            self.master.test_win.option[2].entry_more_var[1].set(2.7)
            self.master.test_win.option[2].entry_more_var[2].set(4.0)
            self.master.test_win.option[2].entry_more_var[3].set(1.4)
            self.master.test_win.change()

        if which == "Histogram":
            self.master.data_win.data_process(dataset("penguins.csv"))
            self.master.window.set(2)
            self.master.switch()
            self.master.plot_win.plot_1.set("Distribution")
            self.master.plot_win.plot_2["Distribution"].set("Histogram")
            self.master.plot_win.plot_change()
            self.master.plot_win.option[0].radio_one_var.set(2)
            self.master.plot_win.change()
            self.master.plot_win.option[1].spin_one_var.set(10)
            self.master.plot_win.option[1].spin_one_command()
            self.master.plot_win.change()
            self.master.plot_win.option[2].radio_one_var.set(1)
            self.master.plot_win.change()

        if which == "Density Plot":
            self.master.data_win.data_process(dataset("penguins.csv"))
            self.master.window.set(2)
            self.master.switch()
            self.master.plot_win.plot_1.set("Distribution")
            self.master.plot_win.plot_2["Distribution"].set("Density Plot")
            self.master.plot_win.plot_change()
            self.master.plot_win.option[0].radio_one_var.set(2)
            self.master.plot_win.change()
            self.master.plot_win.option[1].entry_one_var.set(1)
            self.master.plot_win.change()
            self.master.plot_win.option[2].radio_one_var.set(1)
            self.master.plot_win.change()

        if which == "Cumulative Plot":
            self.master.data_win.data_process(dataset("penguins.csv"))
            self.master.window.set(2)
            self.master.switch()
            self.master.plot_win.plot_1.set("Distribution")
            self.master.plot_win.plot_2["Distribution"].set("Cumulative Plot")
            self.master.plot_win.plot_change()
            self.master.plot_win.option[0].radio_one_var.set(0)
            self.master.plot_win.change()
            self.master.plot_win.option[1].radio_one_var.set(1)
            self.master.plot_win.change()

        if which == "2D Histogram":
            self.master.data_win.data_process(dataset("penguins.csv"))
            self.master.window.set(2)
            self.master.switch()
            self.master.plot_win.plot_1.set("Distribution")
            self.master.plot_win.plot_2["Distribution"].set("2D Histogram")
            self.master.plot_win.plot_change()
            self.master.plot_win.option[0].radio_one_var.set(1)
            self.master.plot_win.change()
            self.master.plot_win.option[1].radio_one_var.set(3)
            self.master.plot_win.change()
            self.master.plot_win.option[2].radio_one_var.set(1)
            self.master.plot_win.change()

        if which == "2D Density Plot":
            self.master.data_win.data_process(dataset("penguins.csv"))
            self.master.window.set(2)
            self.master.switch()
            self.master.plot_win.plot_1.set("Distribution")
            self.master.plot_win.plot_2["Distribution"].set("2D Density Plot")
            self.master.plot_win.plot_change()
            self.master.plot_win.option[0].radio_one_var.set(1)
            self.master.plot_win.change()
            self.master.plot_win.option[1].radio_one_var.set(3)
            self.master.plot_win.change()
            self.master.plot_win.option[2].radio_one_var.set(1)
            self.master.plot_win.change()

        if which == "Count Plot":
            self.master.data_win.data_process(dataset("titanic.csv"))
            self.master.window.set(2)
            self.master.switch()
            self.master.plot_win.plot_1.set("Categorical")
            self.master.plot_win.plot_2["Categorical"].set("Count Plot")
            self.master.plot_win.plot_change()
            self.master.plot_win.option[0].radio_one_var.set(9)
            self.master.plot_win.change()
            self.master.plot_win.option[1].radio_one_var.set(0)
            self.master.plot_win.change()

        if which == "Strip Plot":
            self.master.data_win.data_process(dataset("tips.csv"))
            self.master.window.set(2)
            self.master.switch()
            self.master.plot_win.plot_1.set("Categorical")
            self.master.plot_win.plot_2["Categorical"].set("Strip Plot")
            self.master.plot_win.plot_change()
            self.master.plot_win.option[0].radio_one_var.set(2)
            self.master.plot_win.change()
            self.master.plot_win.option[1].radio_one_var.set(0)
            self.master.plot_win.change()
            self.master.plot_win.option[2].radio_one_var.set(0)
            self.master.plot_win.change()

        if which == "Swarm Plot":
            self.master.data_win.data_process(dataset("tips.csv"))
            self.master.window.set(2)
            self.master.switch()
            self.master.plot_win.plot_1.set("Categorical")
            self.master.plot_win.plot_2["Categorical"].set("Swarm Plot")
            self.master.plot_win.plot_change()
            self.master.plot_win.option[0].radio_one_var.set(2)
            self.master.plot_win.change()
            self.master.plot_win.option[1].radio_one_var.set(0)
            self.master.plot_win.change()
            self.master.plot_win.option[2].radio_one_var.set(0)
            self.master.plot_win.change()

        if which == "Box Plot":
            self.master.data_win.data_process(dataset("tips.csv"))
            self.master.window.set(2)
            self.master.switch()
            self.master.plot_win.plot_1.set("Categorical")
            self.master.plot_win.plot_2["Categorical"].set("Box Plot")
            self.master.plot_win.plot_change()
            self.master.plot_win.option[0].radio_one_var.set(2)
            self.master.plot_win.change()
            self.master.plot_win.option[1].radio_one_var.set(0)
            self.master.plot_win.change()
            self.master.plot_win.option[2].radio_one_var.set(0)
            self.master.plot_win.change()

        if which == "Boxen Plot":
            self.master.data_win.data_process(dataset("tips.csv"))
            self.master.window.set(2)
            self.master.switch()
            self.master.plot_win.plot_1.set("Categorical")
            self.master.plot_win.plot_2["Categorical"].set("Boxen Plot")
            self.master.plot_win.plot_change()
            self.master.plot_win.option[0].radio_one_var.set(2)
            self.master.plot_win.change()
            self.master.plot_win.option[1].radio_one_var.set(0)
            self.master.plot_win.change()
            self.master.plot_win.option[2].radio_one_var.set(0)
            self.master.plot_win.change()

        if which == "Violin Plot":
            self.master.data_win.data_process(dataset("tips.csv"))
            self.master.window.set(2)
            self.master.switch()
            self.master.plot_win.plot_1.set("Categorical")
            self.master.plot_win.plot_2["Categorical"].set("Violin Plot")
            self.master.plot_win.plot_change()
            self.master.plot_win.option[0].radio_one_var.set(2)
            self.master.plot_win.change()
            self.master.plot_win.option[1].radio_one_var.set(0)
            self.master.plot_win.change()
            self.master.plot_win.option[2].radio_one_var.set(0)
            self.master.plot_win.change()

        if which == "Bar Plot":
            self.master.data_win.data_process(dataset("tips.csv"))
            self.master.window.set(2)
            self.master.switch()
            self.master.plot_win.plot_1.set("Categorical")
            self.master.plot_win.plot_2["Categorical"].set("Bar Plot")
            self.master.plot_win.plot_change()
            self.master.plot_win.option[0].radio_one_var.set(2)
            self.master.plot_win.change()
            self.master.plot_win.option[1].radio_one_var.set(0)
            self.master.plot_win.change()
            self.master.plot_win.option[2].radio_one_var.set(0)
            self.master.plot_win.change()

        if which == "Scatter Plot":
            self.master.data_win.data_process(dataset("tips.csv"))
            self.master.window.set(2)
            self.master.switch()
            self.master.plot_win.plot_1.set("Relational")
            self.master.plot_win.plot_2["Relational"].set("Scatter Plot")
            self.master.plot_win.plot_change()
            self.master.plot_win.option[0].radio_one_var.set(0)
            self.master.plot_win.change()
            self.master.plot_win.option[1].radio_one_var.set(1)
            self.master.plot_win.change()
            self.master.plot_win.option[2].radio_one_var.set(3)
            self.master.plot_win.change()

        if which == "Line Plot":
            self.master.data_win.data_process(dataset("flights.csv"))
            self.master.window.set(2)
            self.master.switch()
            self.master.plot_win.plot_1.set("Relational")
            self.master.plot_win.plot_2["Relational"].set("Line Plot")
            self.master.plot_win.plot_change()
            self.master.plot_win.option[0].radio_one_var.set(0)
            self.master.plot_win.change()
            self.master.plot_win.option[1].radio_one_var.set(1)
            self.master.plot_win.change()
            self.master.plot_win.option[2].radio_one_var.set(2)
            self.master.plot_win.change()

        if which == "Regression Plot":
            self.master.data_win.data_process(dataset("tips.csv"))
            self.master.window.set(2)
            self.master.switch()
            self.master.plot_win.plot_1.set("Relational")
            self.master.plot_win.plot_2["Relational"].set("Regression Plot")
            self.master.plot_win.plot_change()
            self.master.plot_win.option[0].radio_one_var.set(0)
            self.master.plot_win.change()
            self.master.plot_win.option[1].radio_one_var.set(1)
            self.master.plot_win.change()

        if which == "Ultimate Plot":
            self.master.data_win.data_process(dataset("penguins.csv"))
            self.master.window.set(2)
            self.master.switch()
            self.master.plot_win.plot_1.set("Multiple")
            self.master.plot_win.plot_2["Multiple"].set("Ultimate Plot")
            self.master.plot_win.plot_change()
            self.master.plot_win.option[0].check_more_var[0].set(1)
            self.master.plot_win.option[0].check_more_var[2].set(1)
            self.master.plot_win.option[0].check_more_var[5].set(1)
            self.master.plot_win.option[0].check_more_var[6].set(1)
            self.master.plot_win.change()

        if which == "Pair Plot":
            self.master.data_win.data_process(dataset("penguins.csv"))
            self.master.window.set(2)
            self.master.switch()
            self.master.plot_win.plot_1.set("Multiple")
            self.master.plot_win.plot_2["Multiple"].set("Pair Plot")
            self.master.plot_win.plot_change()
            self.master.plot_win.option[0].check_more_var[0].set(1)
            self.master.plot_win.option[0].check_more_var[1].set(1)
            self.master.plot_win.option[0].check_more_var[2].set(1)
            self.master.plot_win.option[0].check_more_var[3].set(1)
            self.master.plot_win.change()
            self.master.plot_win.option[1].radio_one_var.set(1)
            self.master.plot_win.change()
            self.master.plot_win.option[2].radio_one_var.set(0)
            self.master.plot_win.change()

        if which == "Joint Plot":
            self.master.data_win.data_process(dataset("penguins.csv"))
            self.master.window.set(2)
            self.master.switch()
            self.master.plot_win.plot_1.set("Multiple")
            self.master.plot_win.plot_2["Multiple"].set("Joint Plot")
            self.master.plot_win.plot_change()
            self.master.plot_win.option[0].radio_one_var.set(0)
            self.master.plot_win.change()
            self.master.plot_win.option[1].radio_one_var.set(1)
            self.master.plot_win.change()
            self.master.plot_win.option[2].radio_one_var.set(1)
            self.master.plot_win.change()
            self.master.plot_win.option[3].radio_one_var.set(0)
            self.master.plot_win.change()

        if which == "Heatmap":
            self.master.data_win.data_process(dataset("flights.csv"))
            self.master.window.set(2)
            self.master.switch()
            self.master.plot_win.plot_1.set("Others")
            self.master.plot_win.plot_2["Others"].set("Heatmap")
            self.master.plot_win.plot_change()
            self.master.plot_win.option[0].radio_one_var.set(0)
            self.master.plot_win.change()
            self.master.plot_win.option[1].radio_one_var.set(1)
            self.master.plot_win.change()
            self.master.plot_win.option[2].radio_one_var.set(1)
            self.master.plot_win.change()

        if which == "FA Plot":
            self.master.data_win.data_process(dataset("iris.csv"))
            self.master.window.set(2)
            self.master.switch()
            self.master.plot_win.plot_1.set("Others")
            self.master.plot_win.plot_2["Others"].set("FA Plot")
            self.master.plot_win.plot_change()
            self.master.plot_win.option[0].check_more_var[0].set(1)
            self.master.plot_win.option[0].check_more_var[1].set(1)
            self.master.plot_win.option[0].check_more_var[2].set(1)
            self.master.plot_win.option[0].check_more_var[3].set(1)
            self.master.plot_win.change()
            self.master.plot_win.option[1].radio_one_var.set(1)
            self.master.plot_win.change()
            self.master.plot_win.option[2].radio_one_var.set(1)
            self.master.plot_win.change()

        if which == "PCA Plot":
            self.master.data_win.data_process(dataset("iris.csv"))
            self.master.window.set(2)
            self.master.switch()
            self.master.plot_win.plot_1.set("Others")
            self.master.plot_win.plot_2["Others"].set("PCA Plot")
            self.master.plot_win.plot_change()
            self.master.plot_win.option[0].check_more_var[0].set(1)
            self.master.plot_win.option[0].check_more_var[1].set(1)
            self.master.plot_win.option[0].check_more_var[2].set(1)
            self.master.plot_win.option[0].check_more_var[3].set(1)
            self.master.plot_win.change()
            self.master.plot_win.option[1].radio_one_var.set(1)
            self.master.plot_win.change()

        if which == "LDA Plot":
            self.master.data_win.data_process(dataset("iris.csv"))
            self.master.window.set(2)
            self.master.switch()
            self.master.plot_win.plot_1.set("Others")
            self.master.plot_win.plot_2["Others"].set("LDA Plot")
            self.master.plot_win.plot_change()
            self.master.plot_win.option[0].check_more_var[0].set(1)
            self.master.plot_win.option[0].check_more_var[1].set(1)
            self.master.plot_win.option[0].check_more_var[2].set(1)
            self.master.plot_win.option[0].check_more_var[3].set(1)
            self.master.plot_win.change()
            self.master.plot_win.option[1].radio_one_var.set(0)
            self.master.plot_win.change()


class Manual(ttk.Menubutton):

    def __init__(self, parent, master, text, width):
        
        # Initialize
        ttk.Menubutton.__init__(self, parent, text=text, width=width)
        self.master = master

        # Setup
        self.setup()

    def setup(self):

        self.menu_0 = tk.Menu(self)
        self.config(menu=self.menu_0)

        self.menu_0.add_command(label="Official Site", command=lambda: webbrowser.open("https://hikarimusic.github.io/BIOSTATS/"))
