# coding: utf-8

"""
    Kubeflow Pipelines API

    This file contains REST API specification for Kubeflow Pipelines. The file is autogenerated from the swagger definition.

    Contact: kubeflow-pipelines@google.com
    Generated by: https://openapi-generator.tech
"""


import pprint
import re  # noqa: F401

import six

from kfp_server_api.configuration import Configuration


class ApiPipelineSpec(object):
    """NOTE: This class is auto generated by OpenAPI Generator.
    Ref: https://openapi-generator.tech

    Do not edit the class manually.
    """

    """
    Attributes:
      openapi_types (dict): The key is attribute name
                            and the value is attribute type.
      attribute_map (dict): The key is attribute name
                            and the value is json key in definition.
    """
    openapi_types = {
        'pipeline_id': 'str',
        'pipeline_name': 'str',
        'workflow_manifest': 'str',
        'pipeline_manifest': 'str',
        'parameters': 'list[ApiParameter]'
    }

    attribute_map = {
        'pipeline_id': 'pipeline_id',
        'pipeline_name': 'pipeline_name',
        'workflow_manifest': 'workflow_manifest',
        'pipeline_manifest': 'pipeline_manifest',
        'parameters': 'parameters'
    }

    def __init__(self, pipeline_id=None, pipeline_name=None, workflow_manifest=None, pipeline_manifest=None, parameters=None, local_vars_configuration=None):  # noqa: E501
        """ApiPipelineSpec - a model defined in OpenAPI"""  # noqa: E501
        if local_vars_configuration is None:
            local_vars_configuration = Configuration()
        self.local_vars_configuration = local_vars_configuration

        self._pipeline_id = None
        self._pipeline_name = None
        self._workflow_manifest = None
        self._pipeline_manifest = None
        self._parameters = None
        self.discriminator = None

        if pipeline_id is not None:
            self.pipeline_id = pipeline_id
        if pipeline_name is not None:
            self.pipeline_name = pipeline_name
        if workflow_manifest is not None:
            self.workflow_manifest = workflow_manifest
        if pipeline_manifest is not None:
            self.pipeline_manifest = pipeline_manifest
        if parameters is not None:
            self.parameters = parameters

    @property
    def pipeline_id(self):
        """Gets the pipeline_id of this ApiPipelineSpec.  # noqa: E501

        Optional input field. The ID of the pipeline user uploaded before.  # noqa: E501

        :return: The pipeline_id of this ApiPipelineSpec.  # noqa: E501
        :rtype: str
        """
        return self._pipeline_id

    @pipeline_id.setter
    def pipeline_id(self, pipeline_id):
        """Sets the pipeline_id of this ApiPipelineSpec.

        Optional input field. The ID of the pipeline user uploaded before.  # noqa: E501

        :param pipeline_id: The pipeline_id of this ApiPipelineSpec.  # noqa: E501
        :type pipeline_id: str
        """

        self._pipeline_id = pipeline_id

    @property
    def pipeline_name(self):
        """Gets the pipeline_name of this ApiPipelineSpec.  # noqa: E501

        Optional output field. The name of the pipeline. Not empty if the pipeline id is not empty.  # noqa: E501

        :return: The pipeline_name of this ApiPipelineSpec.  # noqa: E501
        :rtype: str
        """
        return self._pipeline_name

    @pipeline_name.setter
    def pipeline_name(self, pipeline_name):
        """Sets the pipeline_name of this ApiPipelineSpec.

        Optional output field. The name of the pipeline. Not empty if the pipeline id is not empty.  # noqa: E501

        :param pipeline_name: The pipeline_name of this ApiPipelineSpec.  # noqa: E501
        :type pipeline_name: str
        """

        self._pipeline_name = pipeline_name

    @property
    def workflow_manifest(self):
        """Gets the workflow_manifest of this ApiPipelineSpec.  # noqa: E501

        Optional input field. The marshalled raw argo JSON workflow. This will be deprecated when pipeline_manifest is in use.  # noqa: E501

        :return: The workflow_manifest of this ApiPipelineSpec.  # noqa: E501
        :rtype: str
        """
        return self._workflow_manifest

    @workflow_manifest.setter
    def workflow_manifest(self, workflow_manifest):
        """Sets the workflow_manifest of this ApiPipelineSpec.

        Optional input field. The marshalled raw argo JSON workflow. This will be deprecated when pipeline_manifest is in use.  # noqa: E501

        :param workflow_manifest: The workflow_manifest of this ApiPipelineSpec.  # noqa: E501
        :type workflow_manifest: str
        """

        self._workflow_manifest = workflow_manifest

    @property
    def pipeline_manifest(self):
        """Gets the pipeline_manifest of this ApiPipelineSpec.  # noqa: E501

        Optional input field. The raw pipeline JSON spec.  # noqa: E501

        :return: The pipeline_manifest of this ApiPipelineSpec.  # noqa: E501
        :rtype: str
        """
        return self._pipeline_manifest

    @pipeline_manifest.setter
    def pipeline_manifest(self, pipeline_manifest):
        """Sets the pipeline_manifest of this ApiPipelineSpec.

        Optional input field. The raw pipeline JSON spec.  # noqa: E501

        :param pipeline_manifest: The pipeline_manifest of this ApiPipelineSpec.  # noqa: E501
        :type pipeline_manifest: str
        """

        self._pipeline_manifest = pipeline_manifest

    @property
    def parameters(self):
        """Gets the parameters of this ApiPipelineSpec.  # noqa: E501

        The parameter user provide to inject to the pipeline JSON. If a default value of a parameter exist in the JSON, the value user provided here will replace.  # noqa: E501

        :return: The parameters of this ApiPipelineSpec.  # noqa: E501
        :rtype: list[ApiParameter]
        """
        return self._parameters

    @parameters.setter
    def parameters(self, parameters):
        """Sets the parameters of this ApiPipelineSpec.

        The parameter user provide to inject to the pipeline JSON. If a default value of a parameter exist in the JSON, the value user provided here will replace.  # noqa: E501

        :param parameters: The parameters of this ApiPipelineSpec.  # noqa: E501
        :type parameters: list[ApiParameter]
        """

        self._parameters = parameters

    def to_dict(self):
        """Returns the model properties as a dict"""
        result = {}

        for attr, _ in six.iteritems(self.openapi_types):
            value = getattr(self, attr)
            if isinstance(value, list):
                result[attr] = list(map(
                    lambda x: x.to_dict() if hasattr(x, "to_dict") else x,
                    value
                ))
            elif hasattr(value, "to_dict"):
                result[attr] = value.to_dict()
            elif isinstance(value, dict):
                result[attr] = dict(map(
                    lambda item: (item[0], item[1].to_dict())
                    if hasattr(item[1], "to_dict") else item,
                    value.items()
                ))
            else:
                result[attr] = value

        return result

    def to_str(self):
        """Returns the string representation of the model"""
        return pprint.pformat(self.to_dict())

    def __repr__(self):
        """For `print` and `pprint`"""
        return self.to_str()

    def __eq__(self, other):
        """Returns true if both objects are equal"""
        if not isinstance(other, ApiPipelineSpec):
            return False

        return self.to_dict() == other.to_dict()

    def __ne__(self, other):
        """Returns true if both objects are not equal"""
        if not isinstance(other, ApiPipelineSpec):
            return True

        return self.to_dict() != other.to_dict()
