import pytest
from tinfoil.attestation.attestation import verify_sev_attestation

def test_sev_verify():
    att = {
        "format": "https://tinfoil.sh/predicate/sev-snp-guest/v1",
        "body": "AgAAAAAAAAAAAAMAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAQAAAAEAAAAHAAAAAAAOSAEAAAAAAAAAAAAAAAAAAAA2NTA4M2U1OTA0YzAyNzNiNjQ0YWQ5MGU1MWUxMmE4ZDc2ZmUwN2YyYWI4YWIxNGQ3NjAxMWIzZTljN2RjYWE3/xjwoozRULthI6omat8HtO2sit6UIIXxtSg9N3UO6SSsFhmcK/7H1Cpqs5ZDVGhfAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAdBxIi99geB/i1RZESMaqxQ16ZvxamaRZFtfTvS1Lxyv//////////////////////////////////////////BwAAAAAADkgAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAADyerBPBb0BVIg1GpCjfyjOa7GVEfbmBlI2UlOv2mBy2PUlhAoxzCPRyGlUox+FWyw/5T1fgVISjEAzuoWzsKeXBwAAAAAADkgVNwEAFTcBAAcAAAAAAA5IAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAhZYloXhwZZb828qeGleqZN4eGkiOvEyJUM482aIEIgityc5bRqJSr6aRTOBRL4AuAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAMXv4mBcfDUnlLzSpArjSFiBY/exLh+FuPJ5LI5ieVp6eGvUCXEZ5maXMpMck33YMAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAA="
    }

    verification = verify_sev_attestation(att["body"])

    # Expected certificate fingerprint
    expected_key_fp = "65083e5904c0273b644ad90e51e12a8d76fe07f2ab8ab14d76011b3e9c7dcaa7"

    # Assertions
    assert expected_key_fp == verification.public_key_fp
    assert 1 == len(verification.measurement.registers)
    assert "ff18f0a28cd150bb6123aa266adf07b4edac8ade942085f1b5283d37750ee924ac16199c2bfec7d42a6ab3964354685f" == verification.measurement.registers[0]

if __name__ == '__main__':
    pytest.main() 