from com.inductiveautomation.ignition.common import BasicDataset
from com.inductiveautomation.ignition.common.model import Version
from com.inductiveautomation.ignition.common.script.builtin import DatasetUtilities, SystemUtilities
from com.inductiveautomation.ignition.common.util import LoggerEx
from java.lang import Thread
from java.util import Date
from typing import Any, Callable, Dict, Iterable, List, Optional, Union

PyDataSet = DatasetUtilities.PyDataSet
RequestImpl = SystemUtilities.RequestImpl
String = Union[str, unicode]

def audit(action: Optional[String] = ..., actionValue: Optional[String] = ..., auditProfile: String = ..., actor: Optional[String] = ..., actorHost: String = ..., originatingSystem: Optional[List[String]] = ..., eventTimestamp: Optional[Date] = ..., originatingContext: int = ..., statusCode: int = ...) -> None: ...
def beep() -> None: ...
def execute(commands: List[String]) -> None: ...
def exit(force: bool = ...) -> None: ...
def getAvailableLocales() -> List[String]: ...
def getAvailableTerms() -> List[String]: ...
def getClientId() -> unicode: ...
def getConnectTimeout() -> int: ...
def getConnectionMode() -> int: ...
def getEdition() -> String: ...
def getGatewayAddress() -> unicode: ...
def getGatewayStatus(gatewayAddress: String, connectTimeoutMillis: Optional[int] = ..., socketTimeoutMillis: Optional[int] = ..., bypassCertValidation: bool = ...) -> unicode: ...
def getGlobals() -> Dict[String, Any]: ...
def getInactivitySeconds() -> long: ...
def getLocale() -> String: ...
def getLogger(name: String) -> LoggerEx: ...
def getProjectName() -> String: ...
def getProperty(propertyName: String) -> Optional[unicode]: ...
def getReadTimeout() -> int: ...
def getSessionInfo(usernameFilter: Optional[String] = ..., projectFilter: Optional[String] = ...) -> PyDataSet: ...
def getSystemFlags() -> int: ...
def getVersion() -> Version: ...
def invokeAsynchronous(function: Callable, args: Optional[Iterable[Any]] = ..., kwargs: Optional[Dict[String, Any]] = ..., description: Optional[String] = ...) -> Thread: ...
def invokeLater(function: Callable[..., Any], delay: int = ...) -> None: ...
def jsonDecode(jsonString: String) -> Any: ...
def jsonEncode(pyObj: Iterable[Any], indentFactor: int = ...) -> String: ...
def modifyTranslation(term: String, translation: String, locale: String = ...) -> None: ...
def playSoundClip(wav: Any, volume: float = ..., wait: bool = ...) -> None: ...
def queryAuditLog(auditProfileName: Optional[String] = ..., startDate: Optional[Date] = ..., endDate: Optional[Date] = ..., actorFilter: Optional[String] = ..., actionFilter: Optional[String] = ..., targetFilter: Optional[String] = ..., valueFilter: Optional[String] = ..., systemFilter: Optional[String] = ..., contextFilter: Optional[int] = ...) -> BasicDataset: ...
def retarget(project: String, addresses: Optional[Union[String, List[String]]] = ..., params: Optional[Dict[String, Any]] = ..., windows: Optional[String] = ...) -> None: ...
def sendMessage(project: String, messageHandler: String, payload: Optional[Dict[String, Any]] = ..., scope: Optional[String] = ..., clientSessionId: Optional[String] = ..., user: Optional[String] = ..., hasRole: Optional[String] = ..., hostName: Optional[String] = ..., remoteServers: Optional[List[String]] = ...) -> List[String]: ...
def sendRequest(project: String, messageHandler: String, payload: Optional[Dict[String, Any]] = ..., hostName: Optional[String] = ..., remoteServer: Optional[String] = ..., timeoutSec: Optional[String] = ...) -> Any: ...
def sendRequestAsync(project: String, messageHandler: String, payload: Optional[Dict[String, Any]] = ..., hostName: Optional[String] = ..., remoteServer: Optional[String] = ..., timeoutSec: Optional[int] = ..., onSuccess: Optional[Callable[..., Any]] = ..., onError: Optional[Callable[..., Any]] = ...) -> RequestImpl: ...
def setConnectTimeout(connectTimeout: int) -> None: ...
def setConnectionMode(mode: int) -> None: ...
def setLocale(locale: String) -> None: ...
def setLoggingLevel(loggerName: String, loggerLevel: String) -> None: ...
def setReadTimeout(readTimeout: int) -> None: ...
def threadDump() -> unicode: ...
def translate(term: String, locale: Optional[String] = ..., strict: Optional[bool] = ...) -> String: ...
