from com.inductiveautomation.ignition.common.messages import UIResponse
from com.inductiveautomation.ignition.common.user import PyUser, UserSourceMeta
from com.inductiveautomation.ignition.common.user.schedule import AbstractScheduleModel, HolidayModel, ScheduleAdjustment
from java.util import Date
from typing import List, Optional, Union

String = Union[str, unicode]

def addCompositeSchedule(name: String, scheduleOne: String, scheduleTwo: String, description: Optional[String] = ...) -> UIResponse: ...
def addHoliday(holiday: HolidayModel) -> UIResponse: ...
def addRole(userSource: String, role: String) -> UIResponse: ...
def addSchedule(schedule: AbstractScheduleModel) -> UIResponse: ...
def addUser(userSource: String, user: PyUser) -> UIResponse: ...
def createScheduleAdjustment(startDate: Date, endDate: Date, isAvailable: bool, note: String) -> ScheduleAdjustment: ...
def editHoliday(holidayName: String, holiday: HolidayModel) -> UIResponse: ...
def editRole(userSource: String, oldName: String, newName: String) -> UIResponse: ...
def editSchedule(scheduleName: String, schedule: AbstractScheduleModel) -> UIResponse: ...
def editUser(userSource: String, user: PyUser) -> UIResponse: ...
def getHoliday(holidayName: String) -> Optional[HolidayModel]: ...
def getHolidayNames() -> List[String]: ...
def getHolidays() -> List[HolidayModel]: ...
def getNewUser(userSource: String, username: String) -> PyUser: ...
def getRoles(userSource: String) -> List[String]: ...
def getSchedule(scheduleName: String) -> Optional[AbstractScheduleModel]: ...
def getScheduleNames() -> List[String]: ...
def getScheduledUsers(userSource: String, date: Optional[Union[Date, int]] = ...) -> List[PyUser]: ...
def getSchedules() -> List[AbstractScheduleModel]: ...
def getUser(userSource: String, username: String) -> PyUser: ...
def getUserSources() -> List[UserSourceMeta]: ...
def getUsers(userSource: String) -> List[PyUser]: ...
def isUserScheduled(user: PyUser, date: Optional[Union[Date, int]] = ...) -> bool: ...
def removeHoliday(holidayName: String) -> UIResponse: ...
def removeRole(userSource: String, role: String) -> UIResponse: ...
def removeSchedule(scheduleName: String) -> UIResponse: ...
def removeUser(userSource: String, username: String) -> UIResponse: ...
