from com.inductiveautomation.ignition.common import BasicDataset
from com.inductiveautomation.ignition.common.script.builtin import DatasetUtilities
from java.util import Date, Locale
from typing import Any, Dict, List, Optional, Type, Union

ColType = Union[Date, float, int, str, unicode]
PyDataSet = DatasetUtilities.PyDataSet
String = Union[str, unicode]

def addColumn(dataset: BasicDataset, colIndex: int, col: List[Any], colName: String, colType: Type[ColType]) -> BasicDataset: ...
def addRow(dataset: BasicDataset, rowIndex: int, row: List[Any]) -> BasicDataset: ...
def addRows(dataset: BasicDataset, rowIndex: int, rows: List[List[Any]]) -> BasicDataset: ...
def appendDataset(dataset1: BasicDataset, dataset2: BasicDataset) -> BasicDataset: ...
def clearDataset(dataset: BasicDataset) -> BasicDataset: ...
def dataSetToHTML(showHeaders: bool, dataset: BasicDataset, title: String) -> String: ...
def deleteRow(dataset: BasicDataset, rowIndex: int) -> BasicDataset: ...
def deleteRows(dataset: BasicDataset, rowIndices: List[int]) -> BasicDataset: ...
def exportCSV(filename: String, showHeaders: bool, dataset: BasicDataset) -> String: ...
def exportExcel(filename: String, showHeaders: bool, dataset: List[BasicDataset], nullsEmpty: bool = ...) -> String: ...
def exportHTML(filename: String, showHeaders: bool, dataset: BasicDataset, title: String) -> String: ...
def filterColumns(dataset: BasicDataset, columns: Union[List[String], List[int]]) -> BasicDataset: ...
def formatDates(dataset: BasicDataset, dateFormat: String, locale: Optional[Locale] = ...) -> BasicDataset: ...
def fromCSV(csv: String) -> BasicDataset: ...
def getColumnHeaders(dataset: BasicDataset) -> List[String]: ...
def setValue(dataset: BasicDataset, rowIndex: int, columnName: String, value: Any) -> BasicDataset: ...
def sort(dataset: BasicDataset, keyColumn: Union[String, int], ascending: bool = ...) -> BasicDataset: ...
def toCSV(dataset: BasicDataset, showHeaders: bool = ..., forExport: bool = ..., localized: bool = ...) -> String: ...
def toDataSet(*args: Any) -> BasicDataset: ...
def toExcel(showHeaders: bool, dataset: List[BasicDataset], nullsEmpty: bool = ..., sheetNames: Optional[List[String]] = ...) -> Any: ...
def toPyDataSet(dataset: BasicDataset) -> PyDataSet: ...
def updateRow(dataset: BasicDataset, rowIndex: int, changes: Dict[String, Any]) -> BasicDataset: ...
