from enum import Enum
from java.lang import Object
from java.util import Date
from typing import Any

class QualifiedValue:
    def getQuality(self) -> None: ...
    def getTimestamp(self) -> None: ...
    def getValue(self) -> None: ...

class Quality:
    def getDescription(self) -> None: ...
    def getLevel(self) -> None: ...
    def getName(self) -> None: ...
    def getQualityCode(self) -> None: ...
    def isGood(self) -> None: ...
    class Level(Enum):
        Bad: int
        Good: int
        Unknown: int
        def values(self) -> None: ...

class QualityCode(Object):
    Bad: QualityCode
    Bad_AccessDenied: QualityCode
    Bad_AggregateNotFound: QualityCode
    Bad_DatabaseNotConnected: QualityCode
    Bad_Disabled: QualityCode
    Bad_Failure: QualityCode
    Bad_GatewayCommOff: QualityCode
    Bad_LicenseExceeded: QualityCode
    Bad_NotConnected: QualityCode
    Bad_NotFound: QualityCode
    Bad_OutOfRange: QualityCode
    Bad_ReadOnly: QualityCode
    Bad_Stale: QualityCode
    Bad_ReferenceNotFound: QualityCode
    Bad_TrialExpired: QualityCode
    Bad_Unauthorized: QualityCode
    Bad_Unsupported: QualityCode
    Error: QualityCode
    Error_Configuration: QualityCode
    Error_CycleDetected: QualityCode
    Error_DatabaseQuery: QualityCode
    Error_Exception: QualityCode
    Error_ExpressionEval: QualityCode
    Error_Formatting: QualityCode
    Error_InvalidPathSyntax: QualityCode
    Error_IO: QualityCode
    Error_ScriptEval: QualityCode
    Error_TagExecution: QualityCode
    Error_TimeoutExpired: QualityCode
    Error_TypeConversion: QualityCode
    Good: QualityCode
    Good_Backfill: QualityCode
    Good_Initial: QualityCode
    Good_Overload: QualityCode
    Good_Provisional: QualityCode
    Good_Unspecified: QualityCode
    Good_WritePending: QualityCode
    Uncertain: QualityCode
    Uncertain_LastKnownValue: QualityCode
    Uncertain_InitialValue: QualityCode
    Uncertain_DataSubNormal: QualityCode
    Uncertain_EngineeringUnitsExceeded: QualityCode
    Uncertain_IncompleteOperation: QualityCode
    def __init__(self, *args) -> None: ...
    def derive(self, diagnosticMessage) -> None: ...
    def getCode(self) -> None: ...
    def getDiagnosticMessage(self) -> None: ...
    def getLevel(self) -> None: ...
    def getName(self) -> None: ...
    def isBad(self) -> None: ...
    def isBadOrError(self) -> None: ...
    def isError(self) -> None: ...
    def isGood(self) -> None: ...
    def isNotGood(self) -> None: ...
    def isUncertain(self) -> None: ...
    class Level(Object):
        def __init__(self) -> None: ...
        def code(self, userCode) -> None: ...
        @staticmethod
        def valueOf(name) -> None: ...
        @staticmethod
        def values() -> None: ...

class BasicQualifiedValue(QualifiedValue, Object):
    quality: QualityCode
    timestamp: Date
    value: Any
    def __init__(self, *arg) -> None: ...
    @staticmethod
    def fromObject(obj) -> None: ...
    def getQuality(self): ...
    def getTimestamp(self): ...
    def getValue(self): ...
    def setQuality(self, code) -> None: ...
    def setTimestamp(self, timestamp) -> None: ...
    def setValue(self, value) -> None: ...
    @staticmethod
    def unwrap(obj) -> None: ...
    @staticmethod
    def updateTimestamp(copy) -> None: ...
    @staticmethod
    def valueOf(obj) -> None: ...
